PRO lsh_mlt_3d, samp, T0=t0, T1=t1, INST=inst, MODE=mode, BAND=band, $
             DETECTOR=detector, SHOW=show, REMOVE=remove, ORBIT_ONLY=orbit_only, MOVIE=movie

  ; save current device name

  devname = !D.NAME

  ; come back out to top level

  ON_ERROR, 0 ; stay at error point

  LOADCT, 3

  IF KEYWORD_SET(show) THEN BEGIN
    !P.MULTI = [0,1,4,0,0]
    !P.REGION=0
    !P.POSITION=0
  ENDIF

  IF NOT KEYWORD_SET(samp) THEN BEGIN

    hist_luts = (['ABC','BC','HBC'])([0, 1, 2, 0,  0, 1, 2, 0,  0, 1, 2, 2,  0, 1, 2, 0,  0, 1, 2, 0,  0, 2, 2, 0])

    ; process times

    IF KEYWORD_SET(t0) THEN tai0 = utc2tai(anytim2utc (t0))

    IF KEYWORD_SET(t1) THEN tai1 = utc2tai(anytim2utc (t1))

    ; get data file names

    ; default instrument to 'IES'

    IF NOT KEYWORD_SET(inst) THEN inst = 'IES'

    IF inst NE 'IES' AND inst NE 'HISTe' AND inst NE 'HISTp' AND inst NE 'IPS' THEN inst = 'IES'

    filter = 'SURVEY_' + inst + '_'

    IF inst EQ 'IES' THEN filter = 'CLEAN_' + filter

    filter = 'PO_CEP_RAL_'+filter

    ; get data directory

    data_dir = ies_get_dir(inst,/POLAR)

    ; choose data files

    IF NOT KEYWORD_SET(t0) AND NOT KEYWORD_SET(t1) THEN BEGIN

      data_files = PICKFILE ( PATH=data_dir, FILTER=filter+'*.DAT*', /READ, $
                                      TITLE='Select input data file' )

      IF data_files EQ '' THEN MESSAGE, 'No data files found'

    ENDIF ELSE data_files = filter+'*.DAT*'

    data_files = FINDFILE( concat_dir ( data_dir, strip_dirname(data_files)), COUNT=count)

    IF count EQ 0 THEN MESSAGE, 'No data files found'

    unfinished = 0

    IF KEYWORD_SET(show) THEN str = '' ELSE str = 'g'

    FOR f = 0, N_ELEMENTS(data_files)-1 DO BEGIN

      data_file = data_files(f)

      ; get tai time

      year  = STRMID(data_file,STRPOS(data_file,filter)+STRLEN(filter),4)
      month = STRMID(data_file,STRPOS(data_file,filter)+STRLEN(filter)+4,2)
      day   = STRMID(data_file,STRPOS(data_file,filter)+STRLEN(filter)+6,2)

      tai = utc2tai ( anytim2utc( year+'/'+month+'/'+day ) )

      ok = 1
      IF KEYWORD_SET(t0) THEN ok = ok AND tai GE tai0
      IF KEYWORD_SET(t1) THEN ok = ok AND tai LE tai1

      IF ok THEN BEGIN

        ; get ephemeris data for day

        ephem = get_ephem ( tai )

        ; check ephemeris data available

        IF N_TAGS(ephem) GT 0 THEN BEGIN

          IF NOT KEYWORD_SET(orbit_only) THEN BEGIN

            ; restore file

            ies_restore_gzip, data_file, input_header, input_data, /CHECK, REMOVE=remove

            ; convert to count rate per channel

            ; reform output array

            output_array = REFORM ( input_data.data, input_header.nsectors, input_header.ndetectors, input_header.nbands, input_header.npoints)

            output_chans = input_header.ch_positions*input_header.energy_cal(0)

            IF N_ELEMENTS(input_header.energy_cal) GT 1 THEN output_chans = output_chans + input_header.energy_cal(1)

            lut_list = ies_lut_list(input_data.lut, input_data.nluts)

            IF input_header.div NE 0 THEN ies_div, input_data.lut, input_header.nbands, input_header.ndetectors, output_chans, output_array, /REVERSE

            input_data.data = output_array

            ; default detector to 0

            IF N_ELEMENTS(detector) EQ 0 THEN BEGIN
              detector = 0
              IF inst EQ 'IES' THEN detector = 3 < (input_header.ndetectors-1)
              IF inst EQ 'IPS' THEN detector = 2 < (input_header.ndetectors-1)
            ENDIF ELSE detector =  0 > detector < (input_header.ndetectors-1)

            IF f EQ 0 THEN BEGIN
              PRINT, 'ELEMENT NO. = ', detector, ' DETECTOR NO. = ', input_header.detectors(detector),$
                              ' DETECTOR = ', input_header.ptitle(detector)
            ENDIF

            ; set no. of channels

            IF STRPOS(input_header.datatype,'HISTe') GE 0 AND KEYWORD_SET(mode) THEN BEGIN

              IF N_ELEMENTS(mode) EQ 1 THEN $
                list = WHERE ( hist_luts(input_data.lut) EQ mode[0], count) $
              ELSE $
                list = WHERE ( hist_luts(input_data.lut) EQ mode[0] OR hist_luts(input_data.lut) EQ mode[1], count)

              ; remove last point if present

              IF list[count-1] EQ input_header.npoints-1 THEN BEGIN

                count = count - 1

                IF count GT 0 THEN list = list [0:count-1]

              ENDIF

              IF count EQ 0 THEN PRINT,'No data of mode : ', mode

            ENDIF ELSE BEGIN

              count = input_header.npoints-1
              IF count GT 0 THEN list = INDGEN(count)

            ENDELSE

            IF count GT 0 THEN BEGIN

              ; spin average data

              xdata = REFORM(TOTAL ( input_data(list).data(*,detector,*), 1 ))

              ; interpolate ephemeris data to get L shell values for each data sample

              times = (input_data[0:input_header.npoints-2].time+input_data[1:input_header.npoints-1].time)/2

              lshells = INTERPOL ( ephem.l, utc2tai(anytim2utc(ephem.date)) + ephem.time*3600.0d0, times[list] )
              mlats   = INTERPOL ( ephem.mlat, utc2tai(anytim2utc(ephem.date)) + ephem.time*3600.0d0, times[list] )
              mlts    = INTERPOL ( ephem.edmlt, utc2tai(anytim2utc(ephem.date)) + ephem.time*3600.0d0, times[list] )

              nbands = input_header.nbands
nbands=1
            ENDIF

          ENDIF ELSE BEGIN

            lshells = ephem.l
            mlats   = ephem.mlat
            mlts    = ephem.edmlt

            nbands = 0
            count = N_ELEMENTS(lshells)

          ENDELSE

          IF count GT 0 THEN BEGIN

            ils = ACOS(SQRT(1./lshells))*180/!PI

            IF KEYWORD_SET(show) THEN BEGIN
              window, 0
              PLOT, lshells, yrange=[0,50], TITLE = 'Lsh'
              PLOT, mlats, yrange=[-90,90], TITLE = 'Mlat'
              PLOT, mlts, yrange=[0,24], TITLE = 'MLT'
              PLOT, ils, yrange=[0,90], TITLE = 'Ilat'
            ENDIF

            IF str NE 'g' AND str NE 'G' AND KEYWORD_SET(show) THEN BEGIN
              str = get_kbrd(1)
              IF str EQ 's' THEN STOP
            ENDIF

            ; set up array

            IF NOT KEYWORD_SET(samp) THEN BEGIN
              xbn = 180					; *** Define the size of the image array
              ybn = 180
              zbn = 180
              samp = FLTARR(xbn,ybn,zbn,1+nbands)		; *** Cumulative sampling array
            ENDIF

            ; *** Convert to bin numbers

            xb  = FIX( 2*(90.0-ils)*COS(mlts*!PI/12) + 90 )
            yb  = FIX( 2*(90.0-ils)*SIN(mlts*!PI/12) + 90 )
            zb  = FIX( mlats+90)

            ; clip

            list = WHERE( xb GE 0 AND xb LT xbn AND yb GE 0 AND yb LT ybn AND zb GE 0 AND zb LT zbn, count)

            IF count GT 0 THEN BEGIN

              xb = xb[list]
              yb = yb[list]
              zb = zb[list]

              IF NOT KEYWORD_SET(orbit_only) THEN FOR kk = 0, count-1 DO $
                samp[xb[kk],yb[kk],zb[kk],1:*] = samp[xb[kk],yb[kk],zb[kk],1:*] + TOTAL(xdata[*,list[kk]])

              FOR kk = 0, count-1 DO samp[xb[kk],yb[kk],zb[kk],0] = samp[xb[kk],yb[kk],zb[kk],0] + 1

            ENDIF

          ENDIF

        ENDIF ; ephemeris data available

      ENDIF ; ok

    ENDFOR

    IF KEYWORD_SET(show) THEN !P.MULTI = 0

  ENDIF

  IF KEYWORD_SET(movie) THEN BEGIN

    PRINT, 'DO DISPLAY CALCULATION'

    nd = (SIZE(samp))(0)
    nx = (SIZE(samp))(1)
    ny = (SIZE(samp))(2)
    nz = (SIZE(samp))(3)

    IF nd GT 3 THEN IF (SIZE(samp))(4) GT 2 THEN images = TOTAL(samp(*,*,*,1:*),4)/(samp(*,*,*,0)>1) $
      ELSE images = samp(*,*,*,1)/(samp(*,*,*,0)>1) ELSE images = samp  ;

    images = BYTSCL(ALOG10(images > 1))

    PRINT, 'DO MOVIE'

    XINTERANIMATE, SET=[nx,ny,nz]

    FOR z = 0, nz-1 DO BEGIN

       ; sum over energies

      XINTERANIMATE, IMAGE=images(*,*,z), FRAME=z

    ENDFOR

    XINTERANIMATE, 1, /TRACK, TITLE='IL/MLT/MLAT'

  ENDIF

END

PRO mlat_display, mlat, VOX=vox, IMG=img, ZMIN=zmin, OPACITY=opacity, VMAX=vmax, POSTSCRIPT=postscript

  IF NOT KEYWORD_SET(vox) THEN BEGIN
    vox = mlat(*,*,*,1)/(mlat(*,*,*,0)>1)
    vox(0,0,*) = 0
    vox(*,0,0) = 0
    vox(0,*,0) = 0
  ENDIF

  IF NOT KEYWORD_SET(zmin) THEN zmin = 90
  IF NOT KEYWORD_SET(vmax) THEN vmax = 1e10

  IF NOT KEYWORD_SET(img) THEN img = TOTAL(vox[*,*,0>zmin<179:*],3)

;  nx = (SIZE(vox))(1)
;  ny = (SIZE(vox))(2)
;  nz = (SIZE(vox))(3)

  ; set up 3D coordinate system

  SET_PLOT, 'Z'
  DEVICE, SET_RESOLUTION=[640,512]
  ERASE

;  SCALE3, XRANGE=[0,180], YRANGE=[0,180], ZRANGE=[0,180]

  SURFACE, [[0, 180],[0,180]], CHARSIZE=2,$
            [0,180], [0,180], XST=1,YST=1,ZAXIS=1,  $
            /SAVE,/NODATA, TITLE='IL/MLT/MLAT plot', $
            XTITLE='x-axis',YTITLE='y-axis',ZTITLE='z-axis'

  POLYFILL, [[0,0],[180,0],[180,180],[0,180]], /T3D, PATTERN=BYTSCL(ALOG10(img>1)),  $
             IMAGE_COORD=[[0,0],[ 180,0],[180,180],[0,180]]

;  AXIS,ZAXIS=0,/T3D

  zpix  = TVRD()
  zbuff = TVRD(/WORDS,/CHAN)

  IF KEYWORD_SET(postscript) THEN BEGIN

    IF datatype(postscript) NE 'STR' THEN BEGIN
      file=PICKFILE(TITLE='Select file for POSTSCRIPT output',FILTER='*.ps', PATH=ies_get_dir('PS',/POLAR) )
    ENDIF ELSE file = postscript

    IF file EQ '' THEN BEGIN
      MESSAGE, 'No data file given', /CONT, /TRACEBACK
      RETURN
    ENDIF

    ; check if has directory defined

    IF STRLEN(strip_dirname(file)) EQ STRLEN(file) THEN file = concat_dir(ies_get_dir('PS',/POLAR),file)

    DEVICE, Z_BUFFER=0

  ENDIF ELSE BEGIN

    SET_PLOT, devname

    WINDOW, /FREE, XSIZE=640, YSIZE=512

  ENDELSE

;  IF KEYWORD_SET(opacity) THEN rgbo = [[INDGEN(256)],[REPLICATE(256*opacity,256)]]

  TVSCL, VOXEL_PROJ( BYTSCL(ALOG10(vox>1)), $
                     ZPIX=zpix, ZBUFF=zbuff, CUTTING_PLANE=[[0,0,1,-zmin]] $ ;,[0,0,-1,120]] $ ;[-1,-1,0,180]] $
                     )
  IF KEYWORD_SET(postscript) THEN BEGIN

    pic = TVRD()

    SET_PLOT, 'PS'

    IF KEYWORD_SET(portrait) THEN BEGIN
      DEVICE, /COLOR, BITS=8, FILE=file, XOFFSET=0.6, YOFFSET=0.5, XSIZE=19.9, YSIZE=26.5, /PORTRAIT
    ENDIF ELSE BEGIN
      DEVICE, FILE=file, BITS=8, /LANDSCAPE, /COLOR, XOFFSET=0.5, YOFFSET=27.5, XSIZE=27, YSIZE=19.9
    ENDELSE

    ; fix color table

    LOADCT, 39

    TV, pic

    DEVICE, /CLOSE
    SET_PLOT,devname

  ENDIF

END


PRO test, mlat, VOX=vox, IMG=img

  IF NOT KEYWORD_SET(vox) THEN vox = mlat(*,*,*,1)/(mlat(*,*,*,0)>1)

  IF NOT KEYWORD_SET(img) THEN img = TOTAL(vox,3)

  ; plot data
window,0,xsize=512,ysize=512

  nx = (SIZE(img))(1)
  ny = (SIZE(img))(2)

  x = FINDGEN(nx)
  y = FINDGEN(ny)

  SURFACE, [[0, 180],[0,180]], CHARSIZE=2,$
            [0,180], [0,180], XST=1,YST=1,ZAXIS=1,  $
            /SAVE,/NODATA, TITLE='IL/MLT/MLAT plot',  $
            XTITLE='x-axis',YTITLE='y-axis',ZTITLE='z-axis', /NOERASE


  xorig = [x[0],x[nx-1],x[0],x[nx-1]]     ;4 corners X locns in image
  yorig = [y[0],y[0],y[ny-1],y[ny-1]]     ;4 corners Y locns

  xc = xorig * !x.s[1] + !x.s[0]  ;Normalized X coord
  yc = yorig * !y.s[1] + !y.s[0]  ;Normalized Y
                          ;To Homogeneous coords,  and transform
  p = [[xc],[yc],[fltarr(4)],[replicate(1,4)]] # !P.T
  u = p[*,0]/p[*,3] * !d.x_vsize  ;Scale U coordinates to device
  v = p[*,1]/p[*,3] * !d.y_vsize  ;and V
  ;
  ;       Now, the 4 corners of the place for the image are in u and v
  ;
  u0 = min(u) & v0 = min(v)               ;Lower left corner of screen box
  su = max(u)- u0+1 & sv = max(v) - v0+1  ;Size of new image
  if (!d.flags and 1) eq 1 then begin     ;Scalable pixels (PostScript)?
          fact = 50               ;Yes, shrink it
          miss = 255              ;Missing values are white
          c_color=[0,0]           ;Contour in only one color, black
   endif else begin
          fact = 1                ;one pixel/output coordinate
            miss = 0                ;missing is black
        c_color=[150,200,250]
   endelse

  if (!d.flags and 512) ne 0 then $  ;White background?
          miss = 255 else miss = 0
  ;
          ;Get polynomial coeff for warp
  if !d.n_colors gt 2 then top = !d.n_colors -1 else top = 255

  POLYWARP, xorig, yorig, (u-u0)/fact, (v-v0)/fact, 1, kx, ky

  A = POLY_2D(BYTSCL(img, top=top), kx, ky, KEYWORD_SET(interp), $
                 su/fact,sv/fact, missing = miss) ;Warp it
  TV, a, u0, v0, xsize = su, ysize = sv, order=0

                        ; Redraw front-right Z axis.
  SURFACE, [[0, 180],[0,180]], /NOERASE, CHARSIZE=2,$
            [0,180], [0,180], XST=1,YST=1,ZAXIS=1,  $
            /SAVE,/NODATA, TITLE='IL/MLT/MLAT plot',  $
            XTITLE='x-axis',YTITLE='y-axis',ZTITLE='z-axis'
  a = tvrd()
;AXIS,ZAXIS=0,/T3D
set_plot,'z'
device,/z_buffer
  SURFACE, [[0, 180],[0,180]], /NOERASE, CHARSIZE=2,$
            [0,180], [0,180], XST=1,YST=1,ZAXIS=1,  $
            /SAVE,/NODATA, TITLE='IL/MLT/MLAT plot',  $
            XTITLE='x-axis',YTITLE='y-axis',ZTITLE='z-axis'

zbuff=tvrd(/words,/chan)

set_plot,devname

  tv,voxel_proj(vox,zpix=a,zbuff=zbuff)

END