; Display a colour scale

PRO disp_cscale, x, y, dx, dy, r, LOG=log, _EXTRA=inherit

        IF ( KEYWORD_SET(log) ) THEN log=1 ELSE log=0
        IF ( log EQ 1 ) THEN r1 = 10^r ELSE r1 = r
        m = !P.MULTI                                    ; Save status of multi
	p = !P.POSITION

        !P.POSITION = [x,y,x+dx,y+dy]                   ; Set position
        PLOT, [0,1],r1, YLOG=log, XSTYLE=5, YSTYLE=1, _EXTRA=inherit , /NOERASE, /NODATA
        x0 = !P.CLIP(0)+1                               ; Find position in device units
        y0 = !P.CLIP(1)+1
        dx1 = !P.CLIP(2)-x0+1
        dy1 = !P.CLIP(3)-y0

	; Could generate a 1 by n array for the colour table but
	; this can cause problems on some scalable pixel devices
	; so generate 2 by n array to be safe.

        b = CONGRID(BINDGEN(1,!D.N_COLORS-1),2,!D.N_COLORS-1)           ; Generate colour bar
        IF ( !D.FLAGS AND 1 ) THEN BEGIN
                TV, b, x0, y0, XSIZE=dx1, YSIZE=dy1     ; For PS use scaled pixels
        ENDIF ELSE BEGIN
                TV, CONGRID(b,dx1,dy1), x0, y0          ; Otherwise scale first
        ENDELSE
        PLOTS, [0,1,1,0,0],[r1(0),r1(0),r1(1),r1(1),r1(0)]      ; Draw the border

	!P.POSITION = p
        !P.MULTI = m                                    ; Restore status of multi
END

PRO lsh_mlt_plot, struct, IMAGE = samp, TITLE = mtitle, POSTSCRIPT=postscript, PORTRAIT=portrait, BAND=band, $
                          IPS=ips, IES=ies, HISTe=histe, HISTp=histp, RANGE =range

  ; save current device name

  devname = !D.NAME

  ON_ERROR, 0

  IF NOT KEYWORD_SET(samp) THEN BEGIN

    lpoints = (SIZE(struct[0,0].data))(2)
    npoints = N_ELEMENTS(struct[0,*])
    nbands  = (SIZE(struct[0,0].data))(1)

    xbn = 180					; *** Define the size of the image array
    ybn = 180
    samp = FLTARR(xbn,ybn,1+nbands)				; *** Cumulative sampling array

    il = [FLTARR(10),ACOS(SQRT(10/(10.5+FINDGEN(lpoints-10))))*180/!PI] ; centre of lshell  bin

    ; sum over energies

    FOR k = 0, npoints-1 DO BEGIN

      ; get ephemeris data for sample

      ephem = get_ephem(struct[k].time[0])

      mlt = ephem.edmlt
      mlt_time = ephem.time

      IF (mlt_time[1439]) LT struct[k].time[lpoints] THEN BEGIN

        ephem = get_ephem(struct[k].time[lpoints])

        mlt = [mlt,ephem.edmlt]
        mlt_time = [mlt_time, ephem.time]

      ENDIF

      mlt = INTERPOL ( mlt, mlt_time, (struct[k].time[0:lpoints-1]+struct[k].time[1:lpoints])/2 )  ; midpoint of sample time

      ; *** Convert to bin numbers

      xb  = FIX( 2*(90.0-il)*COS(mlt*!PI/12) + 90 )
      yb  = FIX( 2*(90.0-il)*SIN(mlt*!PI/12) + 90 )

      ; Everything

      idx1 = WHERE( xb GE 0 AND xb LT xbn AND yb GE 0 AND yb LT ybn, count)

      IF count GT 0 THEN BEGIN

        xb = xb[idx1]
        yb = yb[idx1]

        FOR kk = 0, count-1 DO BEGIN ; can probably speed up

          samp[xb[kk],yb[kk],0] = samp[xb[kk],yb[kk],0] + 1
          samp[xb[kk],yb[kk],1:*] = samp[xb[kk],yb[kk],1:*] + struct[k].data[*,idx1[kk]]

        ENDFOR

      ENDIF

    ENDFOR

  ENDIF

  IF NOT KEYWORD_SET(mtitle) THEN mtitle = ''

  IF KEYWORD_SET(postscript) THEN BEGIN

    IF datatype(postscript) NE 'STR' THEN BEGIN
      file=PICKFILE(TITLE='Select file for POSTSCRIPT output',FILTER='*.ps', PATH=ies_get_dir('PS',/POLAR) )
    ENDIF ELSE file = postscript

    IF file EQ '' THEN BEGIN
      MESSAGE, 'No data file given', /CONT, /TRACEBACK
      RETURN
    ENDIF

    ; check if has directory defined

    IF STRLEN(strip_dirname(file)) EQ STRLEN(file) THEN file = concat_dir(ies_get_dir('PS',/POLAR),file)

    SET_PLOT, 'PS'

    IF KEYWORD_SET(portrait) THEN BEGIN
;      DEVICE, /COLOR, BITS=8, FILE=file, XOFFSET=0.6, YOFFSET=0.5, XSIZE=19.9, YSIZE=26.5, /PORTRAIT
      DEVICE, /COLOR, BITS=8, FONT_SIZE=10, FILE=file, XOFFSET=1.5, YOFFSET=1.5, XSIZE=17.5, YSIZE=26., /PORTRAIT
    ENDIF ELSE BEGIN
      DEVICE, FILE=file, BITS=8, /LANDSCAPE, /COLOR, XOFFSET=0.5, YOFFSET=27.5, XSIZE=27, YSIZE=19.9
    ENDELSE

  ENDIF ELSE BEGIN

    WINDOW, /FREE, XSIZE=512, YSIZE=512

  ENDELSE

  !P.MULTI=0
  !P.CHARSIZE = 1
  !P.REGION = 0
  !P.POSITION = 0


  IF N_ELEMENTS(band) EQ 0 THEN BEGIN

    IF KEYWORD_SET(ies) THEN $
	et = TOTAL(samp(*,*,2:10),3)/(samp(*,*,0)>1) $
    ELSE IF KEYWORD_SET(ips) THEN $
	et = TOTAL(samp(*,*,2:16),3)/(samp(*,*,0)>1) $
    ELSE IF KEYWORD_SET(histe) THEN $
	et = TOTAL(samp(*,*,8:16),3)/(samp(*,*,0)>1) $
    ELSE IF KEYWORD_SET(histp) THEN $
	et = TOTAL(samp(*,*,1:16))/(samp(*,*,0)>1) $
    ELSE $
	et = TOTAL(samp(*,*,1:*),3)/(samp(*,*,0)>1)
    band = 0 ; not used hereafter
  ENDIF ELSE IF band GE 0 THEN et = samp(*,*,1+band)/(samp(*,*,0)>1)$
  ELSE et = samp(*,*,0)

  IF N_ELEMENTS(range) EQ 0 THEN BEGIN
    IF band EQ -1 THEN BEGIN
  	zmin = 1e-1
	zmax = 1e3
    ENDIF ELSE IF KEYWORD_SET(ies) THEN BEGIN
	zmin = 1e2
 	zmax = 1e7
    ENDIF ELSE IF KEYWORD_SET(ips) THEN BEGIN
	zmin = 1e4
	zmax = 4e7
    ENDIF ELSE IF KEYWORD_SET(histe) THEN BEGIN
	zmin = 1e2
	zmax = 1e6
    ENDIF ELSE IF KEYWORD_SET(histp) THEN BEGIN
	zmin = 4e1
	zmax = 1e3
    ENDIF ELSE BEGIN
	zmin = 1
	zmax = 1e7
    ENDELSE
  ENDIF ELSE BEGIN
    zmin = range[0]
    zmax = range[1]
  ENDELSE

	LOADCT, 39

	lcs = 1

  et = ALOG10(et>.1)

	IF ( lcs EQ 1 ) THEN BEGIN
		zmin = ALOG10(zmin)
		zmax = ALOG10(zmax)
	ENDIF

	ar = !D.Y_PX_CM*!D.X_SIZE/(!D.X_PX_CM*!D.Y_SIZE)

	IF ( ar GT 1 ) THEN BEGIN	; Landscape
		y0 = 0.1
		dy = 0.8
		dx = dy/ar
		x0 = 0.5 - 0.5*dx
	ENDIF ELSE BEGIN
		x0 = 0.1
		dx = 0.8
		dy = dx*ar
		y0 = 0.5 - 0.5*dy
	ENDELSE

	!P.POSITION = [ x0, y0, x0+dx, y0+dy ]
	PLOT, [-45,45],[-45,45], XSTY=5, YSTY=5, XRANGE=[-45,45],YRANGE=[-45,45],/NODATA, /NOERASE

        x0 = !P.CLIP(0) + 1
	dx = !P.CLIP(2) - x0
	y0 = !P.CLIP(1) + 1
	dy = !P.CLIP(3) - y0

	IF ( !D.NAME EQ 'PS' ) THEN sf = 0.03 ELSE sf = 1.0

	dxi = FIX(sf*dx)
	dyi = FIX(sf*dy)

	IF (!D.NAME EQ 'PS') THEN BEGIN
           et = BYTSCL(et,MIN=zmin,MAX=zmax,TOP=!D.N_COLORS-2)
           list = WHERE(et eq 0, count)
           IF count GT 0 THEN et[list] = 255
                TV, et, x0, y0, XSIZE=dx, YSIZE=dy
        ENDIF ELSE  BEGIN
                TV, BYTSCL(CONGRID(et,dx,dy),MIN=zmin,MAX=zmax,TOP=!D.N_COLORS-2), x0, y0
        ENDELSE
	PLOTS, [0,0],[-45,45]
	PLOTS, [-45,45],[0,0]

	t = FINDGEN(360)*3.1415*2.0/359
	r = FLTARR(360)
	r(*)=10
	OPLOT,r,t,/POLAR
	OPLOT,r*2,t,/POLAR
	OPLOT,r*3,t,/POLAR
	OPLOT,r*4,t,/POLAR
	lp = 7.07
	XYOUTS, lp, -lp, '80', CHARSIZE=1.5
	XYOUTS, lp, lp, '33.2', CHARSIZE=1.5
	XYOUTS, 2*lp,-2*lp, '70', CHARSIZE=1.5
	XYOUTS, 2*lp,2*lp, '8.5', CHARSIZE=1.5
	XYOUTS, 3*lp,-3*lp, '60', CHARSIZE=1.5
	XYOUTS, 3*lp,3*lp, '4', CHARSIZE=1.5
	XYOUTS, 4*lp,-4*lp, '50 IL', CHARSIZE=1.5
	XYOUTS, 4*lp,4*lp, '2.4 L Shell', CHARSIZE=1.5
	XYOUTS, 47,0, '00:00!CMLT', CHARSIZE=1.5
	XYOUTS, 0, 47, '06:00', ALIGN=0.5, CHARSIZE=1.5
	XYOUTS, -47,0, '12:00', ALIGN=1.0, CHARSIZE=1.5
	XYOUTS, 0,-50, '18:00', ALIGN=0.5, CHARSIZE=1.5
	XYOUTS, 0.01, 0.95, 'Polar CEPPAD!C'+mtitle, $
		CHARSIZE=1.8, /NORM

	disp_cscale, 0.95, 0.1, 0.02, 0.3, [zmin,zmax], LOG=lcs, $
		YTICKLEN=-0.2, YTITLE='Cts/cm2/s/sr'


  IF KEYWORD_SET(postscript) THEN BEGIN
    DEVICE,/CLOSE
    SET_PLOT,devname
  ENDIF

END
