
PRO lsh_monstor, xlsh, struct, T0=t0, T1=t1, INST=inst, MODE=mode, $
                 DIV=div, DETECTOR=detector, SHOW=show, REMOVE=remove, LUT=lut, NFP=nfp, PA=pa, $
                 EXNAME=exname

  ; define common blocks used internally for draw widgets
  ; full_header   = structure containing original data header information
  ; full_data     = structure array cotaining original data
  ; header        = structure containing extracted data header information  ** used
  ; data          = structure array containing extracted data               ** used
  ; output_info   = structure containing plotting and processing info       ** used
  ; output_chans  = array containing processed channel positions
  ; output_array  = array containing processed data for plotting
  ; ids           = structure giving widget IDs
  ; dnfull        = co-ordinate conversion array for full window
  ; dnscroll      = co-ordinate conversion array for magnified windows
  ; files         = STRARR giving data file names
  ; ephem         = structure containing ephemeris data
  ; mf            = structure containing magnetic field data
  ; at            = structure containing attitude data

  COMMON ies_draw_widget_block, input_header, input_data, header, data, $
           output_info, output_chans, output_array, ids, dnfull, dnscroll, files, ephem, mf, at

  ; come back out to top level

  ON_ERROR, 0 ; stay at error point

  LOADCT, 39

  IF NOT KEYWORD_SET(xlsh) THEN MESSAGE, 'No LSHELLs defined'

  ; set div

  IF NOT KEYWORD_SET(div) THEN div = 0

  ; process times

  IF KEYWORD_SET(t0) THEN BEGIN

    tai = utc2tai(anytim2utc (t0))

    list = WHERE(xlsh[0,*].time_start GT tai, count)

    IF count EQ 0 THEN BEGIN
      PRINT, 'No orbits after start time'
      RETURN
    ENDIF

    start_orbit = list[0]

  ENDIF ELSE start_orbit = 0

  IF KEYWORD_SET(t1) THEN BEGIN

    tai = utc2tai(anytim2utc (t1))

    list = WHERE(xlsh[0,*].time_end LT tai, count)

    IF count EQ 0 THEN BEGIN
      PRINT, 'No orbits before end time'
      RETURN
    ENDIF

    end_orbit = list[count-1]

  ENDIF ELSE end_orbit = (SIZE(xlsh))(2)-1

  ; default instrument to 'IES'

  IF NOT KEYWORD_SET(inst) THEN inst = 'IES'

  IF KEYWORD_SET(show) THEN str = '' ELSE str = 'g'

  ; initialize data stored

  input_header = 0
  input_data   = 0

  ; set nparts

  nparts = (SIZE(xlsh))[1]

  ; loop through orbits

  FOR o = start_orbit, end_orbit DO BEGIN

    ; process each part of the orbit

    FOR p = 0, nparts-1 DO BEGIN

      ; default detector to 0

      IF N_ELEMENTS(detector) EQ 0 THEN BEGIN

        IF STRPOS(inst,'HIST') GE 0 THEN detectors = [1] ELSE $
        IF STRPOS(inst,'IES') GE 0  THEN BEGIN
          IF xlsh[p,o].time_start GE utc2tai(anytim2utc('25/may/97')) AND $
             xlsh[p,o].time_end   LT utc2tai(anytim2utc('7/jun/97')) THEN $
               detectors = [1,1,1,1,0,0,1,1,0] ELSE detectors = [1,1,1,1,1,1,1,1,1]
        ENDIF ELSE $
        IF STRPOS(inst,'IPS') GE 0  THEN detectors = [0,0,1,1,1,1,1,0,0,0] ELSE detectors = [1]

        IF KEYWORD_SET(pa) THEN BEGIN
          IF STRPOS(inst,'IES') GE 0  THEN detectors = [0,0,0,1,0,1,0,0,0]
        ENDIF

        element = FIX(TOTAL(detectors))

      ENDIF ELSE BEGIN
        IF STRPOS(inst,'HIST') GE 0 THEN detectors = INTARR(1) ELSE $
        IF STRPOS(inst,'IES') GE 0  THEN detectors = INTARR(9) ELSE $
        IF STRPOS(inst,'IPS') GE 0  THEN detectors = INTARR(10) ELSE detectors = [1]
        element = 0
        detectors[detector < (N_ELEMENTS(detectors)-1)] = 1
      ENDELSE

      ; get data for this part of the orbit

      IF lsh_get_data( inst, detectors, [xlsh[p,o].time_start, xlsh[p,o].time_end], REMOVE=remove, MODES=mode, NFP=nfp) THEN BEGIN

        ; set up processing info

        output_info = { log:1, cal:0, div:0, rat:0, shift:0, subtract:0, track:1, $
          rng:0.0, button_labels:STRARR(12), button_values:[1,0,0,0,0,0,0,0,0,0,0,0], procname:'SPECTRAL', $
          full_only:0, full_detector:element, full_sector:0, axes:1, $
          band_labels:STRARR(20), noutputs:0, $
          format:'ENERGY vs DETECTOR', ptitle:STRARR(20), time:0.0D0, ysamples:0, $
          minimum:1.e2, maximum:1.e8, elow:0.0, ehigh:0.0, min:0, max:0, elo:0, ehi:0 }

        IF STRPOS(inst,'HIST') GE 0 OR STRPOS(inst,'IES') GE 0 OR STRPOS(inst,'IPS') GE 0 THEN BEGIN
          output_info.rat = 1
          output_info.cal = 1
          output_info.div = div
        ENDIF

        IF KEYWORD_SET(pa) THEN output_info.format = 'ANGLE/ANGLE'

        ; process data

        IF ies_calibrate(/QUIET) THEN MESSAGE, 'ies_calibrate error'

        ; set no. of channels

        nchannels = header.nbands
        IF KEYWORD_SET(sectors) THEN nchannels = header.nsectors
        IF KEYWORD_SET(lut) THEN nchannels = 1
        IF KEYWORD_SET(pa) THEN nchannels = header.nbands*2

        ; check time monotonic increasing

        temp = WHERE ( ephem[1:*].time LT ephem.time, count)

        IF count NE 0 THEN MESSAGE, 'Time not monotonic increasing'

        ; get L shell values for each data sample

        lshells = INTERPOL ( ephem.l, ephem.time, data.time )

       ; set up output structure

        IF p EQ 0 AND o EQ start_orbit THEN BEGIN

          ; initialize arrays

          IF KEYWORD_SET(sectors) THEN type = '_SECTOR' ELSE $
          IF KEYWORD_SET(lut)     THEN type = '_LUT' ELSE $
          IF KEYWORD_SET(pa)      THEN type = '_PITCH_ANGLE_V3' ELSE $
                                       type = '_ENERGY'

          IF NOT EXECUTE ( 'dstruct={' + inst + type + '_NEW_LSH_STRUCTURE,' + $
                       'time:0.0d0,lsh:0.0,'+ $
                       'data:FLTARR(nchannels) }' ) THEN MESSAGE,'EXECUTE STRUCTURE PROBLEM'

        ENDIF

        IF header.npoints GT 0 THEN BEGIN

          ; check if energy or sector info required

          IF KEYWORD_SET(sectors) THEN BEGIN

            ; energy average data

            start_chan = 0
            IF STRPOS(header.datatype,'HISTe') GE 0 THEN start_chan = 2 < header.nbands
            IF STRPOS(header.datatype,'IES') GE 0   THEN start_chan = 1 < header.nbands

            xdata = REFORM(TOTAL ( data.data(*,element,start_chan:*), 3 )) ; element ????

          ENDIF ELSE IF KEYWORD_SET(lut) THEN BEGIN

            xdata = REFORM(data.lut,1,header.npoints)

          ENDIF ELSE IF KEYWORD_SET(pa) THEN BEGIN

            ; output_array has format (header.nsectors,header.ndetectors,header.nbands,header.npoints)

            ; get pitch angle array

            ies_pitch_angle, header, data, pas

            ; generate masks

            ies_generate_masks, header, data, pas, EARTH=STRPOS(header.datatype,'IPS') GE 0, SUN=STRPOS(header.datatype,'IPS') GE 0

            xdata = FLTARR(header.nbands,2,header.npoints)

            FOR f = 0, header.npoints-1 DO BEGIN
              FOR e = 0, header.nbands-1 DO BEGIN
                pitch_angles = pas[*,*,f]
                temp_data = output_array[*,*,e,f]
                list =  WHERE(pitch_angles GE 0, count)
                IF count GT 0 THEN xdata[e,*,f] = fitsin (pitch_angles[list],temp_data[list])
              ENDFOR
            ENDFOR

            xdata = REFORM(xdata, header.nbands*2, header.npoints)

          ENDIF ELSE BEGIN

            xdata = REFORM(output_array[element,*,*], header.nbands, header.npoints)

          ENDELSE

          tstruct = REPLICATE(dstruct,header.npoints)

          tstruct.data = xdata

          tstruct.time = data.time

          tstruct.lsh = lshells

          IF NOT KEYWORD_SET(struct) THEN struct = tstruct  ELSE struct = [struct,tstruct]

        ENDIF ELSE BEGIN ; npoints gt 0
a1:
          ; npoints le 0

          PRINT, 'Invalid first data set'

        ENDELSE

      ENDIF ELSE BEGIN; data available

        ; no data available

        PRINT, 'Invalid first data set'

      ENDELSE

    ENDFOR; loop over p

    IF str NE 'g' AND str NE 'G' AND KEYWORD_SET(show) THEN BEGIN
      str = get_kbrd(1)
      IF str EQ 's' THEN STOP
    ENDIF

  ENDFOR; loop over o

END