PRO lsh_movie, IMAGES=small_images, s0, s1, s2, s3, NEW=new, LCT=lct

  ; save current device name

  devname = !D.NAME

  ; come back out to top level

  ON_ERROR, 0

  IF N_ELEMENTS(small_images) LE 1 OR KEYWORD_SET(new) THEN BEGIN

    small_images = s0.data

    IF N_ELEMENTS(s1) GT 0 THEN small_images = [TEMPORARY(small_images),s1.data]

    IF N_ELEMENTS(s2) GT 0 THEN small_images = [TEMPORARY(small_images),s2.data]

    IF N_ELEMENTS(s3) GT 0 THEN small_images = [TEMPORARY(small_images),s3.data]

    siz = SIZE(small_images)
    small_images = REFORM(TRANSPOSE(TEMPORARY(small_images),[0,2,1,3]),siz[1]*siz[3],siz[2],siz[4])

    temp = REPLICATE({time:0.0d0,image:small_images[*,*,0]},(SIZE(s0))[2])

    temp.time  = REFORM(s0[0,*].time[0])
    temp.image   = TEMPORARY(small_images)
    small_images = TEMPORARY(temp)

  ENDIF ; create small_images

  SET_PLOT, devname

  ; get scale factor

  factor = (200/(SIZE(small_images.image))(1)) > 1

  n_images = N_ELEMENTS(small_images)

  ; display images

  XINTERANIMATE, SET=[factor*(SIZE(small_images.image))(1),(SIZE(small_images.image))(2),n_images]

  smin = ALOG(MIN(small_images.image)>1)
  smax = ALOG(MAX(small_images.image)>1)

  FOR f = 0, n_images-1 DO BEGIN

    image = ALOG(small_images(f).image>1)

    IF smax-smin NE 0 THEN image = !d.n_colors*(image-smin)/(smax-smin)

    image = REBIN(image,factor*(SIZE(image))(1),(SIZE(image))(2),/SAMPLE)

    ; display times in images

    SET_PLOT,'Z'
    DEVICE, SET_RES=[(SIZE(image))(1),(SIZE(image))(2)]
    ERASE

    TV, image

    XYOUTS, 25, 0, /DEVICE, ANYTIM2CAL(small_images[f].time)

    IF KEYWORD_SET(lct)THEN BEGIN

      xpos = 3
      FOR k = 0, (SIZE(lct))[1]-1 DO BEGIN
        XYOUTS, xpos, 10, /DEVICE, STRING(lct[k,f].mlt MOD 24, FORMAT='(I2)')
        xpos = xpos + (SIZE(s0.data))[1]*factor
      ENDFOR

    ENDIF

    image = TVRD()

    SET_PLOT, devname

    XINTERANIMATE, IMAGE=image, FRAME=f

  ENDFOR

  XINTERANIMATE, 1, /TRACK, TITLE='Energy vs L shell = 0-'+STRTRIM((SIZE(small_images))(2)/10,2)

END