;+
; Project     :	CLUSTER - PEACE
;
; Name        :	LSH_OR
;
; Purpose     : Gets L shell vs time for specifed period.
;
; Explanation :	Loops through time period on day by day basis and extracts ephemeris data
;               for each day.
;               Creates LSH_STRUCT array of time and lshell.
;
; Use         : < lsh_monitor, times, data, orbits, T0=t0, T1=t1, INST=inst, MODE=mode, $
;                              DETECTOR=detector,  _EXTRA=extra >
;
; Inputs      : None.
;
; Opt. Inputs : times  : DBLARR(nshells,norbits) of TAI times.
;               data   : FLTARR(nbands,nshells,norbits) array of L shell vs energy images for different orbits.
;               orbits : INTARR(norbits) orbits type
;                               0 : to south pole
;                               1 : from south pole
;
; Outputs     : times  : DBLARR(nshells,norbits) of TAI times.
;               data   : FLTARR(nbands,nshells,norbits) array of L shell vs energy images for different orbits.
;               orbits : INTARR(norbits) orbits type
;                               0 : to south pole
;                               1 : from south pole
;
; Opt. Outputs:	None.
;
; Keywords    : INST : STRING specifying instrumnet i.e 'IES', 'IPS', 'HISTe', 'HISTp'
;               TO : TAI time start
;               T1 : TAI time end
;               MODE : STRING mode for HIST data
;               DETECTOR : INT detector number
;               _EXTRA : PLOT keywords.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 22/4/97
;
; Modified    :
;
; Version     :	Version 0.0, 22/4/97
;-
;**********************************************************

PRO lsh_or, lsh, T0=t0, T1=t1

  ; process times

  IF KEYWORD_SET(t0) THEN tai0 = utc2tai(anytim2utc(anytim2cal(t0,/DATE))) ELSE $
    tai0 = utc2tai(anytim2utc('96/03/01'))

  IF KEYWORD_SET(t1) THEN tai1 = utc2tai(anytim2utc(anytim2cal(t1,/DATE))) ELSE $
    tai1= utc2tai(anytim2utc('99/12/31'))

  tim = tai0

  dummy = {LSH_STRUCT, time:0.0d0, lsh:0.0}

  WHILE tim LE tai1 DO BEGIN

    e = get_ephem(tim)

    temp = REPLICATE({LSH_STRUCT}, N_ELEMENTS(e))

    temp.time = e.time
    temp.lsh  = e.l

    IF KEYWORD_SET(lsh) THEN lsh = [lsh, temp] ELSE lsh = temp

    tim = utc2tai(anytim2utc(anytim2cal(tim+25.*3600.,/DATE)))

  ENDWHILE

END