; 16/01/02 added XLCFL keyword but does not do anything at present
; 17/01/02 added FIXED_CHARSIZE keyworc
; 09/07/02 used routine ies_color_scale and ies_get_color
;          removed part of the white processing

PRO lsh_plot, xx, data, time_start, time_end, LSHELLS=lshells, NO_XAXIS=no_xaxis, $
              NO_ERASE=no_erase, RANGE=range, TITLE=title, PS=ps, LINEPLOT=lineplot, DIV=div, LOG=log, $
              LUT=lut, WHITE=white, xmargin=xmargin, ymargin=ymargin, CTITLE=ctitle, REALTIME=realtime, $
              MAP=map, LCFL=lcfl, XLCFL=xlcfl, NOYLOG=noylog, PEAK=peak, FIXED_CHARSIZE=fixed_charsize

  ; xx   : DBLARR(lpoints,*,*)
  ; data : FLTARR(lpoints,*)


  IF NOT KEYWORD_SET(xmargin) THEN xmargin = [10,12]
  IF NOT KEYWORD_SET(ymargin) THEN ymargin = [0,1]
  IF NOT KEYWORD_SET(noylog)  THEN ylog = 1 ELSE ylog=0

  lpoints = (SIZE(data))(1)
  nsamples = N_ELEMENTS(data)/lpoints

  IF KEYWORD_SET (lshells) THEN BEGIN
    IF N_ELEMENTS(lshells) GT 1 THEN BEGIN
      ylo = lshells[0]
      yhi = lshells[1]
    ENDIF ELSE BEGIN
      ylo = 0
      yhi = lshells[0]
    ENDELSE
  ENDIF ELSE BEGIN
    ylo = 0
    yhi = lpoints/10.
  ENDELSE

  IF (SIZE(xx))[2] EQ 1 OR KEYWORD_SET(realtime) THEN BEGIN

    ; x = REFORM((xx[0,*,*]+xx[lpoints,*,*])/2,nsamples) ; use midpoint of pass

    x = REFORM( xx[0,*,*] < xx[lpoints,*,*], nsamples) ; use start of pass

  ENDIF ELSE BEGIN

    ; use equally space intervals

    periods = REFORM(xx[0,0,1:*] - xx[0,0,*])

    no = (SIZE(xx))[2] ; norbits
    np = (SIZE(xx))[3] ; npoints

    periods = [periods,periods[np-2]]

    x = REFORM(REPLICATE(1,no)#REFORM(xx[0,0,*])+INDGEN(no)#periods/no,no*np)

  ENDELSE

  y = REFORM(data,lpoints,nsamples)

  IF N_ELEMENTS(time_start) EQ 0 THEN time_start = x[0]
  IF N_ELEMENTS(time_end) EQ 0 THEN time_end = x[N_ELEMENTS(x)-1]

  IF NOT KEYWORD_SET(ctitle) THEN BEGIN
    IF KEYWORD_SET(div) THEN ctitle = 'cts/cm2/s/sr/keV' ELSE ctitle = 'cts/cm2/s/sr'
  ENDIF

  ; IF KEYWORD_SET(lcfl) THEN do_lcfl, xx, y, lcfl

  IF KEYWORD_SET(lineplot) THEN BEGIN

    ; average over 0.5 L intervals
    ; keeping counts

;    step = 1
;    nlsize  = 5
 ;   nlstart = 2
;    nlines  = nlsize*2

;    y = REBIN(y(nlstart*10:nlstart*10+nlsize*10-1,*),nlines,(SIZE(y))(2))*(10*nlsize)/nlines

    ; produce sums from low l to high l

   ; FOR k=1, nlines-1 DO y(k,*) = y(k,*) + y(k-1,*)

    ; produce sums from high l to low l

;   FOR k=1, nlines-1 DO y(nlines-k-1,*) = y(nlines-k-1,*) + y(nlines-k,*)

;   y = REVERSE(y)

     step = 0.4
   nlines = 6
    nlstart = 5
 ;   nlstart = 3.5
 ;   nlsize = 1.5
    nlsize = 5
;   y = TOTAL(y,1)
;    y = TOTAL(y[nlstart*10:(nlstart+nlsize)*10-1,*],1)
;    y = REFORM(y,1,N_ELEMENTS(y))

    ; select 0.1 L averages at L step

;    step = 1
;    nlsize  = 0
;    nlstart = 6.6
;    nlines  = nlsize+1

    y = y(10*(nlstart+(FINDGEN(nlines)*nlsize*step)/(nlines-1)),*)
;    y = y(10*nlstart,*)


    IF NOT KEYWORD_SET(range) THEN BEGIN
      maximum = MAX(y)
      minimum = 1e0
    ENDIF ELSE BEGIN
      maximum = range[1]
      minimum = range[0]
    ENDELSE

    ; set up axes

  ;  ies_do_axes, time_start, time_end, minimum, maximum, xmargin, ymargin, $
    ies_do_axes, time_start, time_end, minimum, maximum, xmargin, ymargin, YLOG=ylog, $
      XTITLE='UT', YTITLE=ctitle, SAVE_CC=save_cc, NO_XAXIS=no_xaxis, NO_ERASE=no_erase, SHRINK=shrink

    FOR k=0, nlines-1 DO BEGIN

      ; get color for overlay

      col = ies_get_color(k)

      OPLOT, x-time_start, y(k,*), COLOR=col ; , psym=-2

    ENDFOR

  ENDIF ELSE BEGIN

    IF NOT KEYWORD_SET(range) THEN BEGIN
      maximum = MAX(y)
      minimum = 1.e2
    ENDIF ELSE BEGIN
      maximum = range[1]
      minimum = range[0]
    ENDELSE

    ; set up axes

    ies_do_axes, time_start, time_end, ylo, yhi, xmargin, ymargin, $
      XTITLE='UT', YTITLE='Lshell', SAVE_CC=save_cc, NO_XAXIS=no_xaxis, NO_ERASE=no_erase, SHRINK=shrink, LOG=elog

    ; draw image in plot box, check if rescaleable output device

    IF KEYWORD_SET(map) THEN BEGIN

      ch_positions = INTARR( 2, lpoints,  1, nsamples)

      luts = INDGEN(nsamples)

      times = REFORM(xx,1+lpoints,nsamples)

      FOR k = 0, nsamples-1 DO BEGIN

        list = WHERE((map.time[0] LT times[70,k] AND map.time[19] GT times[70,k]) OR $
                     (map.time[0] GT times[70,k] AND map.time[19] LT times[70,k]), count)

        IF count GT 1 THEN MESSAGE, 'Funny time'

        IF count EQ 1 THEN BEGIN

          lshs = clean_lshells ( map[list[0]].lphi, map[list[0]].time, times[*,k])

          ch_positions[0,*,0,k] = 10*lshs[0:lpoints-1]
          ch_positions[1,*,0,k] = 10*lshs[1:*]

        ENDIF ELSE BEGIN

          ch_positions[0,*,0,k] = 0
          ch_positions[1,*,0,k] = 1

        ENDELSE

      ENDFOR

    ENDIF ELSE BEGIN

      ch_positions = INTARR( 2, lpoints,  1, 1)

      luts = INTARR(nsamples)

      ; dont really need to use this (could use showch=0)

      ch_positions[0,*,0,0] = INDGEN(lpoints)
      ch_positions[1,*,0,0] = 1+INDGEN(lpoints)

    ENDELSE

    IF !D.FLAGS AND 1 THEN BEGIN

        ; fix array at some nominal size

;        xsize = FIX ( N_ELEMENTS(x)*1.1 ) < 512
;        ysize = 10*yhi < 128
        xsize = 2048
        ysize = 10*yhi

        yy = y

        ; resize array
        ; NB updates y

        ies_mk_image, yy, x-time_start, luts, ch_positions, lpoints, 10*ylo, 10*yhi, xsize, ysize, $
                      SHFTCH=shftch, LOG=elog, /SHOWCH

;        ; recast -ve values

;        list = WHERE(yy LT 0, count)

;        IF count GT 0 THEN yy[list] = (minimum+maximum)/2.

        ; colour scale

        ies_color_scale, {log:log,minimum:minimum,maximum:maximum}, yy

        ; white out zero elements for postscript plot

        IF !D.NAME EQ 'PS' AND NOT KEYWORD_SET(white) THEN BEGIN

           list = WHERE ( yy EQ 0, count )

           IF count GT 0 THEN yy(list) = 255

        ENDIF

        ; plot array
        ; can use data coords but not as direct

        TV, yy, !X.WINDOW(0), !Y.WINDOW(0), XSIZE=!X.WINDOW(1)-!X.WINDOW(0), YSIZE=!Y.WINDOW(1)-!Y.WINDOW(0), /NORMAL, ORDER=0

        IF KEYWORD_SET(peak) THEN BEGIN

          ; plot flux peak position

          FOR k=0,N_ELEMENTS(x)-1 DO BEGIN
            lstart = 35 ; exclude low l protons
            dummy = MAX(y[lstart:*,k],ypos)
            OPLOT,[x[k]-time_start],[(lstart+ypos)/10.],PSYM=2
          ENDFOR

        ENDIF

   ENDIF ELSE BEGIN

        ; get device coords of plot window

        vector = CONVERT_COORD ( !X.WINDOW, !Y.WINDOW, /NORMAL, /TO_DEVICE )

        ; get origin and size in device co-ords (inclusive of axes)

        xorig = vector(0,0)
        yorig = vector(1,0)
        xsize = FIX(vector(0,1) - xorig + 1)
        ysize = FIX(vector(1,1) - yorig + 1)

        ; check xsize and ysize are reasonable

        IF xsize LE 0 OR ysize LE 0 THEN BEGIN
          PRINT, 'IMAGE WINDOW INVALID SIZE : '
          RETURN
        ENDIF

        ; resize array
        ; NB updates yy

        yy = y

        ies_mk_image, yy, x-time_start, luts, ch_positions, lpoints, 10*ylo, 10*yhi, xsize, ysize, $
                      SHFTCH=shftch, LOG=elog, /SHOWCH

        ; recast -ve values

;        list = WHERE(yy LT 0, count)

;        IF count GT 0 THEN yy[list] = (minimum+maximum)/2.

        ; colour scale

        ies_color_scale, {log:log,minimum:minimum,maximum:maximum}, yy

        ; plot array

        TV, yy, xorig, yorig, ORDER=0

        IF KEYWORD_SET(peak) THEN BEGIN

          ; plot flux peak position

          FOR k=0,N_ELEMENTS(x)-1 DO BEGIN
            lstart = 35 ; exclude low l protons
            dummy = MAX(y[lstart:*,k],ypos)
            OPLOT,[x[k]-time_start],[(lstart+ypos)/10.],PSYM=2
          ENDFOR

        ENDIF

    ENDELSE

  ENDELSE

  ; overplot axes again to neaten up
  ; NB use dont use data coords because x axis extended in data coords
  ; NB dont want to use plot again because of multiple plots

  PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
         [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  IF KEYWORD_SET(lineplot) THEN BEGIN

    ; put down labels
    ; NB the different energy bands correspond to the ytitle

;    ies_do_labels, nlines, $
;      'L='+STRTRIM(STRING(nlstart+(INDGEN(nlines)  )/FLOAT(nlines)*nlsize,FORMAT='(F3.1)'),2)+ $
;      ':' +STRTRIM(STRING(nlstart+(INDGEN(nlines)+1)/FLOAT(nlines)*nlsize,FORMAT='(F3.1)'),2), $
;      TITLE=title, CTITLE='Bands', NO_XAXIS=no_xaxis

    IF nlines GT 1 THEN $
      ies_do_labels, nlines, $
        'L='+STRTRIM(STRING(nlstart+(FINDGEN(nlines))/FLOAT(nlines-1)*nlsize*step,FORMAT='(F3.1)'),2), $
        TITLE=title, CTITLE='Bands', NO_XAXIS=no_xaxis $
    ELSE $
      ies_do_labels, nlines, $
        'L='+STRTRIM(STRING(nlstart,FORMAT='(F3.1)'),2)+':'+STRTRIM(STRING(nlstart+nlsize,FORMAT='(F3.1)'),2), $
        TITLE=title, CTITLE='Bands', NO_XAXIS=no_xaxis

  ENDIF ELSE BEGIN

    ; draw color bar

    ies_do_colorbar, minimum, maximum, TITLE=title, CTITLE=ctitle, $
      NO_XAXIS=no_xaxis, LOG=log, FIXED_CHARSIZE=fixed_charsize

  ENDELSE

END
