; plots extra stuff
; 16/01/02 added XLCFL keyword
; 10/06/02 Added solar wind velocity -- added DCF and VEL keywords

PRO lsh_plot_extra, pos, size, time_start, time_end, xmargin, ymargin, DST=dst, TMP=tmp, $
  AE=ae, AP=ap, $
  DERIV=deriv, OVERLAY=overlay, DRANGE=drange, $
  SWE=swe, WRANGE=wrange, DCF=dcf, VEL=vel, $
  TIMES=times,$
  REALTIME=realtime, LCFL=lcfl, XLCFL=xlcfl, LSHELLS=lshells, AVERAGE=average, NO_XAXIS=no_xaxis

  ; tmp

  IF N_ELEMENTS(tmp) GT 0 THEN BEGIN

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    ; set up axes

    ies_do_axes, time_start, time_end, 0, 30, xmargin, ymargin, $
      YTITLE='IES temperature [C]', /NO_ERASE, /NO_XAXIS

    ; plot tmp

    OPLOT, tmp.time-time_start, tmp.avr
    OPLOT, tmp.time-time_start, tmp.min, LINESTYLE=2
    OPLOT, tmp.time-time_start, tmp.max, LINESTYLE=2

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

  ; lcfl

  IF KEYWORD_SET(lcfl) THEN BEGIN

    z = map_lcfl ( lcfl )

    pos = pos - size

    IF NOT KEYWORD_SET(overlay) THEN !P.REGION = [0,pos,1,pos+size]

    IF KEYWORD_SET(lshells) THEN BEGIN
      lmin = lshells[0]
      lmax = lshells[1]
    ENDIF ELSE BEGIN
      lmin = 0
      lmax = N_ELEMENTS(struct[0].data[0,*])/10.
    ENDELSE

    ; set up axes

    ies_do_axes, time_start, time_end, lmin, lmax, xmargin, ymargin, $
      YTITLE='LCFL', /NO_ERASE, NO_YAXIS=overlay, /NO_XAXIS

    ; plot

    OPLOT, (z.time+z[1:*].time)/2-time_start, z.data, PSYM=-1, THICK=3, COLOR=240

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

  ; xlcfl

  IF KEYWORD_SET(xlcfl) THEN BEGIN

    z = map_lcfl ( xlcfl )

    pos = pos - size

    IF NOT KEYWORD_SET(overlay) THEN !P.REGION = [0,pos,1,pos+size]

    IF KEYWORD_SET(lshells) THEN BEGIN
      lmin = lshells[0]
      lmax = lshells[1]
    ENDIF ELSE BEGIN
      lmin = 0
      lmax = N_ELEMENTS(struct[0].data[0,*])/10.
    ENDELSE

    ; set up axes

    ies_do_axes, time_start, time_end, lmin, lmax, xmargin, ymargin, $
      YTITLE='LCFL', /NO_ERASE, NO_YAXIS=overlay, /NO_XAXIS

    ; plot

    OPLOT, (z.time+z[1:*].time)/2-time_start, z.data, PSYM=-1, THICK=3, COLOR=200

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

  ; ap

  IF N_ELEMENTS(ap) GT 0 THEN BEGIN

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    ; set up axes

    ies_do_axes, time_start, time_end, 0, 800, xmargin, ymargin, $
      YTITLE='Ap index', /NO_XAXIS, /NO_ERASE

    ; plot ap index

    OPLOT, ap.time-time_start, ap.ap

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

   ; ae

  IF N_ELEMENTS(ae) GT 0 THEN BEGIN

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    ; set up axes

    ies_do_axes, time_start, time_end, 0, 1000, xmargin, ymargin, $
      YTITLE='AE index', /NO_XAXIS, /NO_ERASE

    ; plot ae index

    OPLOT, ae.time-time_start, ae.data; , THICK=3

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

  ; dst

  IF N_ELEMENTS(dst) GT 0 THEN BEGIN

    xdst = manipulate_dst(dst,times, DERIV=deriv, AVERAGE=average)

    IF NOT KEYWORD_SET(overlay) THEN BEGIN

      pos = pos - size

      !P.REGION = [0,pos,1,pos+size]

    ENDIF ELSE BEGIN

      ; color = 255 ; override !P.COLOR

    ENDELSE

    IF NOT KEYWORD_SET(drange) THEN drange = [-150,20]

    ; set up axes

    ies_do_axes, time_start, time_end, drange[0], drange[1], xmargin, ymargin, $
      YTITLE='Dst index', /NO_ERASE, /NO_XAXIS, NO_YAXIS=overlay

    ; if realtime then use correctly averaged dst

    IF KEYWORD_SET(realtime) THEN BEGIN

      tstart = REFORM(times[0,*,*])
      tstop  = REFORM(times[(SIZE(times))[1]-1,*,*])

      list = WHERE(tstart GT tstop, count)

      IF count GT 0 THEN BEGIN
          temp = tstart[list]
          tstart[list] = tstop[list]
          tstop[list] = temp
      ENDIF

      dst_time = (tstart+tstop)/2
      dst_data = INTERPOL(xdst.dst, xdst.time, dst_time) ; default

      FOR t = 0, N_ELEMENTS(dst_time)-1 DO BEGIN

        list = WHERE((xdst.time GE tstart[t]) AND (xdst.time LE tstop[t]), count)

        IF count GT 1 THEN dst_data[t] = TOTAL(xdst[list].dst)/count

      ENDFOR

    ENDIF ELSE BEGIN

      dst_time = xdst.time
      dst_data = xdst.dst

    ENDELSE

    ; plot Dst index

    OPLOT, dst_time-time_start, dst_data;, THICK=3;, COLOR=color;, THICK=1

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

  ; wind

  IF N_ELEMENTS(swe) GT 0 THEN BEGIN

    ; Nb this adds in delay to get SWE values at earth

    z = manipulate_wind ( swe, DCF=dcf, VEL=vel)

    IF KEYWORD_SET(dcf) THEN ytitle = 'DCF [nT]' ELSE $
    IF KEYWORD_SET(vel) THEN ytitle = 'SW vel. [km/s]' ELSE $
      MESSAGE, 'IMPLEMENTATION ERROR'

    IF NOT KEYWORD_SET(wrange) THEN BEGIN
      IF KEYWORD_SET(dcf) THEN wrange = [-250,20] ELSE $
      IF KEYWORD_SET(vel) THEN wrange = [0,1000] ELSE $
        MESSAGE, 'IMPLEMENTATION ERROR'
      
    ENDIF

    pos = pos - size

    IF NOT KEYWORD_SET(overlay) THEN !P.REGION = [0,pos,1,pos+size]

    ; set up axes

    ies_do_axes, time_start, time_end, wrange[0], wrange[1], xmargin, ymargin, $
      YTITLE=ytitle, /NO_ERASE, OVERLAY=overlay, /NO_XAXIS

    ; plot

    IF KEYWORD_SET(dcf) THEN OPLOT, z.time-time_start, -z.data ELSE $
    IF KEYWORD_SET(vel) THEN OPLOT, z.time-time_start, z.data ELSE $
      MESSAGE, 'IMPLEMENTATION ERROR'
    
    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

  ; do x axis

  IF NOT KEYWORD_SET(no_xaxis) THEN BEGIN

    ies_do_axes, time_start, time_end, 0, 1, xmargin, ymargin, $
      XTITLE='UT', /NO_ERASE, /NO_YAXIS

  ENDIF

END