FUNCTION manipulate_dst, dst, t, DERIV=deriv, AVERAGE=average

  ; check if dst differences required

  IF KEYWORD_SET(deriv) THEN BEGIN

    xdst = dst

    xdst[1:*].dst = dst[1:*].dst - dst.dst

    xdst = xdst[1:*]

    IF deriv EQ 2 THEN BEGIN

      ; find minimum dst difference over interval

      t = REFORM(t, (SIZE(t))[1], (SIZE(t))[2]*(SIZE(t))[3])

      tdst = REPLICATE(xdst[0],(SIZE(t))[2]-1)

      FOR i = 0, (SIZE(t))[2]-2 DO BEGIN

        xt0 = MAX(t[*,i])
        xt1 = MIN(t[*,i+1])

        list = WHERE(xdst.time GT xt0 AND xdst.time LT xt1, count)

        IF count GT 0 THEN BEGIN
          tdst[i].dst = MIN(xdst[list].dst)
          tdst[i].time = xt1
        ENDIF

      ENDFOR

      xdst = tdst

    ENDIF

  ENDIF ELSE IF KEYWORD_SET(average) THEN BEGIN

    IF NOT KEYWORD_SET(period) THEN period = 4*3600L

    ; assume period is less than or equal to one day
    ; to avoid problems with leap seconds use MJD format

    time_start = dst[0].time

    time_end = dst[N_ELEMENTS(dst)-1].time

    res = rcs_time_average(time_start, time_end, dst.time, REFORM(dst.dst,1,1,N_ELEMENTS(dst)), atime, adata, PERIOD=3600L*average)

    xdst = dst[0:N_ELEMENTS(atime)-1]

    xdst.time = atime

    xdst.dst = REFORM(adata)

  ENDIF ELSE BEGIN

     xdst = dst

  ENDELSE

  RETURN, xdst

END