; 10/06/02 : added VEL keyword

FUNCTION manipulate_wind, w, DCF=xdcf, VEL=vel, RAMP=xramp, DIST=xdist, DELAY=delay

  delay = REPLICATE({DELAY_V1,time:0.0d0,data:0.0},N_ELEMENTS(w))

  delay.time = w.time 
  delay.data = - w.xpos/w.vgse[0]

  ; RAM pressure

  ramp = w.np*(w.vgse[0]^2+w.vgse[1]^2+w.vgse[2]^2)*1e-5 ; cts/cc.[km/s]^2 -> KeV/cm3
 
  IF KEYWORD_SET(xramp) THEN BEGIN
    s = REPLICATE({RAMP_V1,time:0.0d0,data:0.0},N_ELEMENTS(w))
    s.time = w.time + delay.data
    s.data = ramp
    RETURN,s[SORT(s.time)]
  ENDIF

  ; stand-off distance

  dist = 10*(5/ramp)^(1./6)

  IF KEYWORD_SET(xdist) THEN BEGIN
    s = REPLICATE({DIST_V1,time:0.0d0,data:0.0},N_ELEMENTS(w))
    s.time = w.time + delay.data
    s.data = dist
    RETURN,s[SORT(s.time)]
  ENDIF

  ; DCF [nT]

  dcf = 20-SQRT(ramp*1000) * 0.2 

  IF KEYWORD_SET(xdcf) THEN BEGIN
    s = REPLICATE({DCF_V1,time:0.0d0,data:0.0},N_ELEMENTS(w))
    s.time = w.time + delay.data
    s.data = dcf
    RETURN,s[SORT(s.time)]
  ENDIF

  ; VEL

  IF KEYWORD_SET(vel) THEN BEGIN
    s = REPLICATE({VEL_V1,time:0.0d0,data:0.0},N_ELEMENTS(w))
    s.time = w.time + delay.data
    s.data = SQRT(w.vgse[0]^2+w.vgse[1]^2+w.vgse[2]^2)
    RETURN,s[SORT(s.time)]
  ENDIF

  RETURN, 0

END