; 19/oct/01 -- added IHARM=4 previously used 0
; 26/oct/01 == added quiet keyword to corrected_lshell
;           -- added maglat to map
;           -- removed nmaglon from map
; 2/nov/01  -- added NLSHELLS keyword

; for use with lsh_ephem

FUNCTION map_lshells, ephem, time_start, time_end, SHOW=show, NLSHELLS=nlshells, QUIET=quiet

  IF NOT KEYWORD_SET(show) THEN show = 0

  struct = lshell_struct(NLSHELLS=nlshells)

  nl = N_ELEMENTS(struct.led)

  list = WHERE(ephem.time GE time_start AND ephem.time LE time_end, count)

  IF count EQ 0 THEN MESSAGE,'Error -- no valid times'

  IF count LT nl THEN BEGIN
    llist = list
    n = count
  ENDIF ELSE BEGIN
    llist = list[(INDGEN(nl)*(count-1))/(nl-1)]
    n = nl
  ENDELSE

  struct.time[0:n-1] = ephem[llist].time
  struct.led[0:n-1] = ephem[llist].l

  ; get SAMPEX

  bs = 0

  FOR k = 0, n-1 DO BEGIN

    flag0 = struct.flag[0,k]

    corrected_lshell, ephem[llist[k]], led, lshell, lphi0, lphi, rfl, rnoon, rmidn, b0, bm, xparmod, $
                      maglon, maglat, flag0, IHARM=0, $
                       /DST, /EXNAME, SHOW=show, FLAG1=flag1, /PDYN, /BIMF, SAMPEX=bs, QUIET=quiet

    struct.lsh[k]   = lshell
    struct.lphi0[k] = lphi0
    struct.lphi[k]  = lphi
    struct.rfl[k]   = rfl
    struct.rnoon[k] = rnoon
    struct.rmidn[k] = rmidn
    struct.b0[k]    = b0
    struct.bm[k]    = bm
    struct.bs[k]    = bs
    struct.parmod[*,k]  = xparmod[0:3]
    struct.edmlt[k] = ephem[llist[k]].edmlt
    struct.flag[0,k] = flag0
    struct.flag[1,k] = flag1

  ENDFOR

  IF n NE nl THEN BEGIN

    ; pad out with last value

    struct.time[n:*] = struct.time[n-1]
    struct.led[n:*] = struct.led[n-1]
    struct.lsh[n:*] = struct.lsh[n-1]

  ENDIF

  RETURN, struct

END
