PRO map_plot, orbits, struct, LSHELLS = lshells, t0=t0, t1=t1, $
              XWINDOWS=xwindows, POSTSCRIPT=postscript, GIF=gif, BWPS=bwps, $
              LANDSCAPE=landscape, PORTRAIT=portrait, DRANGE=drange, $
              CHARSIZE=charsize, TITLE=title, XMARGIN=xmargin, YMARGIN=ymargin, $
              PRANGE=prange, BRANGE=brange, OVERLAY=overlay, $
              DST=xdst, PDYN=xpdyn, BIMF=xbimf, TYPE=type, $
              IES=ies, IPS=ips, HISTE=histe, HISTP=histp, E0=e0, E1=e1, MOM=mom

  COMMON dst_block, dst
  COMMON pdyn_block, pdyn, delay
  COMMON bimf_block, bimf

  ; save current device name

  devname = !D.NAME

  ; come back out to top level

  ON_ERROR, 0

  IF NOT KEYWORD_SET(xmargin) THEN xmargin = [7,12]
  IF NOT KEYWORD_SET(ymargin) THEN ymargin = [0,1]

  ; get lshells

  IF NOT KEYWORD_SET (lshells) THEN lshells = [0,20]

  ; get type

  IF NOT KEYWORD_SET (type) THEN type = 0

  ; get time range

  lsh_get_time_range, struct, time_start, time_end
  lsh_get_time_range, tmp, time_start, time_end

  IF N_ELEMENTS(t0) NE 0 THEN time_start = utc2tai(anytim2utc(t0))
  IF N_ELEMENTS(t1) NE 0 THEN time_end   = utc2tai(anytim2utc(t1))

  ; set up data blocks

  dummy = get_parmod(time_start, DST=xdst, PDYN=xpdyn, BIMF=xbimf)

  nplots = N_ELEMENTS(orbits)

  IF KEYWORD_SET(xdst)  NE 0 AND NOT KEYWORD_SET(overlay) THEN nplots=nplots+1
  IF KEYWORD_SET(xpdyn) NE 0 AND NOT KEYWORD_SET(overlay) THEN nplots=nplots+1
  IF KEYWORD_SET(xbimf) NE 0 AND NOT KEYWORD_SET(overlay) THEN nplots=nplots+2

  ; test output device

  IF KEYWORD_SET(xwindows) THEN BEGIN

    WINDOW, /FREE, XSIZE=1200, YSIZE=256*nplots+100

  ENDIF ELSE IF KEYWORD_SET(postscript) THEN BEGIN

    IF datatype(postscript) NE 'STR' THEN BEGIN
      file=PICKFILE(TITLE='Select file for POSTSCRIPT output',FILTER='*.ps', PATH=ies_get_dir('PS',/POLAR) )
    ENDIF ELSE file = postscript

    IF file EQ '' THEN BEGIN
      MESSAGE, 'No data file given', /CONT, /TRACEBACK
      RETURN
    ENDIF

    ; check if has directory defined

    IF STRLEN(strip_dirname(file)) EQ STRLEN(file) THEN file = concat_dir(ies_get_dir('PS',/POLAR),file)

    SET_PLOT, 'PS'

    IF KEYWORD_SET(portrait) THEN BEGIN
      DEVICE, /COLOR, BITS=8, FILE=file, XOFFSET=0.6, YOFFSET=0.5, XSIZE=19.9, YSIZE=26.5, /PORTRAIT
    ENDIF ELSE BEGIN
      DEVICE, FILE=file, BITS=8, /LANDSCAPE, /COLOR, XOFFSET=0.5, YOFFSET=27.5, XSIZE=27, YSIZE=19.9
    ENDELSE

    ; fix color table

    LOADCT, 39

  ENDIF ELSE WINDOW,/FREE

  !P.MULTI=0
  IF NOT KEYWORD_SET(charsize) THEN !P.CHARSIZE = 1 ELSE !P.CHARSIZE=charsize
  !P.REGION = [ 0.0, 0, 1.0, 1]

  ; plot data

  pos = 0.95
  size = 0.9/nplots

  FOR k = 0, N_ELEMENTS(orbits)-1 DO BEGIN

    pos = pos - size

    !P.REGION = [0,pos,1,pos+size]

    CASE type OF

      0 : BEGIN

        ; set up axes

        ies_do_axes, time_start, time_end, lshells[0], lshells[1], xmargin, ymargin, $
                 XTITLE='Time', YTITLE='L_phi', NO_XAXIS=(k NE nplots), /NO_ERASE

        ; get lphi at each point

        xl = FINDGEN(80)/4.0
        yl  = FLTARR(N_ELEMENTS(xl),(SIZE(struct))[2])

        FOR p = 0, (SIZE(struct))[2]-1 DO BEGIN

          led  = struct[orbits[k],p].led
          lphi = struct[orbits[k],p].lphi

          list = WHERE (lphi GT 0, count)

          IF count GT 1 THEN yl[*,p] = interp(led[list],lphi[list],xl)

        ENDFOR

        ; plot yl

        FOR l = 0, N_ELEMENTS(xl)-1 DO OPLOT, struct[orbits[k],*].time[0]-time_start, yl[l,*], PSYM=-3, $
                                            COLOR=40*(k+1)

       END

      1 : BEGIN

        IF NOT KEYWORD_SET(mom) THEN mom = 10 ; kev/nT

        ; check KSHEll and energy range

        ch = lsh_get_energies(INST=inst, IES=ies, IPS=ips, HISTE=histe, HISTP=histp, E0=e0, E1=e1)

        ; get channel sizes

        sz = REFORM(ch[1,e0:e1]-ch[0,e0:e1])

        ; get mean channel energies

        en = TOTAL(ch[*,e0:e1],1)/2

        ; set up axes

        ies_do_axes, time_start, time_end, lshells[0], lshells[1], xmargin, ymargin, $
                 XTITLE='Time', YTITLE='L_ed', NO_XAXIS=(k NE nplots), /NO_ERASE

        ; get lphi at each point

        FOR p = 0, (SIZE(struct))[2]-1 DO BEGIN

          led  = struct[orbits[k],p].led
          lphi = struct[orbits[k],p].lphi
          b0   = struct[orbits[k],p].b0
          bm   = struct[orbits[k],p].bm[0,*]

          list = WHERE (lphi GT 0, count)

          IF count GT 0 THEN BEGIN

            OPLOT, struct[orbits[k],p].time[list]-time_start, led[list],  $
                                            COLOR=40*(k+1)

            OPLOT, struct[orbits[k],p].time[list]-time_start+5*3600, lphi[list],  $
                                            COLOR=40*(k+1)+40

            llist = WHERE (b0[list] LE bm[list], count)

            IF count GT 0 THEN BEGIN

              list = list[llist]

              OPLOT, [struct[orbits[k],p].time[list]]-time_start, [led[list]], PSYM=4, $
                                            COLOR=40*(k+1)

              ; get energy in keV corresponding to fixed mag moment = mom at each l point

              energies = mom*bm

              ; check energy present

              llist = WHERE(energies[list] GE en[0] AND energies[list] LT en[e1-e0], count)

              IF count GT 0 THEN BEGIN

                list = list[llist]

                OPLOT, [struct[orbits[k],p].time[list]]-time_start, [led[list]], $
                                            COLOR=40*(k+1)+40
              ENDIF

            ENDIF

          ENDIF

        ENDFOR

       END

    ENDCASE


    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDFOR

  ; dst

  IF KEYWORD_SET(xdst) THEN BEGIN

    pos = pos - size

    IF NOT KEYWORD_SET(overlay) THEN !P.REGION = [0,pos,1,pos+size]

    IF NOT KEYWORD_SET(drange) THEN drange = [-250,20]

    ; set up axes

    ies_do_axes, time_start, time_end, drange[0], drange[1], xmargin, ymargin, XTITLE='Time', YTITLE='Dst [nT]', /NO_ERASE, OVERLAY=overlay

    ; plot Dst index

    OPLOT, dst.time-time_start, dst.dst, COLOR=200

    ; plot sampled Dst

    FOR k = 0, N_ELEMENTS(orbits)-1 DO BEGIN
      FOR p = 0, (SIZE(struct))[2]-1 DO BEGIN
        list = WHERE(struct[orbits[k],p].lphi NE 0, count)
        IF count GT 0 THEN $
          OPLOT, struct[orbits[k],p].time[list]-time_start, $
                 struct[orbits[k],p].parmod[1,list], PSYM=-3, COLOR=40*(k+1)
      ENDFOR
    ENDFOR

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

  ; pdyn

  IF KEYWORD_SET(xpdyn) THEN BEGIN

    pos = pos - size

    IF NOT KEYWORD_SET(overlay) THEN !P.REGION = [0,pos,1,pos+size]

    IF NOT KEYWORD_SET(prange) THEN prange = [-20,20]

    ; set up axes

    ies_do_axes, time_start, time_end, prange[0], prange[1], xmargin, ymargin, XTITLE='Time', YTITLE='Pdyn [nPa]', /NO_ERASE, OVERLAY=overlay

    ; plot

    OPLOT, pdyn.time-time_start, pdyn.data, COLOR=200

    ; plot sampled

    FOR k = 0, N_ELEMENTS(orbits)-1 DO BEGIN
      FOR p = 0, (SIZE(struct))[2]-1 DO BEGIN
        list = WHERE(struct[orbits[k],p].lphi NE 0, count)
        IF count GT 0 THEN $
          OPLOT, struct[orbits[k],p].time[list]-time_start, $
                 struct[orbits[k],p].parmod[0,list], PSYM=-3, COLOR=40*(k+1)
      ENDFOR
    ENDFOR

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

  ; bimf

  IF KEYWORD_SET(xbimf) THEN BEGIN

    pos = pos - size

    IF NOT KEYWORD_SET(overlay) THEN !P.REGION = [0,pos,1,pos+size]

    IF NOT KEYWORD_SET(brange) THEN brange = [-10,10]

    ; set up axes

    ies_do_axes, time_start, time_end, brange[0], brange[1], xmargin, ymargin, XTITLE='Time', YTITLE='By IMF [nT]', /NO_ERASE, OVERLAY=overlay

    ; plot

    OPLOT, bimf.time-time_start, bimf.data[0], COLOR=200

    ; plot sampled

    FOR k = 0, N_ELEMENTS(orbits)-1 DO BEGIN
      FOR p = 0, (SIZE(struct))[2]-1 DO BEGIN
        list = WHERE(struct[orbits[k],p].lphi NE 0, count)
        IF count GT 0 THEN $
          OPLOT, struct[orbits[k],p].time[list]-time_start, $
                 struct[orbits[k],p].parmod[2,list], PSYM=-3, COLOR=40*(k+1)
      ENDFOR
    ENDFOR


    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

    pos = pos - size

    IF NOT KEYWORD_SET(overlay) THEN !P.REGION = [0,pos,1,pos+size]

    IF NOT KEYWORD_SET(brange) THEN brange = [-10,10]

    ; set up axes

    ies_do_axes, time_start, time_end, brange[0], brange[1], xmargin, ymargin, XTITLE='Time', YTITLE='Bz IMF [nT]', /NO_ERASE, OVERLAY=overlay

    ; plot

    OPLOT, bimf.time-time_start, bimf.data[1], COLOR=200

    ; plot sampled

    FOR k = 0, N_ELEMENTS(orbits)-1 DO BEGIN
      FOR p = 0, (SIZE(struct))[2]-1 DO BEGIN
        list = WHERE(struct[orbits[k],p].lphi NE 0, count)
        IF count GT 0 THEN $
          OPLOT, struct[orbits[k],p].time[list]-time_start, $
                 struct[orbits[k],p].parmod[3,list], PSYM=-3, COLOR=40*(k+1)
      ENDFOR
    ENDFOR

    ; overplot axes again to neaten up
    ; NB use dont use data coords because x axis extended in data coords
    ; NB dont want to use plot again because of multiple plots

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDIF

  IF NOT KEYWORD_SET(title) THEN BEGIN

    titles = [' (Incoming North)',' (Incoming South)',' (Outgoing South)',' (Outgoing North)']
    title = titles[orbits[0]]
    FOR k = 1 , N_ELEMENTS(orbit)-1 DO title = title + '/' + titles[orbit[k]]
    title = anytim2cal(time_start,/DATE)+' to '+anytim2cal(time_end,/DATE)+ ' ' + title
  ENDIF

  XYOUTS, 0.5, 0.96, title, $
          ALIGNMENT=0.5, CHARSIZE=!P.CHARSIZE, /NORMAL

  IF KEYWORD_SET(postscript) THEN BEGIN
    DEVICE, /CLOSE
    SET_PLOT, devname
  ENDIF

END