
PRO do_flag, flag, val

  vals = REPLICATE(val,N_ELEMENTS(flag))

  list = WHERE(flag, count)

  OPLOT, vals, PSYM=4

  IF count GT 0 THEN OPLOT, list, vals[list], COLOR=150, PSYM=4

END

PRO map_show, map

  IF (SIZE(map))[0] EQ 2 THEN BEGIN

    nparts  = (SIZE(map))[1]
    norbits = (SIZE(map))[2]

  ENDIF ELSE BEGIN

    nparts = (SIZE(map))[1]
    norbits = 1

  ENDELSE

  !P.MULTI = [0,0,3*nparts+1,0,0]
  !P.REGION = 0
  !P.POSITION = 0
  WINDOW,0,XSIZE=512,YSIZE=750

  nlshells = N_ELEMENTS(map[0,0].led)

  FOR o = 0, norbits-1 DO BEGIN

    FOR p = 0, nparts-1 DO BEGIN

      PRINT, 'PART = ', p, ' ORBIT = ', o

      m = map[p,o]

      led = m.led
      lsh = m.lsh
      lphi0 = m.lphi0
      lphi = m.lphi
      rfl = m.rfl
      rnoon = m.rnoon
      rmidn = m.rmidn
      flag0 = m.flag[0,*]
      flag1 = m.flag[1,*]

      IF p LT nparts/2 THEN BEGIN
        list = REVERSE(INDGEN(nlshells))
        led = led[list]
        lsh = lsh[list]
        lphi0 = lphi0[list]
        lphi = lphi[list]
        rfl = rfl[list]
        rnoon = rnoon[list]
        rmidn = rmidn[list]
        flag0 = flag0[list]
        flag1 = flag1[list]
      ENDIF

      PLOT, led, PSYM=-2, YRANGE = [0,15]

      ;OPLOT, lsh, PSYM=-4, COLOR=100

      ;OPLOT, lphi0, PSYM=1, COLOR=200

      OPLOT, lphi, COLOR=200

      ;OPLOT, rfl, COLOR=150

      ;OPLOT, rnoon, COLOR=160, LINESTYLE=1

      ;OPLOT, rmidn, COLOR=170, LINESTYLE=2


      fl = flag0.ofl OR flag0.hes OR flag0.na OR flag0.nk
      ds = flag1.ofl OR flag1.hes OR flag1.na OR flag1.nk

      PLOT, [0,1], PSYM=-2, XRANGE=[0,nlshells], YRANGE=[0,8], /NODATA, YTICKS=8, YTICKNAME=[' ','flg','ofl','nmb','cb','hes','na','nk',' ']

      do_flag, fl, 1

      do_flag, flag0.ofl, 2
      do_flag, flag0.nmb, 3
      do_flag, flag0.cb,  4
      do_flag, flag0.hes, 5
      do_flag, flag0.na,  6
      do_flag, flag0.nk,  7

     PLOT, [0,1], PSYM=-2, XRANGE=[0,nlshells], YRANGE = [0,8], /NODATA, YTICKS=8, YTICKNAME=[' ','flg','ofl','nmb','cb','hes','na','nk',' ']

      do_flag, fl OR ds, 1

      do_flag, flag1.ofl, 2
      do_flag, flag1.nmb, 3
      do_flag, flag1.cb,  4
      do_flag, flag1.hes, 5
      do_flag, flag1.na,  6
      do_flag, flag1.nk,  7

    ENDFOR

    PLOT, map[0,o].led[list], PSYM=-2, YRANGE = [0,15]
    OPLOT, map[nparts-1,o].led, PSYM=-4
    OPLOT, map[0,o].lphi[list], COLOR=200
    OPLOT, map[nparts-1,o].lphi, COLOR=200

    IF GET_KBRD(1) EQ 's' THEN RETURN

  ENDFOR

  !P.MULTI = 0
END