PRO plot_monstor, struct, map, LSH=lsh, LED=led, LPHI=lphi, THICK=thick

  !P.REGION=0
  !P.POSITION=0
  !P.MULTI=0

  IF NOT KEYWORD_SET(thick) THEN thick = 1

  IF ies_tag_exists(struct,'LSH') THEN BEGIN

    PLOT, struct.time-struct[0].time,struct.lsh,/NODATA,YRANGE=[0,20]

    dat = TRANSPOSE([[struct.time-struct[0].time],[struct.lsh]])

    dev = CONVERT_COORD(dat,/DATA,/TO_DEVICE)

    FOR k=1,N_ELEMENTS(struct)-1 DO BEGIN

      xs = dev[0,[k-1,k]]

      ys = dev[1,[k-1,k]]

    ;  xs[1] = xs[0] + ((xs[1]-xs[0]) > !D.X_CH_SIZE)

      PLOTS, xs, ys, COLOR=20*(ALOG(struct[k].data[0])-5),THICK=thick, /DEVICE

    ENDFOR

  ENDIF ELSE BEGIN

    nparts = (SIZE(struct))[1]

    norbits = (SIZE(struct))[2]

    nlshells = N_ELEMENTS(struct[0,0].time)-1

    nlmap = N_ELEMENTS(map[0,0].time)

    ; just use time to key things together

    time_start = MAX([MIN(struct[0,0].time),map[0,0].time[0]])

    time_end = MIN([MAX(struct[nparts-1,norbits-1].time),MAX(map.time[nlmap-1])])

    PLOT, [0,1],/NODATA,YRANGE=[0,20],XRANGE=[0,time_end-time_start]

    ; loop though parts and orbits

    FOR p = 0, nparts-1 DO BEGIN

      FOR o = 0, norbits-1 DO BEGIN

        ; for each sample time get lsh or led or lphi

        sample_times = struct[p,o].time

        ; get end times

        end_times = [sample_times[0],sample_times[nlshells]]

        ; order end_times

        end_times = end_times[SORT(end_times)]

        ; get map point

        list = WHERE( map[p,*].time[0] LE end_times[1] AND map[p,*].time[nlmap-1] GE end_times[0], count)

        IF count EQ 0 THEN BEGIN

          PRINT, 'NO CORRESPONDING MAP PASS'

        ENDIF ELSE IF count GT 1 THEN BEGIN

          MESSAGE, 'ERROR FINDING MAP PASS'

        ENDIF ELSE BEGIN

          rmap = map[p,list[0]]

          ; get list of where data exists in Led

          list = WHERE(struct[p,o].data[0,*] NE 0.0, count)

          IF count GT 0 THEN BEGIN

            sample_times = sample_times[list]

            data = struct[p,o].data[*,list]

            ; lop through each sample

            FOR c = 0, N_ELEMENTS(sample_times)-2 DO BEGIN

              ; get sample period

              period = sample_times[c:c+1]

              ; order

              period = period[SORT(period)]

              ; for each sample get ephemeris data spanning sample period

              list = WHERE(rmap.time LE period[0], count)

             IF count EQ 0 THEN GOTO, next

              c0 = list[count-1]

              list = WHERE(rmap.time GE period[1], count)

              IF count EQ 0 THEN GOTO, next

              c1 = list[0]

              IF c1 EQ c0 THEN BEGIN

                c0 = (c0 - 1) > 0

                c1 = (c1 + 1) < (nlmap-1)

              ENDIF

              ; get L values

              IF KEYWORD_SET(led) THEN lvalues = rmap.led $
              ELSE IF KEYWORD_SET(lsh) THEN lvalues = rmap.lsh $
              ELSE lvalues = rmap.lphi

              ; check if sample period spans times when Lphi cannot be calculated

               duff = WHERE(lvalues[c0:c1] EQ 0, count)

               IF count GT 0 THEN GOTO, next

               ls = INTERPOL(lvalues[c0:c1],rmap.time[c0:c1],period)

               PLOTS, period-time_start, ls, COLOR=20*(ALOG(data[0,c])-5),THICK=thick

next :

            ENDFOR

          ENDIF ELSE PRINT, 'NO LED DATA'

        ENDELSE

      ENDFOR

    ENDFOR

  ENDELSE

END