PRO sinfit, x, a, f, fder

  ; Fitting function for b*sin^a
  ; expects dimensions of aa to be two
  ; Used by CURVEFIT i.e
  ;  fit = CURVEFIT ( x, y, wgts, aa, sigs, FUNCTION_NAME = 'fitsin' )

  ; x = list of npoint x values
  ; a = list of npar   parameter values
  ; fder = (npoints,npar) array of partial derivatives

  ; form partial derivatives

  IF ( N_PARAMS() GT 3 ) THEN fder = DBLARR( N_ELEMENTS(x), N_ELEMENTS(a) )

  sx = SIN(x)

  sxa = sx^(a[1]>0)

  f  = (a[0]>0)*sxa

  IF ( N_PARAMS() GT 3 ) THEN BEGIN

    fder(*,0)  = sxa

    fder(*,1)  = ALOG(sx)*f

  ENDIF

END
