pro r_polar_ceppad_histe, datestr, zmat, time, MODE=MODE, YARR=YARR
  
  common cep_if_data, input_header, input_data
  common get_error, get_err_no, get_err_msg  
  common mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
   
; datestr : a string containing the date as yyyymmdd   
; time    : time array
; zmat    : data array, all channels for each time   
;   
;MODE selects the HIST mode for the returned data. 
;   mode=0 : HBC mode, good for high energies (does not contain low energies).
;            use for channels 10-14
;   mode=1 : ABC mode, good for low energies (contains all energies)
;            use for channels 2-9
;   mode=2 : combination ABC/HBC mode. 0:9 from ABC, 10:15 from HBC,
;            on a common timebase.              
;
;   Avoid using channels 0,1,15 - they are not very good in any mode. 
                
   if keyword_set(MODE) then mode=MODE else mode=1 ; default os ABC mode
   
; uses papco routines to set up the time. Needed by polar_ceppad_flux_conv
   year=fix(strmid(datestr,0,4))
   mon=fix(strmid(datestr,4,2))
   day=fix(strmid(datestr,6,2))
   
   mjdt_start=convert_date_to_t90( day=day, month=mon, year=year, /MJDT)
   
;uses the routine  r_polar_ceppad_if_oneday from
;$PAPCO_XX/papco_modules/polar_ceppad\plot_read\r_polar_ceppad Needs
;the following env. variables set: PO_CEP_IF_ARCHIVE, PO_CEP_IF_DIR. 
   
   r_polar_ceppad_if_oneday, datestr, $
     INSTRUMENT='HISTe',MODE='SPIN_1Z16',LOCATION='LANL'
   
   ;this bit makes the data array used by the plot routine. Lifted from
   ;p_polar_ceppad_detch
   
       time=input_data.time
       ndat=n_elements(time)
       zmat=fltarr(ndat,input_header.NBANDS) ;data is in counts
       for i=0,ndat-1 do zmat(i,*)=input_data(i).DATA(0,0,*)
       uytitle=input_header.YTITLE+'[keV]'
       mode_title=['HBC mode','ABC mode','ABC/HBC mode']
       utitle=mode_title(mode)
       message,'Getting '+datestr+' data for HISTe  '+utitle,/cont
       
       ;uses the routine polar_ceppad_flux_conv, also in p_polar_ceppad_detch
         ch=fltarr(2,input_header.NBANDS)
         result=polar_ceppad_flux_conv(time, zmat, /HISTe, $
                                       MODE=mode, CHANNELS=ch)
         ;load new channel assignment
         yminarr = ch(0,*)
         ymaxarr = ch(1,*)
         yarr=ch
         input_header.cal=1
         input_header.div=1
         input_header.rat=1
         
         ;select "good" range of channels.
         ;zmat=zmat(*,2:14)
         ;yminarr=yminarr(2:14)  &  ymaxarr=ymaxarr(2:14)
         ;yst=yminarr(0)  &  yen=ymaxarr(n_elements(ymaxarr)-1)
         
         spec=0
         if spec eq 0 then begin
           ;Fix overlapping channels for spec only. Get midpoints, then grow
           ;channels until they join.
           mid=alog10((yminarr+ymaxarr)/2.0)
           dif=mid(1:n_elements(mid)-1)-mid(0:n_elements(mid)-2)
           for i=1,n_elements(yminarr)-1 do yminarr(i)=10^(mid(i)-dif(i-1)/2.0)
           for i=0,n_elements(ymaxarr)-2 do ymaxarr(i)=10^(mid(i)+dif(i)/2.0)
         endif
       
end  
