; routine to set up common channel info for ceppad.
PRO polar_ceppad_commons
  
COMMON polar_ceppad, typeNames, pitchNames, $
                     select_names, select_range, select_frmts, $
                     average_names, average_range, average_frmts, $
                     polar_ceppad_control
  
;possible if-files (not public version)  
typeNames = ['IPS', 'IES' , 'HISTe' , 'HISTp']

;enter variables for filtering the data
select_names = ['L', 'L_STAR', 'MLT', 'MLAT', 'B_X', 'B_MAG', 'Z_GSE']
select_range = [[2.0, 20, 0.2], [2.0, 20, 0.2], [0.0, 24, 0.25], $
                [-90.0, 90.0, 5.0], [-15, 15.0, 0.5], [0, 100.0, 0.5], $
                [-15, 15.0, 0.05]]  ;low, high, res
select_frmts = ['(f4.1)','(f4.1)','(f5.2)','(f5.1)','(f6.2)','(f6.2)','(f6.2)']

;enter variables for averaging/selecting the data
average_names = ['Detector', 'Sector', 'Energy','Pitch']
average_range = [[0, 8, 1], [0, 15, 1], [0, 17, 1], [0, 180, 2]]
average_frmts = ['(i1)', '(i2)', '(i2)', '(i3)']

;set up a structure for all the variables needed by the
;cluster rapid module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains are
;descriptive and verbose tags for easier use.

polar_ceppad_control = { $
  product:0,    product_info:'Routine Product; index into typeNames.', $
  sectors:16,   sectors_info:'IF file sector averaging', $
  spins:16,     spins_info:'IF file spin averaging', $
  pl_type:0,    pl_type_info:'0: Ek @ Det/Sec, 1: Roll @ Ek/Det, 2: Mask, '+ $
                             '3: Ek @ PA, 4: PA @ Ek, 5: Mu Range', $
  cal:1,        cal_info:'0: Counts, 1: Flux, 2: PSD, 3: PSD @ const.mu, '+$
                         '4: Pitch Det Cal mode' , $

  av_3dd:0,     av_3dd_info:'3DD Slice +/- # of spins to average', $
  pa_ctr_3dd:0, pa_ctr_3dd_info:'3DD Slice PA contour overlay 0-off,1-0n', $
  pa_lbl_3dd:0, pa_lbl_3dd_info:'3DD Slice PA label overlay 0-off,1-0n', $
  reload:0,     reload_info:'0: reload data, 1: adopt from memory',  $
  spec:1,       spec_info:'0: line plot, 1: color plot', $
  spec_intpol:0,  spec_intpol_info:'No of channel to interpolate spec to', $
  mu:'',        mu_info:'String of comma seperated mu, (MeV/G)', $
  hist:1,       hist_info:'0: HBC (High Energy), 1: ABC (Low Energy), '+ $
                          '2: ABC/HBC combination',  $
  mask:0,       mask_info:'0: Do not Apply, 1: Apply', $
  filter:0,     filter_info:'Index into select_names filter varibale to use', $
  seg_av:0,     seg_av_info:'0: plot all, 1: average', $
  pa_bin:10,    pa_bin_info:'Pitch angle bin width, centered on 90 deg.', $
  bckgnd:1,     bckgnd_info:'0: do not subtract, 1: subtract background', $
  satur:1,      satur_info:'0: ignore, 1: do not ignore saturation levels', $
  crosscal:1,   crosscal_info:'0: do not apply, 1:apply cross cal' $
  }

;get the papco panel tags for the select variables.
FOR i = 0, n_elements(select_names)-1 DO $
  polar_ceppad_control = CREATE_STRUCT(polar_ceppad_control, $
               papco_panel_AddVar_Sel_Widgets(aBase, select_names(i), $
                                              select, st, en, v1, v2, vr, $
                                              select_frmts(i), /STRUCT_ONLY))

;get the papco_panel tags for the average variables.
FOR i = 0, n_elements(average_names)-1 DO $
  polar_ceppad_control = CREATE_STRUCT(polar_ceppad_control, $
               papco_panel_AddVar_Ave_Widgets(aBase, average_names(i), $
                                              st, en, v1, v2, vr, $
                                              average_frmts(i), /STRUCT_ONLY))
;set some defaults for the average variables
polar_ceppad_control.PITCH_AVERAGE_FROM_VAL = 85
polar_ceppad_control.PITCH_AVERAGE_TO_VAL = 95
polar_ceppad_control.ENERGY_AVERAGE_FROM_VAL = 0
polar_ceppad_control.ENERGY_AVERAGE_TO_VAL = 17
polar_ceppad_control.SECTOR_AVERAGE_FROM_VAL = 0
polar_ceppad_control.SECTOR_AVERAGE_TO_VAL = 16
polar_ceppad_control.DETECTOR_AVERAGE_FROM_VAL = 0
polar_ceppad_control.DETECTOR_AVERAGE_to_VAL = 8

;finally name the control structure. This is required for load/save operations!
polar_ceppad_control = CREATE_STRUCT(name = 'polar_ceppad_control', $
                                             polar_ceppad_control)

END 
