;******************************************************************************
;* file papcoadd_polar_eph
;*      papcoadd_polar_eph
;*      papcoadd_polar_eph_ticks
;* end
;*
;* this files contains all the collected routines which have to be added in
;* for polar_eph.
;*
;* papco is written such that if the files starting with "papcoadd" exist
;* in the papco_MODULES directory
;* then the routines contained therin are utilised to add that plot type
;* into the papco package. This ensures easy extendability of papco; also makes
;* papco "configurable" by adding or leaving out specific Plot types.
;*
;******************************************************************************

;******************************************************************************
;* PROCEDURE:
;*      PRO addplottype_polar_eph,plottypes_base,buttonGeometry,pb_plottype
;*
;* DESCRIPTION:
;*	This procedure adds a button for this plottype to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*	papckage, so that they can be automatically called when needed.
;*
;* INPUTS:
;*	plottypes_base	the widget ID of the parent widget to contain the
;*			plottype buttons.
;*      buttonGeometry  size of the button
;*
;* OUTPUTS:
;*   	pb_plottype	the widget ID of the button created here.
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	addplottype_polar_eph,plottypes_base,pb_plottype
;*
;* MODIFICATION HISTORY:
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro addplottype_polar_eph,plottypes_base,buttonGeometry,pdm_polar_eph

MenuDesc = [ $
        { CW_PDMENU_S, 3, strcenter('POLAR-EPH',10) }, $
        { CW_PDMENU_S, 0, ' configure polar_eph ' }, $
        { CW_PDMENU_S, 0, ' plot polar_eph      ' }, $
        { CW_PDMENU_S, 2, ' plot polar_eph_ticks' } ]

pdm_polar_eph = CW_PDMENU(plottypes_base, MenuDesc, UVALUE='pdm_polar_eph')

END

;******************************************************************************
;* PROCEDURE:
;*      PRO addpanel_polar_eph,event
;*
;* DESCRIPTION:
;*	Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      using an instance of the papco_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled.
;*
;* INPUTS:
;*	event		event value of papco main window
;*
;* OUTPUTS:
;*   	none
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	addpanel_polar_eph
;*
;* MODIFICATION HISTORY:
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro addpanel_polar_eph, event

COMMON get_error, get_err_no, get_err_msg

panelKind='polar_eph'

r_module_config, strlowcase(panelKind), config_data, msg
if (get_err_no ne 0) and (event.value ne 1) then begin
    message, 'you need to configure the module first', /cont
    papco_module_configure,'polar_eph'
    return
endif

CASE event.value of
    1: BEGIN
        papco_module_configure, panelKind
    END
    2: BEGIN
        panelEditor=panelkind+'_panel'
        defaults=papco_getPlotInfoStruct() ;returns a basic plotinfo structure
        defaults.typeVector=[0,1,0,0]      ;set some tags to desired defaults
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults
    END
    3: BEGIN
        panelKind=panelKind+'_ticks'
        panelEditor=panelkind+'_panel'
        defaults=papco_getPlotInfoStruct() ;returns a basic plotinfo structure
        defaults.typeVector=[0,1,0,0]      ;set some tags to desired defaults
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults
    END

    ELSE: BEGIN
        message, 'Nothing defined for this submenu entry', /cont
        return
    END
ENDCASE

END

;******************************************************************************
;* PROCEDURE:
;*      PRO plottable_polar_eph, plottable
;*
;* DESCRIPTION:
;*	Sets a variable to indicate plottable without orbit.
;*
;* INPUTS:
;*	none
;*
;* OUTPUTS:
;*   	plottable	a boolean 0 if plottable only by CRRES orbit
;*                                1 if plottable by time also.
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	plottable_polar_eph, plottable
;*
;* MODIFICATION HISTORY:
;*     written November 1995, Reiner Friedel
;******************************************************************************
PRO plottable_polar_eph, plottable & plottable=1 & END
PRO plottable_polar_eph_ticks, plottable & plottable=1 & END

;******************************************************************************
;* PROCEDURE:
;*      PRO canget_polar_eph, canget
;*
;* DESCRIPTION:
;*      Sets a variable to indicate that polar_eph support the OUTPUT
;*      functionality.
;*
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "canget_" plus
;*      the panel_kind you have set for your submenu entry in
;*      addpanel_polar_eph.
;*
;* INPUTS:
;*      none
;*
;* OUTPUTS:
;*      canget         a boolean 0 if this feature is not available
;*                               1 if this feature is available
;*
;* KEYWORDS:
;*      none
;*
;* CALLING SEQUENCE:
;*      canget_polar_eph, canget
;******************************************************************************
PRO canget_polar_eph, canget & canget = 1 & END
PRO canget_polar_eph_ticks, canget & canget = 1 & END

;******************************************************************************
;* PROCEDURE:
;*      PRO descriptor_polar_eph, plotInfo, descriptStr
;*
;* DESCRIPTION:
;*	Constructs the string used to label plots in the panel window
;*
;* INPUTS:
;*	plotInfo        structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO,
;*                                             see papco_variables.text)
;*
;* OUTPUTS:
;*   	descriptStr	a string containing the label
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	descriptor_polar_eph, plotInfo, descriptStr
;*
;* MODIFICATION HISTORY:
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro descriptor_polar_eph, plotInfo, descriptStr
descriptStr=descriptStr+'ephemeris Index : ' + $
            strtrim(string(plotInfo.typeVector(1)), 2)
END
PRO descriptor_polar_eph_ticks, plotInfo, descriptStr
descriptStr=descriptStr+'ephemeris ticks'
END

;******************************************************************************
;* PROCEDURE:
;*      PRO draw_polar_eph, panelVector, currPlotInfo, orbitNr, $
;*                                     get_data_call, slice_type, IsRead
;* DESCRIPTION:
;*	This procedure performs the actual data read call and the plot call
;*      for this plottype
;*
;* INPUTS:
;*	panelVector	position of the plot (see papco_conventions.text, 6)
;*	currPlotInfo	structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO,
;*                                             see papco_variables.text)
;*
;* OUTPUTS:
;*   	get_data_call	a string containing the data call. Used by other
;*                      routines that need to know how to get the data
;*                      in a panel, eg. to draw spectra, distribution functions
;*      IsRead		a boolean which is set when the the data is read the
;*                      first time. Useful if a given data read puts data
;*                      into commons which can be plotted in many ways.
;*                      When set, data does not have to be read again.
;*      slice_type      Selects which slices are supported and for which
;*                      slice routines have been written.
;*                      This is a byte logical with 8 swittches. Currently
;*                      These are supported (this may be extended later)
;*                       1 =  mouse zooms
;*                       2 =  mouse vertical slices
;*                       4 =  mouse calls level zero
;*                       8 =  mouse calls write paneldata
;*                       16 = mouse calls haircursor
;*                       32 = mouse vertical slices
;*                       64 on = USER slices
;*                       0 = disable all
;*                      you can support more than one type of slice
;*                      by arithmetically adding the options, eg
;*                      slice_type=5  support zoom and level zero
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	draw_polar_eph, panelVector, currPlotInfo, $
;*                          get_data_call, slice_type, IsRead
;*
;* MODIFICATION HISTORY:
;*     written November 1995, Reiner Friedel
;*    modified December 1995, Reiner Friedel, to support overplot, color
;*                                            and line styles
;*    modified November 1997, Reiner friedel, to support output
;******************************************************************************
pro draw_polar_eph, panelVector, currPlotInfo, orbitNr, $
                    get_data_call, Slice_type, IsRead, $
                    OUTPUT=OUTPUT

COMMON extra, extra_PlotInfo

get_data_call=''

slice_assigned_value=papco_slice_value('USER View_Ephemeris')
if slice_assigned_value eq -1 then slice_assigned_value=0

; set up which mouse functions to allow
slice_Type=1+16+slice_assigned_value

isread = 0 ;always recheck...

IF NOT IsRead THEN BEGIN               ; check if data has already been read
    r_polar_eph, currPlotInfo          ; read data
     ; check the read for success.
    IF papco_Draw_CheckResult(currPlotInfo.panelKind, $
                              panelVector, orbitNr, $
                              currPlotInfo.typeVector, $
                              currPlotInfo.channel) $
    THEN IsRead=0 ELSE BEGIN IsRead=0 & return & ENDELSE
ENDIF

p_polar_eph, panelVector, currPlotInfo, $
                          OUTPUT=OUTPUT, _EXTRA=extra_PlotInfo

END

;******************************************************************************
pro draw_polar_eph_ticks, panelVector, currPlotInfo, orbitNr, $
                          get_data_call, Slice_type, IsRead, $
                          OUTPUT=OUTPUT

COMMON extra, extra_PlotInfo

get_data_call=''
slice_assigned_value=0
slice_Type=0

isread = 0 ;always recheck...

IF NOT IsRead THEN BEGIN     ; check if data has already been read
    r_polar_eph, currPlotInfo          ; read data
    ; check the read for success.
    IF papco_Draw_CheckResult(currPlotInfo.panelKind, $
       panelVector, orbitNr, currPlotInfo.typeVector, $
                                currPlotInfo.channel) $
    THEN IsRead=1 ELSE BEGIN IsRead=0 & return & ENDELSE
ENDIF

p_polar_eph_ticks, panelVector, currPlotInfo, $
                   OUTPUT=OUTPUT, _EXTRA=extra_PlotInfo

END
