pro orbit_3d,xrot,zrot,um,up,kp

common isee_ephem, iyear,time,iday,xgsm,ygsm,zgsm
common fline, flx,fly,flz,count
common t89data, iy,i,xut,ikp

arrsize=size(xgsm)
ndat=arrsize(1)

sphere=fltarr(11,11,11)
xeqp=fltarr(11,11)
yeqp=fltarr(11,11)
zeqp=fltarr(11,11)
eqp=fltarr(50,3)
lval=fltarr(50,3)

ikp=kp
   
for i=0,10 do begin
  for j=0,10 do begin
    for k=0,10 do begin
      sphere(i,j,k) = sqrt((i-5)^2+(j-5)^2+(k-5)^2) / 5
    endfor
   endfor
endfor
shade_volume,sphere,1.,v,p,/low
s=size(v)
for i=0,s(1)-1 do begin
  for j=0,s(2)-1 do begin
     v(i,j) = v(i,j) / 5  -1
  endfor
endfor

loadct,2

; make a simple color table for this application. 0=black, 1=white, 3=grren, 
; 4=blue, 5=yellow
red=   [0,1,1,0,0,1]
green= [0,1,0,1,0,1]
blue=  [0,1,0,0,1,0]
tvlct,255*red,255*green,255*blue

if !d.name eq 'X' then begin
  xc=1. &   f1=3. &  f2=1. &  xs=1. &  tc=1. &  th=1. &  fth=2. &  tl=.01 &     oth=4. &  fth=1. &   mf=1. &  xsi=870 &  ysi=870 
  window,title='CRRES 3-D ORBIT PLOT',XSIZE=xsi,YSIZE=ysi
endif else begin
  xc=0.03 &  f1=2.5 &  f2=1.5 &  xs=0.06 &  tc=.1 &  th=.1 &  oth=.4 &  fth=.2 &  tl=.01 &  xsi=870 &  ysi=870
  mf=1.
  set_plot,'ps',/interpolate
  device,xs=.87,ys=.87,scale=20,xoffset=0.5,yoffset=25,fil='orbit2.ps',/color, bits=8,/landscape
  !p.noerase=1
endelse
 
!p.region=[0.,0.,1.,1.]
!p.position=[0.0,0.0,1.,1.]

x=findgen(10)
plot,x,/nodata,xst=4,yst=4

!p.t3d=1                           ; initialise transformation matrix
rfscale3,xr=[-7,7],yr=[-7,7],zr=[-7.,7.],ax=xrot,az=zrot,usermag=um,userpos=up

; draw sphere for earth
tvscl,polyshade(v,p,/t3d,xsize=xsi,ysize=xsi)

; set up own axis system
axis,0,0,0,xax=1,/data,charsize=xc,charthick=tc,xthick=th,xr=[-11.,11.],/save, /t3d,xtitle='X (GSM)                                                           ',  xtickformat='nozero',xstyle=1,xmargin=[0,0],ticklen=tl
axis,0,0,0,yax=0,/data,charsize=xc,charthick=tc,ythick=th,yr=[-11.,11.],/t3d, ytitle='                                                           Y (GSM)', ytickformat='nozero',ystyle=1,ymargin=[0,0],ticklen=tl
axis,0,0,0,zax=1,/data,charsize=xc,charthick=tc,zthick=th,zr=[-11.,11.],/t3d, ztitle='                                                     Z (GSM)', ztickformat='nozero',zstyle=1,zmargin=[0,0],ticklen=tl

; plot orbit curve
plots,xgsm(0),ygsm(0),zgsm(0),/data,/t3d
for i=1,ndat-1 do begin
  plots,xgsm(i),ygsm(i),zgsm(i),/data,/continue,/t3d,thick=oth,$
    color=2
endfor 

; plot field lines
for i=1,ndat-1,10 do begin
  field_line,xgsm(i),ygsm(i),zgsm(i),time(i),iyear,iday,ikp
  plots,xgsm(i),ygsm(i),zgsm(i),psym=4,symsize=xs,thick=th
  iy=iyear(i)
  id=iday(i)
  xut=time(i)
  if n_elements(flx) gt 2 then begin 
    lvalue,flx,fly,flz,xeq,yeq,zeq,lv
    top=xgsm(i)*xeq+ygsm(i)*yeq+zgsm(i)*zeq 
    bott=sqrt(xgsm(i)^2+ygsm(i)^2+zgsm(i)^2)*sqrt(xeq^2+yeq^2+zeq^2)
    maglat=acos(top / bott)
    if zeq ge zgsm(i) then maglat=-maglat
    print,top,bott,maglat,maglat*57.29578
    eqp(i/10,*)=[xeq,yeq,zeq]
    lval(i/10,*)=lv
    plots,flx(0),fly(0),flz(0),/data,/t3d
    for j=1,count-1 do begin
      plots,flx(j),fly(j),flz(j),/data,/continue,/t3d,thick=fth,color=4
    endfor
  endif
endfor 

; plot line connection equatorial crossings
plots,eqp(0,0),eqp(0,1),eqp(0,2),/data,/t3d
for i=1,ndat-1,10 do begin
  j=i/10
  plots,eqp(j,0),eqp(j,1),eqp(j,2),/data,/continue,/t3d,thick=fth,$
      color=3
endfor  

;plot time string on each field line
for i=1,ndat-1,10 do begin
  j=i/10
  plots,eqp(j,0),eqp(j,1),eqp(j,2),psym=2,symsize=xs/2.,thick=th
  if time(i) gt 86400.0 then time(i)=time(i)-86400
  timestr='  '+timeticks(time(i))
  lstr=string(lval(j),format="(f4.1,'  ')")
  if lval(j) eq 0 then lstr=' '
  d=convert_coord(xgsm(i),ygsm(i),zgsm(i),/to_device,/t3d,/data)
  d=long(d)
  !p.t3d=0
  xyouts,d(0),d(1),timestr,/device,color=2,charsize=xc*f2,charthick=tc
  xyouts,d(0),d(1),lstr,/device,color=2,charsize=xc*f2,charthick=tc, align=1.0
  !p.t3d=1
endfor

; write plot information
!p.t3d=0
xp=fix(20.0*mf)
yp=fix(830.0*mf)
ys=fix(10*mf)
xyouts,xp,yp,'ISSEE-2 3-D ORBIT PLOT',/device,color=100,charsize=xc*f1,$
   charthick=tc*f1
xyouts,xp,yp-ys*3,'T-89 magnetic field model',/device,color=2,charsize=xc*f1,$
   charthick=tc*f2
xyouts,xp,yp-ys*5,'For IKP ='+string(format='(i2)',ikp),/device,color=2, $
   charsize=xc*f2,charthick=tc
xyouts,xp,yp-ys*7,'Year:'+string(format='(i5)',iyear(0))+', Day:'+ string(format='(i3)',iday(0)), /device,color=2,charsize=xc*f2,charthick=tc 

if !d.name ne 'X' then device,/close

end

function nozero,axis,index,t
if t eq 0. then return,' ' else return,string(t,format="(f4.1)")
end 

function timeticks,t
if (t gt 86400.0) then t = t- 86400.0
hour = long(t)/3600
minute = long(t-3600 * hour) / 60
sec= t mod 60 

return,string(hour,minute,format="(i2.2,':',i2.2)")
end 
