pro p_eph_3d,xrot,zrot,um,up,gsm

  common scaling_3d, x_s, y_s, z_s, old_p_t, first
  common papco_color_names

; set up scalings in case output is required
  if !d.name eq 'X' then begin
     xc=1.25 &   f1=3. &  f2=1. &  xs=1. &  tc=1. &  th=1. &  fth=2.
     tl=.01 &     oth=2. &  fth=1. &   mf=1. &  xsi=500 &  ysi=500 
  endif else begin
     xc=0.03 &  f1=2.5 &  f2=1.5 &  xs=0.06 &  tc=.1 &  th=.1 &  oth=.4
     fth=.2 &  tl=.01 &  xsi=500 &  ysi=500
     mf=1.
     set_plot,'ps',/interpolate
     device,xs=.87,ys=.87,scale=20,xoffset=0.5,yoffset=25,fil='orbit2.ps', $
            /color, bits=8,/landscape
     !p.noerase=1
   endelse
 
   !p.region=[0.,0.,1.,1.]
   !p.position=[0.0,0.0,1.,1.]

   x=findgen(10) & plot,x,/nodata,xst=4,yst=4

   !p.t3d=1                     ; initialise transformation matrix
   xrange=[-15,15]
   yrange=[-15,15]
   zrange=[-15,15]
   rfscale3,xr=xrange,yr=yrange,zr=zrange, $
            ax=xrot,az=zrot,usermag=um,userpos=up

; set up own axis system
   !x.ticks=0
   axis,0,0,0,xax=1,/data,charsize=xc,charthick=tc,xthick=th,xr=xrange, $
        /save, /t3d, $
        xtitle='X (GSM)                                                     ', $
        xtickformat='nozero', xstyle=1, xmargin=[0,0], ticklen=tl, color=1
   axis,0,0,0,yax=0,/data,charsize=xc,charthick=tc,ythick=th,yr=yrange, $
        /save, /t3d, $
        ytitle='                                                     Y (GSM)', $
        ytickformat='nozero', ystyle=1, ymargin=[0,0], ticklen=tl, color=1
   axis,0,0,0,zax=1,/data,charsize=xc,charthick=tc,zthick=th,zr=zrange, $
        /save, /t3d, $
        ztitle='                                                     Z (GSM)', $
        ztickformat='nozero', zstyle=1, zmargin=[0,0], ticklen=tl, color=1

; plot orbit!   
   plots,gsm(0,0),gsm(1,0),gsm(2,0), /data, /t3d
   for i=1,n_elements(gsm)/3-1 do plots,gsm(0,i),gsm(1,i),gsm(2,i), $
                                 /data, /continue, /t3d, thick=oth, color=1
; plot projections of orbit onto coordinate planes
   plots,gsm(0,0),gsm(1,0),0, /data, /t3d ;xy plane
   for i=1,n_elements(gsm)/3-1 do plots,gsm(0,i),gsm(1,i),0, linestyle=1, $
                                 /data, /continue, /t3d, thick=1, color=red
   plots,gsm(0,0),0,gsm(2,0), /data, /t3d ;xz plane
   for i=1,n_elements(gsm)/3-1 do plots,gsm(0,i),0,gsm(2,i),  linestyle=1, $
                                 /data, /continue, /t3d, thick=oth, color=blue
   plots,0,gsm(1,0),gsm(2,0), /data, /t3d ;yz plane
   for i=1,n_elements(gsm)/3-1 do plots,0,gsm(1,i),gsm(2,i),  linestyle=1, $
                                 /data, /continue, /t3d, thick=oth, color=green

; save axis scaling
   x_s=!x.s & y_s=!y.s & z_s=!z.s
   old_p_t=!p.t

; turn off 3-D projections again.
   !p.t3d=0

; set swittch to indicate new orbit plot has been drawn
  first=1

end

;-------------------------------------------------------------------------------
; plot position of satellite.
; Keywords: TRACE - plot field line tracing intercepts
pro p_pos_3d,xrot,zrot,um,up,current_pos, TRACE=TRACE

  common old_pos, gsm_old, trace_old
  common scaling_3d, x_s, y_s, z_s, old_p_t, first
  common papco_color_names

  result=size(old_pos) & if result(1) eq 0 then firstpoint=1

  DEVICE, SET_GRAPHICS=6 ; set XOR-Mode for graphics

  !p.region=[0.,0.,1.,1.]
  !p.position=[0.0,0.0,1.,1.]

  x=findgen(10) & plot,x,/nodata,xst=4,yst=4,/noerase

  !p.t3d=1                           ; initialise transformation matrix
  !p.t=old_p_t
  !x.s=x_s & !y.s=x_s & !z.s=x_s     ; reset axis scaling
  sat_size=2
  
   ; erase old position if there is one plotted
   if not first then begin 
       plots,gsm_old(0),gsm_old(1),gsm_old(2), $
         /data, /t3d, psym=2, symsize=sat_size, thick=2, color=black
       plots,0,gsm_old(1),gsm_old(2), $
         /data, /t3d, psym=2, symsize=sat_size, thick=1, color=green
       plots,gsm_old(0),0,gsm_old(2), $
         /data, /t3d, psym=2, symsize=sat_size, thick=1, color=blue
       plots,gsm_old(0),gsm_old(1),0, $
         /data, /t3d, psym=2, symsize=sat_size, thick=1, color=red
   endif

   plots,current_pos(0),current_pos(1),current_pos(2), $
         /data, /t3d, psym=2, symsize=sat_size, thick=2, color=black
   plots,0,current_pos(1),current_pos(2), $
         /data, /t3d, psym=2, symsize=sat_size, thick=1, color=green
   plots,current_pos(0),0,current_pos(2), $
         /data, /t3d, psym=2, symsize=sat_size, thick=1, color=blue
   plots,current_pos(0),current_pos(1),0, $
         /data, /t3d, psym=2, symsize=sat_size, thick=1, color=red

   
   if keyword_set(TRACE) then begin ;plot field line tracing result
     print, trace
     if trace_old.flag eq 1 then begin
       if not first then begin 
         equ_pos=trace_old.d
         plots,equ_pos(0),equ_pos(1),equ_pos(2), $
           /data, /t3d, psym=6, symsize=2, thick=2, color=magenta
       endif
     endif
     
     if trace.flag eq 1 then begin
       equ_pos=trace.d
       plots,equ_pos(0),equ_pos(1),equ_pos(2), $
           /data, /t3d, psym=6, symsize=2, thick=2, color=magenta
     endif
     trace_old=trace
     
   endif  
     
  gsm_old=current_pos

  DEVICE, SET_GRAPHICS=3 ; set copy-mode for graphics

; turn off 3-D projections again.
  !p.t3d=0
  first=0

end
