; Program to read POLAR polar_eph files and to convert them to the
; COMMON INTERFACE fortran format needed by the UNIRAD package

pro polar2cif
  
  common polar_ephem, polar_ephem  
      
;setup search path for data
   data_dir=getenv('POLAREPHMPATH')
   if strlen(data_dir) eq 0 then begin
      get_err_no=1
      get_err_msg='Environmental variable (POLAREPHMPATH) not set'
      print,get_err_msg
      return
   endif else begin
      get_err_no=0
      get_err_msg=''     
   endelse

   IF strmid(data_dir,strlen(data_dir)-1,1) NE '/' THEN data_dir=data_dir+'/'
   cif_data_dir=data_dir+'unirad_cif/'
   
   print, 'Compiling list of all POLAR polar_eph files...'  
   files=findfile(data_dir+'*.DAT')
   print, '...found', N_ELEMENTS(files), ' polar_eph-files'
   
stop

;   for i=0,n_elements(files)-1 do begin
   for i=0,0 do begin
     r_polar_ephem_oneday,files(i),VERBOSE=0
     print,'Doing ',files(i)
     pos=strpos(files(i),'PO_EPH_')
     file_id=strmid(files(i),pos,15)
     yr=fix(strmid(file_id,7,4))
     mon=fix(strmid(file_id,11,2))
     day=fix(strmid(file_id,13,2))     
     
     hour=0
     min=0
     sec=0.0
     doy=180
     apog=360000
     perig=7000
     incl=85
     outfile=cif_data_dir+file_id+'.int'
     
     ;HEADER RECORDS - all must be 178 bytes/characters long!
     Head_rec_1=string('POLAR polar_eph','',format="(1x,a15,a162)")
     Head_rec_2=string(yr,mon,day,hour,min,sec,apog,perig,incl,'', $
                           format="(1X,5i6,f8.4,2e14.6,f10.5,a101)")
     Head_rec_3=string('','',-1,-1,'',format="(2(1X,a32),2i6,a100)")
     Head_rec_4=string('','',-1,-1,'',format="(2(1X,a32),2i6,a100)")
     Head_rec_5=string(0,0,0,0,0,0,0,'','',-1,1,'',$
                       format="(1X,2f10.4,f9.6,4e14.6,2(2x,a8),2i3,a66)")
     Head_rec_6=string('(1X,3F14.8,1P,E14.6,0P,F14.8,2(0P,F11.8,1P,E14.6),1P,4E14.6)','',format="(1X,a60,a117)")
     Head_rec_7=string('   MJD (1950)      Longitude      Latitude     Altitude     Pitch Angle  B (prot.)   L (protons)  B (elec.)   L (elec.)    Proton Flux1  Proton Flux2  Elec. Flux 1  Elec. Flux 2','',format="(a177,a1)")
     
     ;write with fixed record length of 178 bytes
     openw,unit,outfile,/get_lun
       writeu,unit,byte(Head_rec_1)
       writeu,unit,byte(Head_rec_2)
       writeu,unit,byte(Head_rec_3)
       writeu,unit,byte(Head_rec_4)
       writeu,unit,byte(Head_rec_5)
       writeu,unit,byte(Head_rec_6)
       writeu,unit,byte(Head_rec_7)
     
       for ii=0,n_elements(polar_ephem)-1 do begin
         ;DATA RECORDS 
         jd=double(julday(mon,day,yr)) + $
             double(polar_ephem(ii).TIME/86400.0)
         mjd=jd-double(2400001)
         XGSE=polar_ephem(ii).GSE_XYZ(0)
         YGSE=polar_ephem(ii).GSE_XYZ(1)
         ZGSE=polar_ephem(ii).GSE_XYZ(2)
         T89GSE2GEO,XGSE,YGSE,ZGSE, $
           doy,yr,polar_ephem(ii).TIME,$
           xr,lon,lat
         alt=xr-3671.0
         PA=90.0
         dummy=fltarr(8) & dummy(*)=-1.0
         Data_rec=string(mjd,lon,lat,alt,PA,dummy,'', $
               format="(1X,F14.8,2F14.8,E14.6,F14.8,2(F11.8,E14.6),4E14.6,a1)")
         writeu,unit,byte(Data_rec)
       endfor  
       ;END OF FILE LINE
       dy=fltarr(13) & dy(*)=-1.0
       End_rec=string(dy,'', $
              format="(1X,F14.8,2F14.8,E14.6,F14.8,2(F11.8,E14.6),4E14.6,a1)")
       writeu,unit,byte(End_rec)
     close,unit & free_lun,unit
     
   endfor

end

; idl wrapper to call external fortran routine T89GSE2GEO

pro T89GSE2GEO, XGSE,YGSE,ZGSE,IDAY,IYEAR,XTIME,XR,XLON,XLAT
  
  lib_name = '/n/toaster/u/friedel/idl/fortran/t89intoidl.so'
  entry_name = 't89gse2geo_'
  
; Call the function in the sharable object file:
  
  result=0
  xr=0.0 & xlon=0.0 & xlat=0.0
  result=call_external(lib_name, $              ;The sharable object file
                       entry_name, $            ;The entry point
                       float(XGSE),float(YGSE),float(ZGSE), $
                       long(IDAY),long(IYEAR),float(XTIME), $
                       XR,XLON,XLAT, $          ;Return parameters
                       /f_value)       	        ;The function returns a float.
  
end


; idl batch file to run all POLAR .int files through UNIRAD's BLXTRA

pro do_polar_blxtra
  
;setup search path for data
   data_dir=getenv('POLAREPHMPATH')
   if strlen(data_dir) eq 0 then begin
      get_err_no=1
      get_err_msg='Environmental variable (POLAREPHMPATH) not set'
      print,get_err_msg
      return
   endif else begin
      get_err_no=0
      get_err_msg=''     
   endelse

   IF strmid(data_dir,strlen(data_dir)-1,1) NE '/' THEN data_dir=data_dir+'/'
   cif_data_dir=data_dir+'unirad_cif/'
   bla_data_dir=data_dir+'unirad_bla/'
   
   files=findfile(cif_data_dir+'*.int')  
   
   polar_namelist='~/UNIRAD/PO_EPH_XXXXXXXX.nml'

   cd,'~/UNIRAD'
   
   for i=0,n_elements(files)-1 do begin
     pos=strpos(files(i),'PO_EPH_')
     file_id=strmid(files(i),pos,15)
     check=findfile(bla_data_dir+file_id+'.bla',count=chn)
     if chn ne 1 then begin
       print,i,n_elements(files),' Doing ',file_id
       spawn,'cp '+polar_namelist+' '+file_id+'.nml'
       spawn,'cp '+files(i)+' .'
       spawn,'blxtra '+file_id+' > '+file_id+'.jrl'
       spawn,'cp '+file_id+'.bla '+ bla_data_dir
       spawn,'rm '+file_id+'*' 
     endif  
   endfor  
   print,files

end  
