;------------------------------------------------------------------------------
; These functions unse the papco mjdt time format to label axis with 
; polar_eph ticks for the POLAR spacecraft.
; Usually, time axis use seconds since the start of the plot (requested begin
; time). The POAR polar_eph time is in the same format: We search for
; the closest time to the requested ticktime in the polar_eph time array:
; That index is then used to return the polar_eph information.
; 
; The shift_label common block hands over from the plot routine the requested
; line number for the ticke below the bottom plot..
;
; polar_L_ticks returns the L-value
; polar_mlt_ticks returns Magnetic local time
; polar_ilat_ticks returns magnetic latitude
;
;
; The common block shift_label controlls how many lines down from the nornmal
; label line to go.
;
; Written  Feb 97, R. Friedel
;------------------------------------------------------------------------------

function polar_L_ticks, axis, index, t

   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   common polar_eph, polar_eph

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'

   difft=abs(polar_eph.time-t)
   result=min(difft,minindex)

   L=polar_eph(minindex).L_SHELL
   return,down_str+string(L,format="(f5.1)")

end

function polar_mlt_ticks, axis, index, t

   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   common polar_eph, polar_eph

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'

   difft=abs(polar_eph.time-t)
   result=min(difft,minindex)

   mlt=polar_eph(minindex).EDMLT_TIME

   return,down_str+string(mlt,format="(f5.1)")

end

function polar_ilat_ticks, axis, index, t

   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   common polar_eph, polar_eph

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'

   difft=abs(polar_eph.time-t)
   result=min(difft,minindex)

   ilat=polar_eph(minindex).MAG_LATITUDE

   return,down_str+string(ilat,format="(f5.1)")

end
