pro test_eph,xrot,zrot,um,up

   common polar_ephem, polar_ephem

; set up volume for sphere of earth
   sphere=fltarr(11,11,11)
   
   for i=0,10 do for j=0,10 do for k=0,10 do $
      sphere(i,j,k) = sqrt((i-5)^2+(j-5)^2+(k-5)^2) / 5

   shade_volume,sphere,1.,v,p,/low
   s=size(v)
   for i=0,s(1)-1 do for j=0,s(2)-1 do v(i,j) = v(i,j) / 5  -1

; set up scalings in case output is required
  if !d.name eq 'X' then begin
     xc=1.25 &   f1=3. &  f2=1. &  xs=1. &  tc=1. &  th=1. &  fth=2.
     tl=.01 &     oth=2. &  fth=1. &   mf=1. &  xsi=500 &  ysi=500 
     window,title='3-D ORBIT PLOT',XSIZE=xsi,YSIZE=ysi
  endif else begin
     xc=0.03 &  f1=2.5 &  f2=1.5 &  xs=0.06 &  tc=.1 &  th=.1 &  oth=.4
     fth=.2 &  tl=.01 &  xsi=500 &  ysi=500
     mf=1.
     set_plot,'ps',/interpolate
     device,xs=.87,ys=.87,scale=20,xoffset=0.5,yoffset=25,fil='orbit2.ps', $
            /color, bits=8,/landscape
     !p.noerase=1
   endelse
 
   !p.region=[0.,0.,1.,1.]
   !p.position=[0.0,0.0,1.,1.]

   x=findgen(10) & plot,x,/nodata,xst=4,yst=4

   !p.t3d=1                           ; initialise transformation matrix
   rfscale3,xr=[-10,10],yr=[-10,10],zr=[-10,10], $
            ax=xrot,az=zrot,usermag=um,userpos=up

; draw sphere for earth
   tvscl,polyshade(v,p,/t3d,xsize=xsi,ysize=xsi)

; set up own axis system
   axis,0,0,0,xax=1,/data,charsize=xc,charthick=tc,xthick=th,xr=[-11.,11.], $
        /save, /t3d, $
        xtitle='X (GSM)                                                     ', $
        xtickformat='nozero', xstyle=1, xmargin=[0,0], ticklen=tl, color=1
   axis,0,0,0,yax=0,/data,charsize=xc,charthick=tc,ythick=th,yr=[-11.,11.], $
        /save, /t3d, $
        ytitle='                                                     Y (GSM)', $
        ytickformat='nozero', ystyle=1, ymargin=[0,0], ticklen=tl, color=1
   axis,0,0,0,zax=1,/data,charsize=xc,charthick=tc,zthick=th,zr=[-11.,11.], $
        /save, /t3d, $
        ztitle='                                                     Z (GSM)', $
        ztickformat='nozero', zstyle=1, zmargin=[0,0], ticklen=tl, color=1
   
; plot orbit!   
   gsm=polar_ephem.GSM_POS/6372.0
   plots,gsm(0,0),gsm(1,0),gsm(2,0), /data, /t3d
   for i=1,n_elements(gsm)/3-1 do plots,gsm(0,i),gsm(1,i),gsm(2,i), $
                                 /data, /continue, /t3d, thick=oth, color=100
; plot projections of orbit onto coordinate planes
   plots,gsm(0,0),gsm(1,0),0, /data, /t3d
   for i=1,n_elements(gsm)/3-1 do plots,gsm(0,i),gsm(1,i),0, linestyle=1, $
                                 /data, /continue, /t3d, thick=1, color=50
   plots,gsm(0,0),0,gsm(2,0), /data, /t3d
   for i=1,n_elements(gsm)/3-1 do plots,gsm(0,i),0,gsm(2,i),  linestyle=1, $
                                 /data, /continue, /t3d, thick=oth, color=50
   plots,0,gsm(1,0),gsm(2,0), /data, /t3d
   for i=1,n_elements(gsm)/3-1 do plots,0,gsm(1,i),gsm(2,i),  linestyle=1, $
                                 /data, /continue, /t3d, thick=oth, color=50


; turn off 3-D projections again.
   !p.t3d=0

end
