;------------------------------------------------------------------------------
;* Sets up some common blocks for the polar ephemeris module.
;* Needs to be compiled and called befroe module is used, done in init_module
PRO polar_eph_commons

COMMON polar_ephemeris, orig_names, polar_eph_control

;str arr containing coord labels, units, unit format string.
orig_names = [$
  ['L','MLT','ILAT','R','xGSM','yGSM','zGSM', 'xGSE' , 'yGSE', 'zGSE'], $
  ['L', 'hr', 'deg', 'Re', 'Re', 'Re', 'Re', 'Re', 'Re', 'Re'], $
  ['f6.1', 'f5.1', 'f6.2', 'f6.2', 'f6.2','f6.2','f6.2','f6.2','f6.2','f6.2']]

;finally, set up a structure for all the variables needed by the
;lanl geo wph  module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains mre
;descriptive and verbose tags for easier use.

polar_eph_control = {$
  product:0,    product_info:'Index into orig_names, choice of original '+$
                             'ephemeris coord', $
  orig:0,       orig_info:'original (0) or model (1) coords'}

;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to polar_eph_control

polar_eph_control = CREATE_STRUCT(name = 'polar_eph_contr', $
                       polar_eph_control, $
                       papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))


END
