;***************************************************************************
;* file pwi_sfr_mca_slice.pro
;*
;* this file contains the routines needed to enable the extra mouse features
;* provided for in PAPCO. Mouse zooms is part of main papco. Currently possible:
;*
;*    mouse views slice
;*    mouse views slice (polar)
;*    mouse accesses level zero
;* 
;* Here the procedure names must again adhere to a strict naming convention so 
;* that they can be automatically called when needed.
;*
;* The slice types supported by these routines must be ENABLED by the user, so 
;* that PAPCO can call them. This is done by setting the value of 
;* slice_type in draw_plot_type.pro (contained in papcoadd_plot_type.pro).
;* slice_type is defined in the following way:
;*
;*      slice_type      Selects which slices are supported and for which
;*                      slice routines have been written.
;*                      This is a byte logical with 8 swittches. Currently
;*                      Three are supported (this may be extended later)
;*                       1 = mouse zooms (default, always possible)
;*                       2 = mouse slices
;*                       4 = mouse calls level zero
;*                       8, 16, 32, 64, 128 = not supported yet
;*                      you can support more than one type of slice
;*                      by arithmetically adding the options, eg
;*                      slice_type=5  support zoom and level zero
;*
;* The "mouse views slice" function uses the time returned by PAPCO and the
;* get_data_call specified for the plot_type to read the data and to draw a 
;* slice at the clicked position. This is commonly used in spectra color plots 
;* to draw a spectrum at that time, or a pitch angle distribution etc, or to
;* call up any other plot at that time as specified by the user.
;*
;* The "mouse accesses levelzero" uses the time passed and calls up another
;* widget application to read and work with level zero data. This application
;* must be intirely independant of PAPCO and is only called from PAPCO via
;* a mouse click in the panel required for the time required.
;*
;* If your new data contains several sub-data types, one slice and/or levelzero
;* routine has to be provided for each type, since in general they would do
;* different things. See $PAPCO_MODULES\panel&slices\crres_slices.pro for 
;* such an example.
;*
;*      PRO DrawSlice_plot_type, panelNr, seconds, yValue
;*        -> Draw a slice for plot_type
;*
;*      PRO levelzero_plot_type, seconds, yvalue
;*        -> This procedure calls the widget for levelzero data access 
;*           for this plottype.
;*    
;* MODIFICATION HISTORY:       
;*      December 1995, written by R.Friedel at Goddard
;*      april 1996, R. Friedel
;***************************************************************************

;***************************************************************************
;* PROCEDURE:     
;*      PRO levelzero_plot_type, seconds, yvalue
;*                                     
;* DESCRIPTION:  
;*      This procedure calls the widget for level zero data acces 
;*      for this plottype. 
;*      slice_type in draw_plot_type must be set to +4 to enable this feature.
;*
;* INPUTS:       
;*      seconds           T90 time at which mouse is clicked
;*      yvalue            y-value at which mouse is clicked
;*
;* OUTPUTS: 
;*      none
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      levelzero_plot_type, seconds, yvalue
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel at Goddard
;*     april 1996, R. Friedel
;***************************************************************************
pro levelzero_plot_type, seconds, yvalue

; The actual procedure is very dependent on what the level zero widget 
; application needs. An example is in $PAPCO_MODULES/addpapco_swe_plots.pro.
; Provided as paramters to be passed to the new application, are the values
; of the mouse pointer when clicked. 
;
; The main widget remains active and can be swittched to (e.g. to get a new
; time from the graph) by using a "Parent" button in the new application
; which then executes the line
;            current_appl=xregistered('PAPCO_main') 
; to swittch back to the PAPCO main calling widget. 

; call the levelzero widget.  
;   plot_type_levelzero, seconds, yvalue

; the following line is printed on your xterm as a check to see if PAPCO
; correctly called this routine. If there is a problem make sure your naming 
; convention is O.K. : This routine MUST be called levelzero_plot_type, 
; where plot_type is the name of the panel you have set in papcoadd_plot_type.

    print, 'got to the levelzero interface  ',seconds, yvalue

END

;***************************************************************************
;* PROCEDURE:     
;*      PRO DrawSlice_mcab_spec, panelNr, seconds, yValue
;* 
;* DESCRIPTION:  
;*      Draw a slice for plot_type
;*      calling a seperate window for the plot.
;*      slice_type in draw_plot_type must be set to +2 to enable this feature.
;*
;* INPUTS:       
;*      panelNr     an integer, the number of the panel for which the slice 
;*                  is to be drawn
;*      seconds     time of mouse click, a float
;*      yvalue      y-value of mouse click, a float
;*      
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      called by PAPCO_DrawSLice (in $PAPCO_PATH/papco_cursor.pro)
;*
;* MODIFICATION HISTORY:       
;*      december 1995, written by R.Friedel at Goddard
;*      april 1996, R. Friedel
;***************************************************************************

PRO DrawSlice_pwi_mcab_spec, panelNr, seconds, yValue

   COMMON PAPCO_DRAWSLICE, sliceWidgetData
   COMMON PLOT_COMPOSER, widgetData

   COMMON MCABspctrmstuff, MCABspctrm
   COMMON time, xut1, xut2

   P = PanelNr

   WIDGET_CONTROL,/HOURGLASS

; use the same typevector, swittch etc as is used in the call to your plot
; routine. thisPlot contains the full PAPCO structure of plot information for
; the panel in which the mouse was clicked in. 

   thisPlot=widgetData.plotsDrawn(panelNr)
   type=thisPlot.typeVector

; set the panel window for the slice to full window

   !p.position=[0.15,0.1,0.9,0.9]
 
    t90 = MCABspctrm.time(*).t90

    zmat = MCABspctrm.spec

    N = MCABspctrm.nf

    xstart = widgetData.plotsDrawn (panelNr).yscl_min
    xend = widgetData.plotsDrawn (panelNr).yscl_max

    f0 = 0	&	done = 0
    while (NOT done) do begin
	if (MCABspctrm.frequency(f0) GT xstart) then begin
	    f0 = f0 + 1
	    if (f0 GE N) then begin
		f0 = 0	& done = 1
	    endif
	endif else	done = 1
    endwhile

    f1 = f0	&	done = 0
    while (NOT done) do begin
	if (MCABspctrm.frequency(f1) LT xend) then begin
	    f1 = f1 + 1
	    if (f1 GE N) then begin
		f1 = N - 1	& done = 1
	    endif
	endif else	done = 1
    endwhile

;    N0 = f1 - f0 + 1
;    xarr = fltarr(N0)

    xarr = MCABspctrm.frequency(f0:f1) 
    xtit = MCABspctrm.ytitle	&	ytit = MCABspctrm.ztitle
    info1 = MCABspctrm.title

; select the index for the time chosen out of the time array

    DiffTimes = ABS(t90 - xut1 - seconds) ; this sets timeIndex to the index with
    result = MIN(DiffTimes, timeIndex)	; t90(timeIndex) is closest to 'seconds'
; timeIndex = index of the min value, result = the value(in T90)

    ystart = widgetData.plotsDrawn (panelNr).zscl_min	; *0.9	; bottom y
    yend = widgetData.plotsDrawn (panelNr).zscl_max	; *1.1	; top y

    y_range = [ ystart, yend ]
    x_range = [ xstart, xend ]

    no_labels = replicate (' ', 30)

    yarr = zmat(timeIndex, f0:f1)

    erase

    plot, /ylog, xarr, yarr, xrange = x_range, yrange = y_range, $
		yticklen = -0.015, xtitle = xtit, ytitle = ytit, $
		xstyle = 1, ystyle = 1, color = 1

;    axis, xaxis = 0, /xtype, xrange = x_range, xticklen = -0.015, $
;		xtitle = xtit, xstyle = 1, color = 1

;    axis, xaxis = 1, /xtype, xrange = x_range, xticklen = -0.015, $
;		xstyle = 1, color = 1, xtickname = no_labels

    convert_t90_to_Date, xut1 + seconds, year, doy, hour, min, sec, $
		month, cmonth, day

; these two info strings are user-definable output strings to label the slice 
; window.

    info2 = string (year, month, day, doy, format = $
			"('Date: ', i4.4, '-', i2.2, '-', i2.2, '(', i3.3, ')')")
    info2 = info2 + string(hour, min, sec, format = $
			"('   Time: ', i2.2, ':', i2.2, ':', i2.2)")

; Replace these labels and include your plot! 

; user defined routine for plotting the slice included here. An example is in 
; $PAPCO_MODULES/panels&slices/crres_slices.pro
; You typically need to include the commons from the read routine, a way
; of finding the index of the data you want to plot using the time "seconds"
; (in t90 format of course), plus a simple plot statement to plot the data.
; Two strings, info1 and info2, can be used to annotate the slice window
; by providing additional information, ie ephemeris data, etc.

; these calls put your info strings in the provided labels of the slice widget

   WIDGET_CONTROL, sliceWidgetData.lbl_slice1, SET_VALUE=info1
   WIDGET_CONTROL, sliceWidgetData.lbl_slice2, SET_VALUE=info2

END

;***************************************************************************
;* PROCEDURE:     
;*      PRO DrawSlice_mcae_spec, panelNr, seconds, yValue
;* 
;* DESCRIPTION:  
;*      Draw a slice for plot_type
;*      calling a seperate window for the plot.
;*      slice_type in draw_plot_type must be set to +2 to enable this feature.
;*
;* INPUTS:       
;*      panelNr     an integer, the number of the panel for which the slice 
;*                  is to be drawn
;*      seconds     time of mouse click, a float
;*      yvalue      y-value of mouse click, a float
;*      
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      called by PAPCO_DrawSLice (in $PAPCO_PATH/papco_cursor.pro)
;*
;* MODIFICATION HISTORY:       
;*      december 1995, written by R.Friedel at Goddard
;*      april 1996, R. Friedel
;***************************************************************************

PRO DrawSlice_pwi_mcae_spec, panelNr, seconds, yValue

   COMMON PAPCO_DRAWSLICE, sliceWidgetData
   COMMON PLOT_COMPOSER, widgetData

   COMMON MCAEspctrmstuff, MCAEspctrm
   COMMON time, xut1, xut2

   P = PanelNr

   WIDGET_CONTROL,/HOURGLASS

; use the same typevector, swittch etc as is used in the call to your plot
; routine. thisPlot contains the full PAPCO structure of plot information for
; the panel in which the mouse was clicked in. 

   thisPlot=widgetData.plotsDrawn(panelNr)
   type=thisPlot.typeVector

; set the panel window for the slice to full window

   !p.position=[0.15,0.1,0.9,0.9]

    t90 = MCAEspctrm.time(*).t90
    index = where (t90 GE xut1 AND t90 LE xut2, kount)

    if (kount EQ 0) then begin
	print, 'kount = 0'
    endif

    zmat = MCAEspctrm.spec

    N = MCAEspctrm.nf

    xstart = widgetData.plotsDrawn (panelNr).yscl_min
    xend = widgetData.plotsDrawn (panelNr).yscl_max

    f0 = 0	&	done = 0
    while (NOT done) do begin
	if (MCAEspctrm.frequency(f0) GT xstart) then begin
	    f0 = f0 + 1
	    if (f0 GE N) then begin
		f0 = 0	& done = 1
	    endif
	endif else	done = 1
    endwhile

    f1 = f0	&	done = 0
    while (NOT done) do begin
	if (MCAEspctrm.frequency(f1) LT xend) then begin
	    f1 = f1 + 1
	    if (f1 GE N) then begin
		f1 = N - 1	& done = 1
	    endif
	endif else	done = 1
    endwhile

    xarr = MCAEspctrm.frequency(f0:f1)
    xtit = MCAEspctrm.ytitle	&	ytit = MCAEspctrm.ztitle
    info1 = MCAEspctrm.title

; select the index for the time chosen out of the time array

    DiffTimes = ABS(t90 - xut1 - seconds) ; this sets timeIndex to the index with
    result = MIN(DiffTimes, timeIndex)    ; t90(index) is closest to 'seconds'
; timeIndex = index of the min value, result = the value(in T90)

    ystart = widgetData.plotsDrawn (panelNr).zscl_min	; *0.9	; bottom y
    yend = widgetData.plotsDrawn (panelNr).zscl_max	; *1.1	; top y

    y_range = [ ystart, yend ]
    x_range = [ xstart, xend ]

    no_labels = replicate (' ', 30)

    yarr = zmat(timeIndex, f0:f1)

    erase

    plot, /ylog, xarr, yarr, xrange = x_range, yrange = y_range, $
		yticklen = -0.015, xtitle = xtit, ytitle = ytit, $
		xstyle = 1, ystyle = 1, color = 1

;    axis, xaxis = 0, /xtype, xrange = x_range, xticklen = -0.015, $
;		xtitle = xtit, xstyle = 1, color = 1

;    axis, xaxis = 1, /xtype, xrange = x_range, xticklen = -0.015, $
;		xstyle = 1, color = 1, xtickname = no_labels

    convert_t90_to_Date, xut1 + seconds, year, doy, hour, min, sec, $
		month, cmonth, day

; these two info strings are user-definable output strings to label the slice 
; window.

    info2 = string (year, month, day, doy, format = $
			"('Date: ', i4.4, '-', i2.2, '-', i2.2, '(', i3.3, ')')")
    info2 = info2 + string(hour, min, sec, format = $
			"('   Time: ', i2.2, ':', i2.2, ':', i2.2)")

; Replace these labels and include your plot! 

; user defined routine for plotting the slice included here. An example is in 
; $PAPCO_MODULES/panels&slices/crres_slices.pro
; You typically need to include the commons from the read routine, a way
; of finding the index of the data you want to plot using the time "seconds"
; (in t90 format of course), plus a simple plot statement to plot the data.
; Two strings, info1 and info2, can be used to annotate the slice window
; by providing additional information, ie ephemeris data, etc.

; these calls put your info strings in the provided labels of the slice widget

   WIDGET_CONTROL, sliceWidgetData.lbl_slice1, SET_VALUE=info1
   WIDGET_CONTROL, sliceWidgetData.lbl_slice2, SET_VALUE=info2

END

;***************************************************************************
;* PROCEDURE:     
;*      PRO DrawSlice_sfra_spec, panelNr, seconds, yValue
;* 
;* DESCRIPTION:  
;*      Draw a slice for plot_type
;*      calling a seperate window for the plot.
;*      slice_type in draw_plot_type must be set to +2 to enable this feature.
;*
;* INPUTS:       
;*      panelNr     an integer, the number of the panel for which the slice 
;*                  is to be drawn
;*      seconds     time of mouse click, a float
;*      yvalue      y-value of mouse click, a float
;*      
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      called by PAPCO_DrawSLice (in $PAPCO_PATH/papco_cursor.pro)
;*
;* MODIFICATION HISTORY:       
;*      december 1995, written by R.Friedel at Goddard
;*      april 1996, R. Friedel
;***************************************************************************

PRO DrawSlice_pwi_sfra_spec, panelNr, seconds, yValue

   COMMON PAPCO_DRAWSLICE, sliceWidgetData
   COMMON PLOT_COMPOSER, widgetData

   COMMON SFRAspctrmstuff, SFRAspctrm
   COMMON time, xut1, xut2

   P = PanelNr

   WIDGET_CONTROL,/HOURGLASS

; use the same typevector, swittch etc as is used in the call to your plot
; routine. thisPlot contains the full PAPCO structure of plot information for
; the panel in which the mouse was clicked in. 

   thisPlot=widgetData.plotsDrawn(panelNr)
   type=thisPlot.typeVector

; set the panel window for the slice to full window

   !p.position=[0.15,0.1,0.9,0.9]

    t90 = SFRAspctrm.time(*).t90

    zmat = SFRAspctrm.spec

    N = SFRAspctrm.nf

    xstart = widgetData.plotsDrawn (panelNr).yscl_min
    xend = widgetData.plotsDrawn (panelNr).yscl_max

    xtit = SFRAspctrm.ytitle	&	ytit = SFRAspctrm.ztitle
    info1 = SFRAspctrm.title

; select the index for the time chosen out of the time array

    DiffTimes = ABS(t90 - xut1 - seconds) ; this sets timeIndex to the index with
    result = MIN(DiffTimes, timeIndex)    ; t90(index) is closest to 'seconds'
; timeIndex = index of the min value, result = the value(in T90)

    ystart = widgetData.plotsDrawn (panelNr).zscl_min	; *0.9	; bottom y
    yend = widgetData.plotsDrawn (panelNr).zscl_max	; *1.1	; top y

    y_range = [ ystart, yend ]
    x_range = [ xstart, xend ]

    no_labels = replicate (' ', 30)

    f0 = 0	&	done = 0
    while (NOT done) do begin
	if (SFRAspctrm.frequency(f0) GT xstart) then begin
	    f0 = f0 + 1
	    if (f0 GE N) then begin
		f0 = 0	& done = 1
	    endif
	endif else	done = 1
    endwhile

    f1 = f0	&	done = 0
    while (NOT done) do begin
	if (SFRAspctrm.frequency(f1) LT xend) then begin
	    f1 = f1 + 1
	    if (f1 GE N) then begin
		f1 = N - 1	& done = 1
	    endif
	endif else	done = 1
    endwhile

    xarr = SFRAspctrm.frequency(f0:f1)
    yarr = zmat(timeIndex, f0:f1)

    erase

    plot, /ylog, xarr, yarr, xrange = x_range, yrange = y_range, $
		yticklen = -0.015, xtitle = xtit, ytitle = ytit, $
		xstyle = 1, ystyle = 1, color = 1

;    axis, xaxis = 0, /xtype, xrange = x_range, xticklen = -0.015, $
;		xtitle = xtit, xstyle = 1, color = 1

;    axis, xaxis = 1, /xtype, xrange = x_range, xticklen = -0.015, $
;		xstyle = 1, color = 1, xtickname = no_labels

    convert_t90_to_Date, xut1 + seconds, year, doy, hour, min, sec, $
		month, cmonth, day

; these two info strings are user-definable output strings to label the slice 
; window.

    info2 = string (year, month, day, doy, format = $
			"('Date: ', i4.4, '-', i2.2, '-', i2.2, '(', i3.3, ')')")
    info2 = info2 + string(hour, min, sec, format = $
			"('   Time: ', i2.2, ':', i2.2, ':', i2.2)")

; Replace these labels and include your plot! 

; user defined routine for plotting the slice included here. An example is in 
; $PAPCO_MODULES/panels&slices/crres_slices.pro
; You typically need to include the commons from the read routine, a way
; of finding the index of the data you want to plot using the time "seconds"
; (in t90 format of course), plus a simple plot statement to plot the data.
; Two strings, info1 and info2, can be used to annotate the slice window
; by providing additional information, ie ephemeris data, etc.

; these calls put your info strings in the provided labels of the slice widget

   WIDGET_CONTROL, sliceWidgetData.lbl_slice1, SET_VALUE=info1
   WIDGET_CONTROL, sliceWidgetData.lbl_slice2, SET_VALUE=info2

END

;***************************************************************************
;* PROCEDURE:     
;*      PRO DrawSlice_sfrb_spec, panelNr, seconds, yValue
;* 
;* DESCRIPTION:  
;*      Draw a slice for plot_type
;*      calling a seperate window for the plot.
;*      slice_type in draw_plot_type must be set to +2 to enable this feature.
;*
;* INPUTS:       
;*      panelNr     an integer, the number of the panel for which the slice 
;*                  is to be drawn
;*      seconds     time of mouse click, a float
;*      yvalue      y-value of mouse click, a float
;*      
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      called by PAPCO_DrawSLice (in $PAPCO_PATH/papco_cursor.pro)
;*
;* MODIFICATION HISTORY:       
;*      december 1995, written by R.Friedel at Goddard
;*      april 1996, R. Friedel
;***************************************************************************

PRO DrawSlice_pwi_sfrb_spec, panelNr, seconds, yValue

   COMMON PAPCO_DRAWSLICE, sliceWidgetData
   COMMON PLOT_COMPOSER, widgetData

   COMMON SFRBspctrmstuff, SFRBspctrm
   COMMON time, xut1, xut2

   P = PanelNr

   WIDGET_CONTROL,/HOURGLASS

; use the same typevector, swittch etc as is used in the call to your plot
; routine. thisPlot contains the full PAPCO structure of plot information for
; the panel in which the mouse was clicked in. 

   thisPlot=widgetData.plotsDrawn(panelNr)
   type=thisPlot.typeVector

; set the panel window for the slice to full window

   !p.position=[0.15,0.1,0.9,0.9]

    t90 = SFRBspctrm.time(*).t90

    zmat = SFRBspctrm.spec

    N = SFRBspctrm.nf

    xstart = widgetData.plotsDrawn (panelNr).yscl_min
    xend = widgetData.plotsDrawn (panelNr).yscl_max

    xtit = SFRBspctrm.ytitle	&	ytit = SFRBspctrm.ztitle
    info1 = SFRBspctrm.title

; select the index for the time chosen out of the time array

    DiffTimes = ABS(t90 - xut1 - seconds) ; this sets timeIndex to the index with
    result = MIN(DiffTimes, timeIndex)    ; t90(index) is closest to 'seconds'
; timeIndex = index of the min value, result = the value(in T90)

    ystart = widgetData.plotsDrawn (panelNr).zscl_min	; *0.9	; bottom y
    yend = widgetData.plotsDrawn (panelNr).zscl_max	; *1.1	; top y

    y_range = [ ystart, yend ]
    x_range = [ xstart, xend ]

    no_labels = replicate (' ', 30)

    f0 = 0	&	done = 0
    while (NOT done) do begin
	if (SFRBspctrm.frequency(f0) GT xstart) then begin
	    f0 = f0 + 1
	    if (f0 GE N) then begin
		f0 = 0	& done = 1
	    endif
	endif else	done = 1
    endwhile

    f1 = f0	&	done = 0
    while (NOT done) do begin
	if (SFRBspctrm.frequency(f1) LT xend) then begin
	    f1 = f1 + 1
	    if (f1 GE N) then begin
		f1 = N - 1	& done = 1
	    endif
	endif else	done = 1
    endwhile

    xarr = SFRBspctrm.frequency(f0:f1)
    yarr = zmat(timeIndex, f0:f1)

    erase

    plot, /ylog, xarr, yarr, xrange = x_range, yrange = y_range, $
		ticklen = -0.015, xtitle = xtit, ytitle = ytit, $
		xstyle = 1, ystyle = 1, color = 1

;    axis, xaxis = 0, /xtype, xrange = x_range, xticklen = -0.015, $
;		xtitle = xtit, xstyle = 1, color = 1

;    axis, xaxis = 1, /xtype, xrange = x_range, xticklen = -0.015, $
;		xstyle = 1, color = 1, xtickname = no_labels

    convert_t90_to_Date, xut1 + seconds, year, doy, hour, min, sec, $
		month, cmonth, day

; these two info strings are user-definable output strings to label the slice 
; window.

    info2 = string (year, month, day, doy, format = $
			"('Date: ', i4.4, '-', i2.2, '-', i2.2, '(', i3.3, ')')")
    info2 = info2 + string(hour, min, sec, format = $
			"('   Time: ', i2.2, ':', i2.2, ':', i2.2)")

; Replace these labels and include your plot! 

; user defined routine for plotting the slice included here. An example is in 
; $PAPCO_MODULES/panels&slices/crres_slices.pro
; You typically need to include the commons from the read routine, a way
; of finding the index of the data you want to plot using the time "seconds"
; (in t90 format of course), plus a simple plot statement to plot the data.
; Two strings, info1 and info2, can be used to annotate the slice window
; by providing additional information, ie ephemeris data, etc.

; these calls put your info strings in the provided labels of the slice widget

   WIDGET_CONTROL, sliceWidgetData.lbl_slice1, SET_VALUE=info1
   WIDGET_CONTROL, sliceWidgetData.lbl_slice2, SET_VALUE=info2

END

PRO DrawSlice_pwi_sfr_mca, panelNr, seconds, yValue

   COMMON PAPCO_DRAWSLICE, sliceWidgetData
;   COMMON pwi_sfr_mca_panel_data, widgetData
   COMMON PLOT_COMPOSER, widgetData

   COMMON MCAEspctrmstuff, MCAEspctrm
   COMMON MCABspctrmstuff, MCABspctrm
   COMMON SFRAspctrmstuff, SFRAspctrm
   COMMON SFRBspctrmstuff, SFRBspctrm
   COMMON time, xut1, xut2

   thisPlot=widgetData.plotsDrawn(panelNr)
   type=thisPlot.typeVector

   CASE type(1) of
	0: DrawSlice_pwi_mcae_spec, panelNr, seconds, yValue
	1: DrawSlice_pwi_mcab_spec, panelNr, seconds, yValue
	2: DrawSlice_pwi_sfra_spec, panelNr, seconds, yValue
	3: DrawSlice_pwi_sfrb_spec, panelNr, seconds, yValue
   endcase

END
