 
;****************************************************************************
;*  NAME:        pwi_timeticks
;*
;*  DESCRIPTION: Routine to put timeticks on plot
;*
;*  INPUT:       x_range (x range in T90), x_tickv (array to contain
;*			tick values)
;*
;*  OUTPUT:      x_tickv (array of actual tick values in seconds)
;*		 num_int (number of intervals), minor (#minor ticks)
;*		 x_range (modified)
;*
;*  DATE:        Spring 1998
;*
;*  AUTHOR:      J. Dowell
;*
;*  CHANGES:
;****************************************************************************

pro pwi_timeticks, x_range, num_int, x_tickv, minor

    xut1 = x_range(0)
    xut2 = x_range(1)
    tdiff = double(xut2 - xut1)
; print, 'x_range', x_range
; print, '% pwi_timeticks:  interval = ', tdiff, ' sec'
    xu1 = x_range(0) mod 86400
    xu2 = xu1 + x_range(1) - x_range(0)
    dsec = xu2 - xu1

    if (dsec GT 1) then begin
;   AMajI = #seconds in each major interval
;                      1 2mn   3   5  15   30  1hr    2     4     6  1day  10days
;	AMajI = [1L,15,30,60,120,180,300,900,1800,3600,7200,14400,43200,86400,345600L]
	AMajI = [1L,10,15,20,30,60,90,120,180,300,900,1800,3600,7200,14400, $
					43200,86400,345600L]
	min_t = [4L, 2, 3, 2, 2, 3,  3, 3,  3,  3,  3,   3,   4,   4,    4, $
					    6,    4,     6L]
;    min_t = [4L, 3, 2, 3,  3,  3,  3,  3,   3,   4,   4,    4,    6,    4,     6L]
;    min_t = [4L, 3, 2, 3,  3,  3,  3,  5,   5,   3,   3,    4,    6,    4,     6L]

	max_sec = 345600L	&	Nticks = dsec/AMajI
; print, 'dsec', dsec
; print, 'Nticks', Nticks

	r = where(Nticks LE 7 AND Nticks GE 3, count)
	if (count GT 0) then begin
; print, 'count (', count, ') NE 0, r =', r
;	    use = r(count - 1)
	    use = r(0)
	endif else begin
	    r = where(Nticks LT 7 AND Nticks GT 1, count)
; print, 'count = 0, (', count, '), r =', r
;	    if (count GT 0) then	use = r(count - 1) $
	    if (count GT 0) then	use = r(0) $
	    else use = 1
	endelse
; print, 'use', use

	MajTick = AMajI(use)	&	minor = min_t(use)

	num_int = dsec/MajTick	&	num_MajT = num_int + 1
; print, '0) MajTick', MajTick, ', num_MajT', num_MajT, ', tickv:'

	TickV0 = MajTick*long(ceil(xu1/float(MajTick)))	; 189302400 @ 0:00 ??
; print, 'TickV0', TickV0

	tickv = lindgen(num_MajT)*MajTick + TickV0

	r = where (tickv GE xu1 AND tickv LE xu2, count)

	if (count GT 1 and count LT num_MajT) then begin
; print, 'count', count, ', num_MajT', num_MajT
	    tickv = tickv(r)	&	num_MajT = n_elements(tickv)
	    num_int = num_MajT - 1
	endif
; print, '1) MajTick', MajTick, ', num_MajT', num_MajT, ', tickv:'

	tickv = tickv - xu1
; print, tickv
	x_tickv(0:num_int) = tickv
; print, 'x_tickv:', x_tickv(0:num_int)
;	print, 'tickv', tickv
;	print, 'MajTick', MajTick
;	print, 'num_MajT', num_MajT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	int_size = tdiff / num_int
;	print, '% pwi_timeticks:  int_size = ', int_size, ' sec'

    endif else begin

	num_int = 1	&	minor = 10
	x_tickv(0) = 0.0	&	x_tickv(1) = 1.0
    endelse

    x_tickv = x_tickv(0:num_int)
    x_range = x_range(*) - xut1

end

function pwi_ticks, axis, index, t_in

    COMMON time, xut1, xut2

    sec_per_day = 86400L
; print, 'axis', axis
; print, 'index', index
; print, 't_in', t_in

    if (!d.name EQ 'Z') then	font = '!5'	else	font = '!3'

    dt = xut2 - xut1

    t = (long(t_in) + xut1) mod sec_per_day

    sec = t mod 60	&	t = t/60
    min = t mod 60	&	hour = t/60

    if (dt GT 300) then $
	rval = string(hour, ':', min, format = '(i2.2, a1, i2.2)') $
    else	rval = string(hour, ':', min, ':', sec, format = $
			'(i2.2, a1, i2.2, a1, i2.2)')

    if (t EQ 0) then	rval = '00:00:00'

; print, 'rval', rval

    return, rval

end
