;***************************************************************************
;* file papcoadd_polar_timas
;*      papcoadd_timas_spec
;* end
;*****
;  Note:  The lines above are read by the following code section from
;         routine  papco  in the main program file,  papco.pro .  Even when
;         a module has a main widget button without a pulldown, there must
;         be one line between the "file" line and the "end" line.  See
;         papcoadd_text.pro  for an example.  Although the "file" line
;         is read, its contents are not actually used for anything.
;
;         To produce the "plot_types" variable (that is stored in COMMON
;         ADDINS), the ";*" and "papcoadd_"
;         portion of the lines is removed.  For example, the above line
;         with "papcoadd_timas_spec" becomes "timas_spec".  The "plot_types"
;         variable is filled with names from all the files of this type, i.e.,
;         of the type  papcoadd_*.pro .  ESC, 11/97. 
;
;;--- enquire modules if they contain submenus with more plot types -------
;
;  plot_types=strarr(1)
;  PRINT,';******************************************************************************'
;  PRINT,';* checking for sub plot_types'
;  IF fn ne 0 then BEGIN
;     FOR i=0,fn-1 DO BEGIN
;       instring=';*********'
;       openr, unit, addinfiles(i), /get_lun
;         readf,unit,instring & PRINT,instring & sepstr=instring
;         readf,unit,instring & PRINT,instring
;         readf,unit,instring & PRINT,instring
;         while instring ne ';* end' do begin
;           plot_types=[plot_types,strplottype2(instring+'.pro')]
;           readf,unit,instring & PRINT,instring
;         endwhile
;     ENDFOR
;     free_lun,unit
;  END
;  plot_types=plot_types(1:n_elements(plot_types)-1)
;  PRINT,sepstr
;  PRINT,';* All Add-in modules read'
;  PRINT,sepstr
;
;*****
;* this files contains all the collected routines which have to be added in
;* for hydra_plots. 
;*
;*    Those procedures are contained:
;*
;*    PRO addplottype_polar_timas,plottypes_base,pb_plottype
;*        ->  adds the button for the new plot type to the main window.
;*
;*    PRO plottable_hydra_plots, plottable
;*        -> Sets a variable to indicate plottable without orbit.
;*
;*    PRO descriptor_hydra_plots, plotInfo, descriptStr
;*        -> Constructs the string used to label plots in the panels window
;*
;*    PRO addpanel_hydra_plots
;*        -> Calls the panel editor for this plottype and adds the plot to the
;*            panel window.
;*
;*    PRO editor_hydra_plots, plotNumber, newPlotData
;*        -> This procedure calls the panel editor when called from 
;*	     PAPCO_EditPlot (papco_paneledit.pro).
;*
;*    PRO  draw_hydra_plots, panelVector, currPlotInfo, get_data_call, IsRead
;*        -> This procedure performs the actual data read call and the plot call
;*           for this plottype
;***************************************************************************

;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO addplottype_hydra_plots,plottypes_base,buttonGeometry,pb_plottype
;* 
;* DESCRIPTION:  
;*	This procedure adds a button for this plottype to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*	papckage, so that they can be automatically called when needed.
;*
;* INPUTS:       
;*	plottypes_base	the widget ID of the parent widget to contain the
;*			plottype buttons.
;*
;* OUTPUTS: 
;*   	pb_plottype	the widget ID of the button created here.
;*      buttonGeometry  size of the button. Only used in simple
;*                      WIDGET_BUTTON to make them the same size as the
;*                      compound CW_PDMENU, pulldown for subtypes.
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	addplottype_hydra_plots,plottypes_base,buttonGeometry,pb_plottype
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*     Adapted from the Hydra version by J. Faden, ESC, 2/98.
;*
;***************************************************************************
pro addplottype_polar_timas,plottypes_base,buttonGeometry,pdm_timas_Plots

; VALUE assigns a label for the button
; The polar_timas portion of UVALUE is used to construct the calls to all
; other procedures in this add-in needed by PAPCO.

; Use this section if multiple plot types are required, ESC, 2/13/98.
;  MenuDesc544 = [ $
;                  { CW_PDMENU_S, 3, strcenter('POLAR-TIM',10) }, $ 
;                  { CW_PDMENU_S, 0, ' plot Spec           ' } $
;                ]
;
;  pdm_polar_timas = CW_PDMENU(plottypes_base, MenuDesc544, $
;      UVALUE='pdm_polar_timas')
      
  pdm_timas_Plots = WIDGET_BUTTON(plottypes_base,  $
                                 VALUE=strcenter('POLAR-TIM',10), $
                                 UVALUE='pdm_polar_timas', $
                                 _extra=buttonGeometry)


END

;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO plottable_hydra_subtype, plottable
;*
;* DESCRIPTION:  
;*	Sets a variable to indicate plottable without orbit. One routine for 
;*      each subtype
;*
;* INPUTS:       
;*	none
;*
;* OUTPUTS: 
;*   	plottable	a boolean 0 if plottable only by hydra orbit
;*                                1 if plottable by time also.
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	plottable_hydra_subtype, plottable
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*     Adapted from the Hydra version by J. Faden, ESC, 11/97.
;*
;***************************************************************************
pro plottable_timas_spec, plottable  
   plottable=1
END


;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO descriptor_hydra_plots, plotInfo, descriptStr
;*
;* DESCRIPTION:  
;*	Constructs the string used to label plots in the panel window
;*
;* INPUTS:       
;*	plotInfo        structure containing all data for this plot.
;*                      (structure type: PAPCO_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*   	descriptStr	a string containing the label
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	descriptor_hydra_plots, plotInfo, descriptStr
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*     Adapted from the Hydra version by J. Faden, ESC, 1/98.
;*
;***************************************************************************
;pro descriptor_hydra_spec, plotInfo, descriptStr
;    case plotInfo.typeVector(0) of
;        0: type='electrons'
;        1: type='ions'
;        else: type='EE'
;    endcase
;    case plotInfo.typeVector(2) of
;        0: pitch=''
;        1: pitch=': aligned'
;        2: pitch=': perp'
;        3: pitch=': opposed'
;        else: pitch='EE'
;    endcase
;    descriptStr=descriptStr+type+pitch
;END
pro descriptor_timas_spec, plotInfo, descriptStr
    case plotInfo.typeVector(0) of
        0: type='H+'
        1: type='O+'
        2: type='He+'
        3: type='He++'
        else: type='EE'
    endcase
    case plotInfo.typeVector(2) of
        0: pitch=''
        1: pitch=': aligned'
        2: pitch=': perp'
        3: pitch=': opposed'
        4: pitch=': omni'
        else: pitch='EE'
    endcase
    case plotInfo.typeVector(1) of
        0: res='H'
        1: res='M'
    endcase
    case plotInfo.typeVector(3) of
        0: qual='H'
        1: qual='A'
    endcase
    resqual= '   Res '+res+', Qual '+qual
    descriptStr=descriptStr+type+pitch+resqual
END



;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO addpanel_hydra_plots
;*
;* DESCRIPTION:  
;*	Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      using an instance of the PAPCO_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled.
;*      panelEditor must be set to the name of the panel editor routine
;*
;* INPUTS:       
;*	event		event value of papco main window. This is
;*                      only used if there are plot sub_types, 
;*                      for example see papcoadd_hydra_plots
;*
;* OUTPUTS: 
;*   	none
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	addpanel_hydra_plots
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*     Adapted from the Hydra version by J. Faden, ESC, 2/98.
;      Changed default to manual z scaling, ESC, 4/98.
;*
;***************************************************************************
pro addpanel_polar_timas,event

   forward_function PAPCO_getPlotInfoStruct

   panelKind=''
;   CASE Event.Value OF 
;       1: BEGIN
;           panelKind='hydra-spec'
;           panelEditor='hydra_spec_panel'
;           defaults=PAPCO_getPlotInfoStruct()
;           defaults.typeVector=[0,0,0,0]
;       END273
;       2: BEGIN
;           panelKind='hydra-skew'
;           panelEditor='hydra_skew_panel'
;           defaults=PAPCO_getPlotInfoStruct()
;           defaults.typeVector=[0,0,0,0]
;       END
;       3: BEGIN
;           panelKind='hydra-kp'
;           panelEditor='hydra_kp_panel'
;           defaults=PAPCO_getPlotInfoStruct()
;           defaults.typeVector=[0,0,0,0]
;       END
;   ENDCASE

;** Structure PAPCO_PLOTINFO, 20 tags, length=84:
;   MANUALYSCALING  INT              0
;   MANUALZSCALING  INT              0
;   YSCALEMIN       FLOAT           1.00000
;   YSCALEMAX       FLOAT           1.00000
;   ZSCALEMIN       FLOAT           1.00000
;   ZSCALEMAX       FLOAT           1.00000
;   YLINLOG         INT              1
;   ZLINLOG         INT              1
;   PANELPOSITION   INT              0
;   PANELHEIGHT     INT              1
;   PANELKIND       STRING    ''
;   CHANNEL         INT              0
;   TYPEVECTOR      INT       Array(4)
;   swittch          LONG      Array(3)
;   OVERPLOT        INT              0
;   PLOTSTYLE       INT              0
;   COLOR           INT              0
;   FILENAME        STRING    ''
;   XUT1            FLOAT           0.00000
;   XUT2            FLOAT           0.00000


; Use the case statement if multiple plot types are required, ESC, 2/13/98.
;   CASE Event.Value OF 
;       1: BEGIN
           panelKind='timas-spec'
           panelEditor='timas_spec_panel'
           defaults=PAPCO_getPlotInfoStruct()
           ; typeVector(1)=1 to make default Resolution be M, not H
           defaults.typeVector=[0,1,0,0]
           ; Set manual z scale with limits
           defaults.manualzscaling=1
           defaults.zscalemin=1000.
           defaults.zscalemax=3.e7
;       END
;   ENDCASE
   PAPCO_add_Plot, panelEditor, panelKind, initialPlotInfo=defaults

END

;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO editor_hydra_plots, plotNumber, newPlotData
;* 
;* DESCRIPTION:  
;*	This procedure calls the panel editor when called from 
;*	PAPCO_EditPlot (papco_paneledit.pro).
;*
;* INPUTS:       
;*	plotNumber	anInteger. 0<=plotNumber<=widgetData.numberOfPlots
;*			the index of the plot in widgetData.plotInfos.
;*		
;* OUTPUTS: 
;*   	newPlotData     the new structure returned by the panel editor
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	editor_hydra_plots, plotNumber, newPlotData
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*     Adapted from the Hydra version by J. Faden, ESC, 11/97.
;*
;***************************************************************************
;PRO editor_hydra_spec, plotNumber, newPlotData
;  COMMON PLOT_COMPOSER, widgetData
;   plotInfo=widgetData.plotInfos(plotNumber)
;   newPlotData=hydra_spec_panel(plotInfo, $
;        ACTION='Update '+plotInfo.panelKind, $
;	GROUP=widgetData.main_base)
;END

PRO editor_timas_spec, plotNumber, newPlotData
  COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=timas_spec_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO draw_hydra_plots, panelVector, currPlotInfo, orbitNo $
;*                          get_data_call, slice_type, IsRead
;* DESCRIPTION:  
;*	This procedure performs the actual data read call and the plot call
;*      for this plottype.
;*      
;*
;* INPUTS:       
;*	panelVector	position of the plot (see papco_conventions.text, 6)
;*	currPlotInfo	structure containing all data for this plot.
;*                      (structure type: PAPCO_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*   	get_data_call	a string containing the data call. Used by other
;*                      routines that need to know how to get the data
;*                      in a panel, e.g. to draw spectra, distribution functions
;*      IsRead		a boolean which is set when the the data is read the
;*                      first time. Useful if a given data read puts data
;*                      into commons which can be plotted in many ways.
;*                      When set, data does not have to be read again.
;*      slice_type      Selects which slices are supported and for which
;*                      slice routines have been written.
;*                      This is a byte logical with 8 swittches. Currently
;*                      Three are supported (this may be extended later)
;*                       1 = mouse zooms (default, always possible)
;*                       2 = mouse slices
;*                       4 = mouse calls level zero
;*                       8, 16, 32, 64, 128 = not supported yet
;*                      you can support more than one type of slice
;*                      by arythmetically adding the options, eg
;*                      slice_type=5  support zoom and level zero
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	draw_hydra_plots, panelVector, currPlotInfo, orbitNo, $
;*                                 get_data_call, slice_type, IsRead
;
;  ROUTINES CALLED:
;       timas_define_structure
;
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*     Adapted from the Hydra version by J. Faden, ESC, 1/98.
;*
;***************************************************************************
;pro draw_hydra_spec, panelVector, currPlotInfo, orbitNo, $
;                                 get_data_call, slice_type, IsRead

pro draw_timas_spec, panelVector, currPlotInfo, orbitNo, $
                                 get_data_call, slice_type, IsRead

   common extra, extra_PlotInfo
   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg
;   common hydra_spec_data, $
;     data_context, $            ; selects current data set
;     spec_type_names, $
;     spec_header, $
;     spec_data, $
;     spec_aligned_data, $
;     spec_perp_data, $
;     spec_opposed_data, $
;     spec_skew_data, $
;     hr_spec_data, $
;     hr_spec_aligned_data, $
;     hr_spec_perp_data, $
;     hr_spec_opposed_data, $
;     hr_spec_skew_data
     
   common timas_l1_data, $
     data_context, $            ; selects current data set
     spec_type_names, $
     spec_header, $
     spec_data

   type= currPlotInfo.typevector(2)
;   tres= currPlotInfo.typevector(1)
   species= currPlotInfo.typevector(0)

   ; Define the header structure
   if n_elements( spec_header ) eq 0 then begin
       timas_define_structure, /spec_header
   endif       

;   case tres of 
;       0: data_context= type 
;       1: data_context= type+5
;       else: begin
;           get_error_msg='draw_timas_spec: internal error'           
;           return
;       end
;   endcase

   ; We are using only one "data_context", ESC, 12/97.
  data_context = 0

; You know, IDL5 supports objects.... 

; decide whether we need to reload or not.  This is a little more 
; sophisticated than most PaPCo modules, but since hydra loading
; is expensive, it's worth the potentially confusing code.
;
; If the current data's  start_time  and  end_time  include the requested
;  range (xut1 and xut2) then don't bother to reload.  Times are T90.
;  If reload_flag=1, then reload regardless of time settings.
   YesLoad= $
     spec_header(data_context).start_time gt xut1    or  $
     spec_header(data_context).end_time lt xut2      or  $
     spec_header(data_context).reload_flag ; set with panel
   
   ;  Data will not be be read automatically by PAPCO if get_data_call
   ;  is set to a null string, J. Faden, 114/97.
   get_data_call="r_timas_spec"
     
   IF YesLoad THEN BEGIN    ; Read data
       ; First set  start_time  tag and   end_time  tag in header
       ; (This is the only place they are set.)
       spec_header(data_context).start_time=xut1
       spec_header(data_context).end_time=xut2
       spec_header(data_context).reload_flag=1
       ;r_hydra_spec
       r_timas_spec
       if ( get_err_no ne 0 ) then spec_header(data_context).reload_flag=1

       IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                 panelVector, orbitNr, $
                                 currPlotInfo.typeVector, $
                                 currPlotInfo.channel) $
         THEN BEGIN
           slice_Type=1+2+16
           IsRead=1           
           spec_header(data_context).reload_flag=0
           PAPCO_set_subtable, currPlotInfo.channel
           p_timas_spec, panelVector, currPlotInfo.typeVector, $
             _EXTRA=extra_PlotInfo              
       ENDIF
   ENDIF ELSE BEGIN
       slice_Type=1+2+16
       PAPCO_set_subtable, currPlotInfo.channel
       p_timas_spec, panelVector, currPlotInfo.typeVector, $
         _EXTRA=extra_PlotInfo 
   ENDELSE
;******
;   stop
;****** 
  
END


