;+ h0_summary_inc.pro                     H L Collin June 23, 1997
;
; TIMAS Level-One Summary Data Product Structure
;
; Values which are not available will be given a unique fill value.
; Nominal frequency of variables will be 2 spins (12 seconds),
; If a variable is available only every four spins then it has data and 
; fill alternately and its start and stop epoch values will reflect its 
; 24 second accumulation interval. 
; Data collection will be preferentially from 14 energy MRDF's, then
; 7 energy MRDF's, and if neither are available, form LRDF's.  Thus 
; energy steps and/or spin or detector sectors may be summed together 
; These conditions are indicated by "energy_status" and "pa_status".
; Data quality will be implied by the magnitude of "sigma" or in extreme
; cases by the presence of fill.  The quality will also be indicated by 
; the "quality" flag.
;
; Flag Definitions:
;
;   Quality:
;     0    OK.
;     1    Some data missing.
;     2    Slight MCP saturation.
;     3    Moderate MCP saturation.
;     4    Severe MCP saturation.
;     5    No magnetometer data available.
;     6    Warning flags set.
;     99   No valid data.
;
;   PA Status:
;     0    All 22 degree data.
;     1    Mostly 22 degree data.
;     2    Mostly 45 degree data.
;     3    All 45 degree data.
;     4    Smeared 22 degree data. Not spin locked.
;     5    Smeared 45 degree data. Not spin locked.
;     99   Invalid pitch angles.
;
;   Energy Status:
;     0    All single spin 14 energy step data.
;     1    Mostly 14 energy step data. Some 7 energy step. All one or two spin.
;     2    Mostly 7 energy step data. Some 14 energy step. All one or two spin.
;     3    All one or two spin 7 energy step data.
;     4    Mostly 14 energy step data. Some 7 energy step multispins.
;     5    Mostly one or two spin 7 energy step data. Some multispins.
;     6    Mostly multispin 7 energy step data.
;     7    All multispin 7 energy step data.
;     99   Invalid energies.
;     ( Probably some of these conditions (1,2,4,5,6) will be very rare )
;
; An MRDF can be identified by ( pa_status eq 0 and en_status eq 0 )
;
; 
; DEFINITION OF STRUCTURE "TIMAS_h0":
; modified October 14, by WKP to give 12 pitch angle bins...
; Comments in () refer to corresponding variables written to the CDF file.
;
; There are; 28 energy steps, 12 pitch-angle bins and 4 mass species.
;
; h0 = { TIMAS_h0,                      
;        energy_range  : byte,            ; Full, Reduced or Low (0,1,2)
;                                           (Energy_range_ID  CDF_UINT1)
;
;        even_odd      : byte,            ; 0 = even spin first, 1 odd first
;                                           ()
;
;        fec           : float,           ; Total FEC for this interval. 
;                                           ()
;
;        bcr           : float,           ; Total BCR for this interval. 
;                                           ()
;
;        start_epoch   : dblarr(4),       ; Epoch at start of interval 
;                                           (Epoch_start(4)   CDF_EPOCH)
;
;        stop_epoch    : dblarr(4),       ; Epoch at end of interval 
;                                           (Epoch_stop(4)    CDF_EPOCH)
;
;                                           (H_center_time)
;
;        spins         : bytarr(4),       ; Number of spins in this interval 
;                                           (Spins)
;
;        energy_status : bytarr(4),       ; Energy step combination state 
;                                           (Energy_status)
;
;        pa_status     : bytarr(4),       ; Spin sector combination state 
;                                           (PA_status)
;
;        quality       : bytarr(4),       ; Data quality / Error condition 
;                                           (Quality)
;
;        flux          : fltarr(28,12,4), ; Flux values or fill
;                                           (Flux_H, Flux_O, 
;                                            Flux_He_1, Flux_He_2)
;        sigma         : bytarr(28,12,4)  ; Standard error as % of flux 
;                                           (Sigma_H, Sigma_O, 
;                                            Sigma_He_1, Sigma_He_2)
;      }
; 
;-

; DEFINITION OF STRUCTURE "TIMAS_h0":

h0 = { TIMAS_h0,                                                         $
       energy_range: -1B, even_odd: -1B, fec: -1.0, bcr: -1.0,           $
       start_epoch: dblarr(4), stop_epoch: dblarr(4),                    $ 
       spins: bytarr(4), energy_status: bytarr(4), pa_status: bytarr(4), $ 
       quality: bytarr(4), flux: fltarr(28,12,4), sigma: bytarr(28,12,4) }


; DEFINITION OF ENERGY & PITCH-ANGLE BINS:

energy_bins = 28L

energy_center = [    25.0,    45.0,    68.0,    92.5, $
                    125.8,   171.0,   232.6,   316.2, $
                    430.1,   584.8,   795.3,  1081.5, $
                   1470.7,  2000.0,  2438.0,  2972.0, $
                   3622.9,  4416.4,  5383.6,  6562.7, $
                   8000.0,  9752.1, 11888.0, 14491.6, $
                  17665.4, 21534.4, 26250.7, 30702.0 ]

energy_bounds = [ 16.0, 34.6, 54.4,    78.2,   106.5, $
                    145.1,   197.6,   269.2,   366.7, $
                    499.5,   680.1,   926.1,  1260.8, $
                   1716.3,  2203.7,  2690.0,  3283.6, $
                   4002.1,  4877.8,  5945.1,  7246.1, $
                   8831.9, 10774.9, 13125.6, 16003.5, $
                  19497.5, 23768.4, 28970.2, 33298.0 ]

pa_bins = 12L

pa_center = [   7.5,  22.5,  37.5,  52.5,  67.5,  82.5, $
               97.5, 112.5, 127.5, 142.5, 157.5, 172.5 ]

pa_bounds = [  0.0, 15.0, 30.0, 45.0, 60.0, 75.0, 90.0, $
               105.0, 120.0, 135.0, 150.0, 165.0, 180.0 ]

; DEFINITION OF ION SPECIES:

;                 H+          O+           He+          He++

ion_mass   = [     1,         16,           4,           4       ]

ion_charge = [     1,          1,           1,           2       ]

ion_name   = [ '!5H!U+!N', '!5O!U+!N', '!5He!U+!N', '!5He!U++!N' ]

