;*     Adapted from the Hydra version by J. Faden, ESC, 1/98.
pro timas_define_structure, spec_header=define_spec_header

; COMMON hydra_spec_panel_DATA, widgetData

  if keyword_set( define_spec_header ) then begin
;      common hydra_spec_data, $
;        data_context, $         ; selects current data set
;        spec_type_names, $
;        spec_header, $
;        spec_data, $
;        spec_aligned_data, $
;        spec_perp_data, $
;        spec_opposed_data, $
;        spec_skew_data, $
;        hr_spec_data, $
;        hr_spec_aligned_data, $
;        hr_spec_perp_data, $
;        hr_spec_opposed_data, $
;        hr_spec_skew_data
        
      common timas_l1_data, $
        data_context, $         ; selects current data set
        spec_type_names, $
        spec_header, $
        spec_data

;      header= { spec_header, $
;
;                start_time:long(0), $ ; T90
;                end_time:long(0), $ ; T90
;                pitch_range:fltarr(2), $
;                skew_cone_width:float(0), $
;                time_resolution:float(0), $
;                
;                spec_type_id:0, $
;                spec_type_name:' ', $                 
;                data_version:float(0), $
;                data_file_1:' ', $
;                data_file_2:' ', $
;
;                calibration_version:float(0), $
;                reader_version:float(0), $
;                rgains_version:float(0), $
;                igains_version:float(0), $
;                glint_mask_version:float(0), $
;                background_version:float(0), $
;                mfe_calibration_version:float(0), $
;                sc_potential_version:float(0), $
;                intersweep_version:float(0), $
;                nen:fix(0), $
;                mode_energy:fltarr(111,50), $
;                reload_flag:0, $
;                message_flag:0 $
;              }
              
       spec_header= { timas_spec_header, $
                 start_time:long(0), $ ; T90
                 end_time:long(0), $ ; T90
                 energy_bins: 0, $              ; No. of energy bins
                 energy_center: fltarr(28), $   ; (ev)
                 energy_bounds: fltarr(29), $   ; (ev) 
                 pa_bins: 0, $                  ; No. of pitch angle bins
                 pa_center: fltarr(12), $       ; (deg)
                 pa_bounds: fltarr(13), $       ; (deg)
                 ion_mass: intarr(4), $         ; Integer (amu)
                 ion_charge: intarr(4), $       ; Integer, positive charge
                 ion_name: strarr(4), $         ; Ion name w/IDL escape seq.
                 reload_flag:0 $
               }
              
;      spec_header= replicate( header, 10 )
;      spec_header(0).pitch_range=[0,180]
;      spec_header(1).pitch_range=[0,30]
;      spec_header(2).pitch_range=[75,105]
;      spec_header(3).pitch_range=[150,180]
;      spec_header(4).skew_cone_width=30
;      
;      spec_header(5).pitch_range=[0,180] 
;      spec_header(6).pitch_range=[0,30]
;      spec_header(7).pitch_range=[75,105]
;      spec_header(8).pitch_range=[150,180]
;      spec_header(9).skew_cone_width=30
;      
;      spec_header(0:4).time_resolution=13.8 ; used as flags
;      spec_header(5:9).time_resolution=1.15
;      
;      spec_header(*).spec_type_id= [indgen(5),indgen(5)]
;
;      spec_header(*).data_version= 99999.
;      
;      spec_type_names= [ 'spec', 'spec_aligned', 'spec_perp', $
;                         'spec_opposed', 'spec_skew', $
;                         'hr_spec', 'hr_spec_aligned', 'hr_spec_perp', $
;                         'hr_spec_opposed', 'hr_spec_skew'  ]

      spec_type_names= [ 'spec' ]
            
;      if n_elements( widgetData ) gt 0 then $
;;        data_context= widgetData.typeVector(1)*5 + widgetData.typeVector(2)
;        data_context= 0
  endif
  return
  
end
