pro timas_goodticks, tickv, minor

; Given the start and end times in common time, returns
; tickv and number of minor ticks that are easy to read. 
;
; Axis most start at zero and be in seconds.
;
; Written: 11/21/96 by Jeremy Faden, University of Iowa
; Renamed Hydra version, ESC, 2/98.
;

   common time, xut1_t90, xut2_t90
   xut1= xut1_t90 mod 86400
   xut2= xut1 + (xut2_t90-xut1_t90)
   dsec= xut2-xut1

   if (dsec le 10) then begin
       majtick=1
       minor=4
   endif else if (dsec le 15*6) then begin
       majtick=15
       minor=3
   endif else if (dsec le 60*6) then begin
       majtick=60
       minor=4       
   endif else if (dsec le 120*6) then begin
       majtick=120
       minor=4
   endif else if (dsec le 300*6) then begin
       majtick=300              ; 5 minutes between major ticks
       minor=5                  ; minor tick intervals
   endif else if (dsec le 900*6) then begin
       majtick=900              ; 15 minutes
       minor=5
   endif else if (dsec le 1800*6) then begin
       majtick=1800              ; 30 minutes
       minor=3
   endif else if (dsec le 3600*6) then begin
       majtick=3600             ; 1 hour 
       minor=4    
   endif else if (dsec le 7200L*6) then begin
       majtick=7200             ; 2 hour 
       minor=4    
   endif else if (dsec le 14400L*6) then begin
       majtick=14400            ; 4 hour
       minor=4
   endif else if (dsec le 43200L*6) then begin
       majtick=43200            ; .5 day
       minor=6
   endif else if (dsec le 86400L*6) then begin
       majtick=86400            ; 1 day
       minor=4
   endif else if (dsec le 345600L*6) then begin
       majtick=345600           ; 4 days
       minor=4
   endif else begin
       majtick=864000           ; 10 days
       minor=10
   endelse

   nummajticks= dsec/majtick + 1
   
   firsttickv= $
     (majtick)*long(ceil(xut1/float(majtick))) ;189302400 at 0:00
   tickv= lindgen(nummajticks)*majtick + firsttickv
   
   r= where(tickv ge xut1 and tickv le xut2)
   if r(0) ne -1 then tickv= tickv(where(tickv ge xut1 and tickv le xut2))
   tickv=tickv-xut1

   return
end
