function timas_hms, time, secformat=secformat
;  converts time in seconds since midnight (or T90) to a string in the form,
;  'HH:MM:SS' or as specified by format.
;  Renamed Hydra version, ESC, 2/98.

   t= (time) mod 86400
   hour = fix(t/3600.)
   minute = (t mod 3600)/60
   if not keyword_set( secformat ) then begin
       secformat='i2.2' 
       sec= fix ( (t mod 60) + 0.5 )
   endif else begin
       sec= t mod 60.
   endelse
   return, string(hour,minute,sec, format="(i2.2,':',i2.2,':',"+secformat+")")
end
