;*----------------------------------------------------------------------------
;*
;*       SHOW_OPTIONS     Create SHOW_OPTIONS widget and hand off to XMANAGER
;*                       If it already exists then update channels names
;*
;* MODIFICATION HISTORY:       
;*      June 1997, written by S. BOURDARIE
;*----------------------------------------------------------------------------
pro show_line_options  ;,group_leader=group_leader

   COMMON line_panel_DATA, widgetData
   COMMON line_channel, channel_names

   COMMON line_options,count,dwin,show_options,base,done

;
count = n_elements(channel_names)
;
; need to transform widgetData.ioptions(*)
; into binary to get the code for selected channels
;
show_options = intarr(160)
for iop = 0,15 do begin
   aux = widgetData.ioptions(iop)
   for i=0,9 do begin
      show_options(iop*10+i) = aux - 2*(aux/2)
      aux = aux/2
   endfor
endfor

;-------        Create widget
xs=200
ys=20
dwin=intarr(n_elements(channel_names))
Ncolumn = CEIL(n_elements(channel_names)/30.)
base = widget_base(title = 'Select Multiple Channels',/column)
done=widget_button(base,value='Done')
xbase=widget_base(base,/frame, column=Ncolumn)
for i=0,n_elements(channel_names)-1 do begin
        tbase=widget_base(xbase,/row,/nonexclusive)
        etiq = channel_names(i)
        dwin(i)=widget_button(tbase,value=etiq,xsize=xs,ysize=ys)
endfor


widget_control,base,/realize
for i=0,n_elements(channel_names)-1 do begin
    if (show_options(i) eq 1) then widget_control, dwin(I),/set_button
endfor

;-------        Hand off to XMANAGER
xmanager,'show_line_options',base, /MODAL
end

;****************************************************
pro show_line_options_event,event

   COMMON line_options,count,dwin,show_options,base,done
   COMMON line_panel_DATA, widgetData


result=event
        for I=0,count-1 do begin
          if (result.id eq dwin(i)) then begin
             if (show_options(i) eq 1) then begin
                show_options(i)=0
                widgetData.ioptions(i/10) = widgetData.ioptions(i/10) - 2^(i-10*(i/10))
             endif else begin
                show_options(i)=1
                widgetData.ioptions(i/10) = widgetData.ioptions(i/10) + 2^(i-10*(i/10))
             endelse
          endif
        endfor
        if (result.id eq done) then begin
                        widget_control,base,/destroy
                        return
        endif
end
