;******************************************************************************
;* file p_line_line.pro
;*
;* this file is a template for a plot routine which can be used by papco.
;* it includes all the periphery needed, the user simply has to add in
;* the actual plot statement for his/her kind of data.
;*
;* This is a working example for a pre-defined example data array.
;******************************************************************************
;******************************************************************************
;* PROCEDURE:     
;*      p_line_line, panel, type, $
;*           OVERPLOT=OVERPLOT,$
;*           PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           SUBTABLE=SUBTABLE, $
;*           _EXTRA=extra_par
;* 
;* DESCRIPTION:  
;*	This procedure plots data of type data_type for inclusion in papco.  
;*      Data must have been read and placed into common blocks before this
;*      routine is called. Behavior is controlled by the vector panel
;*	which controls positioning of the plot (see papco_conventions.text
;*      in $papco). In general, the following plot conventions are used:
;*              - if the panel is at the bottom plot time axis plus any
;*                additional axis (ie ephemeris) needed.
;*              - if panel is at the top also plot a title
;*              - a descriptor for panels is plotted to the right of each
;*                panel, rotated by 90 deg if there is a papco_colorbar.
;*              - panels all have common time
;*              - y-scaling (or z-scaling for color plots) is either
;*              - automatic or manualy set using common yscale or zscale   
;*
;* INPUTS:       
;*      panel   three element integer vector. Controls positioning of the plot
;*              (see papco_conventions.text in $papco)
;*      type    optional parameter for options. Normally is a four element
;*              integer vector. This is normally equivalent to the field
;*              typeVector of the papco structure papco_PLOTINFO which is set
;*              by the panel editor. Additional fields that can be used if
;*              needed are papco_PLOTINFO.switch (three element vector) and 
;*              papco_PLOTINFO.channel (integer). If your plot routine needs
;*              more input fields than these you have to extend the definition
;*              of the structure papco_PLOTINFO
;*              (procedure papco_getPlotInfoStruct in $papco/papco.pro). Try to
;*              avoid this!
;*              
;* OUTPUTS: 
;*      none
;*
;* KEYWORDS:
;*      OVERPLOT  if you support this you can alter the appearance of your
;*              plot if it is an overplot to an existing panel. Standard is
;*              to plot data, no axis, using the y-scaling of the first plot
;*              and to shift the labeling on the left down one line. Useful
;*              to plot model data together with real data, ie mag. field.
;*              see p_crres_mag for an example.
;*      PLOTS_ATTHISPOSITION  used to control the left side labeling for more
;*              than one overplot at the same position.
;*      _EXTRA  the plot structure containing some keyword for calls to
;*              plot. Used to customize color and line style.   
;* 
;* CALLING SEQUENCE:
;*       p_line_line, panel, type, $
;*           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           _EXTRA=extra_par
;*
;* MODIFICATION HISTORY:       
;*     written June 1997, S. BOURDARIE
;*     modified September 1999, S. BOURDARIE
;*     modified June 2004, J. Niehof at BU (did not plot properly)
;******************************************************************************
pro p_line_line, panel, channel1, $
                      OVERPLOT=OVERPLOT, $
                      PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION, $
                      SUBTABLE=SUBTABLE, _EXTRA=extra_par

; NOTE: I use a little trick in passing in the keywords to to this
; routine. The calling routine's call is simply:
;         p_line_line, panelVector, currPlotInfo.typeVector(0), $ 
;                           _EXTRA=extra_PlotInfo
; extra_PlotInfo contains the tags OVERPLOT, PLOTS_ATTHISPOSITION,
; SUBTABLE and then some tags which are meant to be passed to the plot
; call. By putting in the explicit keywords in the procedure definition they
; get split out of the structure extra_PlotInfo that was passed in, and only
; those tags which are meant for the plot routine remain in extra_par.

; Comments here should include an explanation of the plot options used
; in type, switch. Replace type in the call with whatever variables
; you need, or add more

; The following common blocks are needed:

  common mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
  common yscale, yscl			;man/auto yscaling
  common shift_label, down             ;common for x-axis label shifting
  common coordinateSystems, plotted_x, plotted_y  
                                       ;info on coords used by mouse
  common time, xut1,xut2

; One of the common blocks should contain the plot data as returned by the
; data read procedure r_line. 
  common line_data, input_header, input_data
  
  panelset,panel			;sets the panel position viewport

; make color array
  common papco_color_names
  couleur_arr = [black, red, green, yellow, blue, magenta, cyan, white, $
    burgundy, olive, dark_green, teal, royal_blue, violet, dark_grey, grey]

; since there is a common time axis plots look better if they all use the same
; number of xticks. In papco, this number is 6 by default. This is set by papco
; using the IDL graphics system variable !X.TICKS.
; You can override this for your own plot by setting the variable
; below. However, for plotting panels together, it makes sense to stick to the
; default. If you do set this variable, it needs to be included in the 
; extra_plotPar_common definition below.

;   xtickno=6

; NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! 
; Avoid setting the global IDL graphics system variables in your plot routine,
; as they may affect other modules' plot routines. The IDL graphics system 
; variables are set by papco to default values that guarantee some uniformity
; of plot appearance and should not be tampered with - unless you don't
; care if your plot "looks good" when combined with the other modules.
; NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! NB!!! 

; the plot-calls normally use the arrays time for the time axis and yarr (ymat 
; for color plots) for the y or z axis.
; depending on your plot options, different data may be selected and different
; axis-labeling may be needed. This is normally done using a case statement.
; In this example the data array consist of flux values in ten channels 
; at different energies, typical of particle spectrometer data. Here I use the
; channel information passed in the plotinfo structure from the panel editor
; to select the channel to be drawn.

; set the begin end end times. papco convention is to use running seconds
; starting with the no of seconds since the beginning of the start day.
  time=input_data.time
  xut1=double(mjdt_start.mjd) + mjdt_start.t / 86400.0D
  xut2=double(mjdt_end.mjd) + mjdt_end.t / 86400.0D
;
; extract which channels are to be plotted
  show_options = intarr(160)
  for iop = 0,15 do begin
      aux = channel1(iop)
      for i=0,9 do begin
          show_options(iop*10+i) = aux - 2*(aux/2)
          aux = aux/2
      endfor
  endfor
  index_y = where(show_options eq 1)

  count_plot = -1
  yray = fltarr(n_elements(input_data),n_elements(index_y))
  channel_name = strarr(n_elements(index_y))
  for i=0,n_elements(input_header.yarr)-2 do begin
        if (show_options(i) eq 1) then begin
           count_plot = count_plot+1
           for j=0L,n_elements(input_data)-1L do begin
               yray(j,count_plot) = input_data(j).ymat(i)
           endfor

;
; extract formatted comment
           if input_header.yarr(n_elements(input_header.yarr)-1) eq ' ' or $
	   input_header.yarr(n_elements(input_header.yarr)-1) eq 'end' or $
	   input_header.yarr(n_elements(input_header.yarr)-1) eq 'END' then begin
             channel_name(count_plot) = strtrim(input_header.yarr(i),2)
	   endif else begin
             channel = strtrim(input_header.yarr(i),2)
             last_char = STRMID(channel,strlen(channel)-1,1)
             while last_char eq '0' do begin
               channel = strmid(channel,0,strlen(channel)-1)
               last_char = STRMID(channel,strlen(channel)-1,1)
             endwhile
             channel = channel + ' - ' + strtrim(input_header.yarr(i+1),2)
             last_char = STRMID(channel,strlen(channel)-1,1)
             while last_char eq '0' do begin
               channel = strmid(channel,0,strlen(channel)-1)
               last_char = STRMID(channel,strlen(channel)-1,1)
             endwhile
             channel_name(count_plot) = channel
	   endelse

        endif
  endfor

  utitle=input_header.comment1 + '!C' + input_header.comment2

  uytitle=input_header.unit
 
  nodat = 0.

; restrict data to actual time range requested - this makes for faster zooming
  index=where((time ge xut1) and (time le xut2),count)
  if count ne 0 then begin
      yra = fltarr(n_elements(index),n_elements(index_y))
      for j=0L,n_elements(index_y)-1L do begin
         y = yray(*,j)
         y = y(index)
         yra(*,j)=y
      endfor
      yray = yra
      time=time(index)
  endif


; check for min and max values
  if (yscl(panel(0),3) eq 0) then begin
    ylim3,time,yray,yst,yen
  endif else begin
    ylim_line_io,time,yray,yst,yen
  endelse

; the variables used above have the following meaning:
; 	uytitle : the y-axis label
;	utitle  : the right-of plot label defining the data
;
; the procedure YLIM3 is optional and sets the ylimit automatically for the
; data leaving a 10% gap at the top and bottom limits.
; this routine is very simple and does not handle spikes or bad data, you may
; need to supply your own procedure for your own data. 
; (in $papco/papco_Lib/ylim.pro)

; yscl of common block yscale is an array of dimensions (*,4) and contains info
; on the yscaling to be used. The first dimension identifies the panel, and the
; next dimension has three entries:  
;         yscl(*,0)  is  0 for "use automatic scaling", 1 for "use manual"
;         yscl(*,1)  is then ymin (or zmin)
;         yscl(*,2)  is then ymax (or zmax)
;         yscl(*,3)  is 0 for "linear" and 1 for "log"  scale
; when scaling is set to automatic, the automatic y-limits are loaded in.
  if (yscl(panel(0),0) eq 1) then begin
    yst=yscl(panel(0),1) &  yen=yscl(panel(0),2)
  endif else begin
    yscl(panel(0),1)=yst &  yscl(panel(0),2)=yen
  endelse
  
; uae auto y-labeling routine to get "good" y-lables. This sets the global IDL
; graphics system variables !Y.MINOR, !Y.TICKV, !Y.TICKS - so if you want to 
; use this feature, avoid setting these or their keywords in your plot call.
  papco_y_label, yst, yen, log=yscl(panel(0),3)  

; set up extra plot keywords: yrange, xrange, are always needed. xtickformat
; sets the format of the x-axis ticks, default is no ticks. You can use any of
; the other keywords allowed with IDL's plot routine. But beware that some
; keywords have default values set by PAPCO.
; (Some of which you can set in the papco defaults widget):
;
;    !P.CHARSIZE  = widgetData.default_charsize    
;    !P.CHARTHICK = widgetData.default_charthick
;    !P.FONT      = -1
;    !P.NOERASE   = 1
;    !P.TICKLEN   = widgetData.default_TICKLEN
;    !X.TICKS     = widgetData.default_XTICKS
;    !X.STYLE     = widgetData.default_XSTYLE
;    !Y.STYLE     = 1
;    !X.MINOR     = widgetData.default_XMINOR
;
; Overriding values by setting keywords is possible and allowed but discouraged
; since then your plot might no longer have the "common" look used in
; PAPCO. The widgetData structure is PAPCO's main internal data
; structure.
;  extra_plotPar_common={yrange:[yst,yen], xrange:[xut1,xut2], $
;                        ystyle:1, ylog:yscl(panel(0),3)}
; didn't work; this is now consistent with p_map_spec line 278 -JTN-
  extra_plotPar_common={yrange:[yst,yen], xrange:[xut1,xut2], $
                        ystyle:1, ylog:yscl(panel(0),3), $
                        xtickformat: 'noticks'}
   
; add keyword structure set here with the one passed in
; I believe this next line was an error, so commented out and fixed -JTN-
;  extra_plotPar_common=create_struct(extra_plotPar_common, extra_par)
  extra_plotPar=create_struct(extra_plotPar_common, extra_par)
  
; use papco routine to draw time axis. This checks for bottom plot and uses the
; user's xtickformat if it is something other than 'noticks'.
; If you use this rotuine, make sure your data plot routine uses xstyle=5 and 
; ystyle=5 (inhibit axis) so that you don't clobber those drawn by papco.  
; "down" sets the axis labeling level. 
  down=0
  papco_draw_time_axis, panel, OVERPLOT=OVERPLOT, _extra=extra_plotPar     

; now do the actual data plot, data only, no axis
  couleur_start = extra_plotPar.color
  couleur_index = where(couleur_start eq couleur_arr)
  if couleur_index(0) eq -1 then couleur_index(0) = 0
  couleur = extra_plotPar.color
  ind = -1
  message,varprt(couleur_start), /cont
  for i=0L,n_elements(index_y)-1L do begin
    message,'plot '+varprt(couleur), /cont
    ind = ind+1
    y_line = yray(*,i)
    extra_plotPar.color = couleur
    line_gap_oplot,time,y_line, _extra=extra_plotPar, xstyle=5, ystyle=5
    if couleur_index(0)+ind+1 gt n_elements(couleur_arr)-1 then begin
      ind = -2 - couleur_index(0)
    endif
    couleur = couleur_arr(couleur_index(0)+ind+1)
  endfor
;  stop
  
; plot y-axis label at left of plot. Use scalable routine!  
  left_side_label,panel,uytitle,/rot90  
  
; store the coordinate information into common block for slices
  plotted_x = !x  &  plotted_y = !y

; plot extra x-axis labels (eg. ephemeris) and a x-axis label if required.
; plot in color=1. 
; The routine x_side_label puts x-axis label to the right of the axis.
  if (panel(0) eq 0) and not keyword_set(OVERPLOT) then begin
    ;extra_plotPar=create_struct({xtickformat:'mjd_dec_1'}, $
    ;                            extra_plotPar_common) 
    ;extra_plotPar.color=1     
    ;down=1
    ;plot,time,yray, _extra=extra_plotPar,xstyle=1,ystyle=1, /NODATA
    ;x_side_label,panel,'time (UT)!CDate'
  endif

; plot info right of the panel. If you want overplots to have their own labels
; you need to add position-control for this label using the keyword
; PLOTS_ATTHISPOSITION
   print,couleur_start
   extra_Par.color = couleur_start
   couleur = extra_Par.color
   if not keyword_set(overplot) then begin
     extra_Par.color = couleur
     utitle = utitle + '!C' + channel_name(0)
     right_side_label,panel,utitle,_extra=extra_Par
     utitle_1 = '!C!C'
     ind = -1
     for i=1,n_elements(index_y)-1 do begin
         print,couleur
         ind = ind+1
;         couleur = couleur + 1
;         if (couleur eq 2) then couleur = 171
;         if (couleur eq 185) then couleur = 1
;         print,couleur
         if couleur_index(0)+ind+1 gt n_elements(couleur_arr)-1 then begin
           ind = -2 - couleur_index(0)
         endif
	 print,'indice',couleur_index(0)+ind+1
         couleur = couleur_arr(couleur_index(0)+ind+1)
         extra_Par.color = couleur
         utitle = utitle_1 + '!C' + channel_name(i)
         utitle_1 = utitle_1 + '!C'
         right_side_label,panel,utitle,_extra=extra_Par
     endfor
   extra_Par.color = couleur_start
   endif ;else begin
;     for i=0, PLOTS_ATTHISPOSITION-1 do utitle='!C'+utitle
;     right_side_label,panel,utitle,_extra=extra_Par
;   endelse

end 

;******************************************************************************
pro ylim_line_io,time,yray,yst,yen

  common time, xut1,xut2

  index=where((time ge xut1) and (time le xut2) and (yray gt 0.),count)

  if count gt 2 then begin
    yen=max(yray(index),min=yst)
    yst = 10.^floor(ALOG10(yst))
    yen = 10.^ceil(ALOG10(yen))
  endif else begin
    yen=10.
    yst=1.
  endelse

end

;******************************************************************************
;* PROCEDURE:     
;*      goes_gap_oplot, x, y, _EXTRA=e
;* 
;* DESCRIPTION:  
;*      This procedure plots data without connecting data point if they are
;*      further than 5 min. apart.
;*
;* INPUTS:       
;*      x,y     arrays to be plotted
;*              
;* OUTPUTS: 
;*      none
;* 
;* CALLING SEQUENCE:
;*      goes_gap_oplot, x, y, _EXTRA=e
;*
;* MODIFICATION HISTORY:       
;*     written July 1997, Haje Korth
;*     modified February 1998, Sebastien Bourdarie
;*     modified June 2004, Jon Niehof at BU
;******************************************************************************
pro line_gap_oplot,x,y,_EXTRA=e

   ndat=n_elements(x)
   if (ndat eq 0) then return
   if (ndat lt 50) then begin
       for i=0l,ndat-2 do begin
           if ((x(i+1)-x(i)) LT 0.00347) then begin
               plot,[x(i),x(i+1)],[y(i),y(i)],noclip=0,_EXTRA=e
           endif else begin
               plot,[x(i),x(i)+.00347],[y(i),y(i)],noclip=0,_EXTRA=e
           endelse
       endfor
       plot,[x(i),x(i)+.00347],[y(i),y(i)],noclip=0,_EXTRA=e
   endif else begin
       for i=0l,ndat-2 do begin
           if ((x(i+1)-x(i)) LT .00347) then begin
               plot,[x(i),x(i+1)],[y(i),y(i+1)],noclip=0,_EXTRA=e
           endif else begin
               plot,[x(i)],[y(i)],noclip=0,_EXTRA=e
           endelse               
       endfor
   endelse
end


