;******************************************************************************
;* file papcoadd_salammbo
;*      papcoadd_salammbo
;* end
;******************************************************************************

;******************************************************************************
;* PROCEDURE:     
;*      PRO addplottype_salammbo_spec,plottypes_base,buttonGeometry,pb_plottype
;* 
;* DESCRIPTION:  
;*      This procedure adds a button for this salammbo_spec 
;*      to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*      package, so that they can be automatically called when needed.
;*      The button itself can contain access to a sub-menu for further
;*      salammbo_specs.
;*
;* INPUTS:       
;*      plottypes_base  the widget ID of the parent widget to contain the
;*                      plottype buttons.
;*
;* OUTPUTS: 
;*      pb_plottype     the widget ID of the button created here.
;*      buttonGeometry  size of the button. Only used in simple
;*                      WIDGET_BUTTON to make them the same size as the
;*                      compound CW_PDMENU, pulldown for sub-types.
;*
;* KEYWORDS:
;*       none
;* 
;* CALLING SEQUENCE:
;*      addplottype_salammbo_spec,plottypes_base,buttonGeometry,pb_plottype
;*
;* MODIFICATION HISTORY:       
;*      June 1997, written by S. BOURDARIE
;******************************************************************************
pro addplottype_salammbo,plottypes_base,buttonGeometry,pb_salammbo

COMMON LAST_salammbo_spec,salammbo_specNo       ; keep the last salammbo_spec read --> not to read again

salammbo_specNo = ''

MenuDesc = [ { CW_PDMENU_S,   3, strcenter('SALAMMBO',10) }, $ 
             { CW_PDMENU_S, 0, 'configure salammbo' }, $
             { CW_PDMENU_S, 2, ' salammbo         ' }  ]
  
pdm_salammbo = CW_PDMENU(plottypes_base, MenuDesc, $
                         UVALUE='pdm_salammbo')

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO addpanel_salammbo_spec
;*
;* DESCRIPTION:  
;*      Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      Using an instance of the papco_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled. The
;*      desired default values for the plotinfo tags need to be edited by
;*      the user. This plotinfo structure will be passed to the panel editor
;*      When it is first called for the salammbo_spec.
;*      "panelEditor" must be set to the name of the panel editor routine.
;*
;* INPUTS:       
;*      event           event value of papco main window. This is
;*                      only used if there are plot sub_types, 
;*                      for example see papcoadd_crres_plots
;* OUTPUTS: 
;*      none
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      addpanel_salammbo_spec
;*
;* MODIFICATION HISTORY:       
;*      June 1997, written by S. BOURDARIE
;*      September 1999, modified by S. BOURDARIE 
;******************************************************************************
pro addpanel_salammbo,event

COMMON get_error, get_err_no, get_err_msg

panelKind='salammbo'

r_module_config, panelKind, config_data, msg
if (get_err_no ne 0) and (event.value ne 1) then begin
    message,'You need to configure the module first', /cont
    papco_module_configure,panelKind
    return
endif  

CASE Event.Value OF 
    1: BEGIN
        papco_module_configure, panelKind
    END
    2: BEGIN
        panelKind=panelKind
        panelEditor=panelkind+'_panel'
        defaults=papco_getPlotInfoStruct()  
        defaults.typeVector=[0,0,0,0]       
        defaults.channel=0  
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults
      END
ENDCASE

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO plottable_salammbo_spec, plottable
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate plottable with / without orbit.
;*      PAPCO provides "set time by orbit" feature for CRRES and POLAR
;*      so far. Included for compatibility with older CRRES modules
;*      which ONLY use orbit as input to their read/plot routines
;*      (plotting over orbit boundaries is not enabled for CRRES)
;* 
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      plottable        a boolean 0 if plottable only by orbit
;*                                 1 if plottable by time also.
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      plottable_salammbo_spec, plottable
;*
;* MODIFICATION HISTORY:       
;*      June 1997, written by S. BOURDARIE
;******************************************************************************
pro plottable_salammbo, plottable

   plottable=1     ; 1 -> plotable without orbit info, by time 
                   ; 0 -> plotable only by orbit number not by time 
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO canget_salammbo_spec, canget
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate that salammbo_spec is capable of
;*      returning data from it's plot routine into a standard PAPCO
;*      array structure. Used for the scratch pad utility module.
;*      
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      canget         a boolean 0 if this feature is not available
;*                                1 if this feature is available
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      canget_salammbo_spec, canget
;*
;* MODIFICATION HISTORY:       
;*      December 1997, written by S. BOURDARIE
;******************************************************************************
pro canget_salammbo, canget

   canget=  1      ; 1 -> plot routine can return just data 
                   ; 0 -> feature disabled
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO descriptor_salammbo_spec, plotInfo, descriptStr
;* DESCRIPTION:  
;*      Constructs the string used to label plots in the panel window.
;*      The plotinfo structure passed in here is the panel's plotinfo
;*      as returned by the panel editor for this salammbo_spec. You can use
;*      the information in that structure to construct some informative
;*      label for the panel which then appears in the Panel Compose list.
;*
;* INPUTS:       
;*      plotInfo        structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*      descriptStr     a string containing the label
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      descriptor_salammbo_spec, plotInfo, descriptStr
;*
;* MODIFICATION HISTORY:       
;*      June 1997, written by S. BOURDARIE
;******************************************************************************
pro descriptor_salammbo, plotInfo, descriptStr

descriptStr='..'+strright(plotInfo.filename,41)

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO draw_salammbo_spec, panelVector, currPlotInfo, orbitNo $
;*                          get_data_call, slice_type, IsRead
;* DESCRIPTION:  
;*      This procedure performs the actual data read call and the plot call
;*      for this plottype. The user need to pass to his plot routine all the
;*      parameters needed, typically these parameters are stored in the 
;*      currplotinfo structure or constructed from them. The currplotinfo
;*      structure tags normally used for passing information from the panel
;*      editor to the plot routine are:
;*          type_vector - a four element array for choosing the type of data
;*                        (eg. elec or ion, diff or integ., pitch angle, 
;*                             or sector, channel ....)
;*          switch      - a three element vector for specific plot appearance
;*                        (eg. smoothing/averaging, interpolating ...)
;*          filename    - a filename
;*      
;*      These tags have grown out of traditional usage and can be used for
;*      anything the user wants to use them for. There are plenty variables
;*      for most applications: Adding a new tag to the plotinfo structure
;*      is not user-definable but need to be done at the papco core level.
;* 
;*      The panelVector MUST be passed to your plotroutine as it is used
;*      to set the panel position.
;*      The _EXTRA=extra_PlotInfo should be passed if you intend to make use
;*      of papco functionality such as overplotting, salammbo_linestyle choice and
;*      color bar choice.
;*
;* INPUTS:       
;*      panelVector    position of the plot (see papco_conventions.text, 6)
;*      currPlotInfo   structure containing all data for this plot.
;*                     (structure papco_PLOTINFO, see papco_variables.text) 
;*
;* OUTPUTS: 
;*      get_data_call  a string containing the data call. Used by other
;*                     routines that need to know how to get the data
;*                     in a panel, e.g. to draw spectra, distribution functions
;*      IsRead         a boolean which is set when the the data is read the
;*                     first time. Useful if a given data-read puts data
;*                     into commons which can be plotted in many ways.
;*                     When set, data does not have to be read again.
;   slice_type:   Selects which slices are supported and for which slice
;                 routines have been written.
;                 This is an integer logical with 16 switches. Currently
;                 there are 5 papco slices. You may extend this by
;                 further USER slices up to a total of 16 slices.
;                     0 = disable all slices
;                     1 = papco Zoom                 (2^0)
;                     2 = papco View Slice           (2^1)
;                     4 = papco Access level Zero    (2^2)
;                     8 = papco Write Paneldata      (2^3)
;                    16 = papco Hair Cursor          (2^4)
;                    32 = USER slice A or not used   (2^5)
;                    64 = USER slice B or not used   (2^6)
;                    "     "     "   "  "  "    "      "    
;                 32768 = USER slice Z or not used  (2^15)
;                        
;   You can support more than one type of slice by arithmetically adding the
;   options, eg slice_type=1+4  support Zoom and Level Zero
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      draw_salammbo_spec, panelVector, currPlotInfo, orbitNo, $
;*                                 get_data_call, slice_type, IsRead
;* MODIFICATION HISTORY:       
;*      June 1997, written by S. BOURDARIE
;*      September 1999, modified by S. BOURDARIE 
;******************************************************************************
pro draw_salammbo, panelVector, currPlotInfo, orbitNo, $
                   get_data_call, slice_type, IsRead

COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure
COMMON LAST_salammbo_spec,salammbo_specNo         
                      ; keep the last salammbo_spec read --> not to read again
COMMON PLOT_COMPOSER, widgetData


get_data_call='' ; data read call used by slices

; as papco dynamically allocates slice values for the user defined
; slices, one needs to be able to find out this assignment! Use the
; following function to find out the slice values for any slices you
; might have added for your module, so that you know which values to enable!
  
; set up which mouse functions to allow
slice_type=1+16+PAPCO_slice_value('USER multiple Vert Slices')$
               +PAPCO_slice_value('USER multiple Horiz Slices')

IsRead = 0

IF NOT IsRead THEN BEGIN             ; check if data has already been read
    r_salammbo, currPlotInfo, /verbose                ; read data
    ; check the read for success.
    IF papco_Draw_CheckResult(currPlotInfo.panelKind, $
                              panelVector, orbitNr, $
                              currPlotInfo.typeVector, $
                              currPlotInfo.channel)       THEN IsRead=1
ENDIF
  
IF IsRead THEN BEGIN
    p_salammbo, panelVector, currPlotInfo, _EXTRA=extra_PlotInfo
ENDIF

; Note: The structure extra_PlotInfo passed to the plot routine contains the
;       following tags: 
;                  overPlot               - overplot switch
;                  plots_AtThisPosition   - no. of overplots here
;                  subtable               - index of papco colortable 
;                  PSYM                   - salammbo_linestyle keyword for plot
;                  COLOR                  - salammbo_linecolor keyword for plot
;               
;       They are set by papco and your plot routine can use them if you
;       want to support that functionality.

END
