;******************************************************************************
;* PROCEDURE:     
;*      PRO salammbo_commons
;* 
;* DESCRIPTION:  
;*      simply sets up a couple of often used arrays in common blocks.
;*
;* INPUTS:       
;*      none
;*                  
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      salammbo_commons
;******************************************************************************
PRO salammbo_commons
  
COMMON salammbo, input_sats, output_sats, salammbo_control

input_sats = ['1989-046','1990-095','1991-080','1994-084', $
              'LANL-97A','LANL-01A','LANL-02A', $
              'ns18', 'ns24', 'ns28', 'ns33',$
              'HEO_1', 'HEO_3', $
              'Polar' ]

output_sats = [input_sats, 'SAMPEX']

salammbo_control = { $
  input:0l,  input_info: 'Bit toggle into input_sats, '+ $
                         'input satellite data into salammbo', $
  output:0l, output_info:'index into output_sats, '+ $
                         'output satellite orbit', $
  run:0,        run_info:'0: Existing input/run/output, '+$
                         '1: New input/run/output, '+ $
                         '2: New output, 3: New run/output' , $
  product:0,product_info:'0: Original, 1: Model, 2: Error', $
  graph:0,    graph_info:'0: Line, 1: Spec, 2:L-v. time', $
  equ:0,        equ_info:'0: on Magnetic equator, 1: at satellite orbit', $
  ech:0,        ech_info:'0: original channels, 1:choose channels', $
  chnum:'',   chnum_info:'String list of channel numbers (0,1,2..)', $
  chmev:'',   chmev_info:'String list of channel MeV (MeV1, MeV2,...)', $
  etype:0,    etype_info:'0: Int. (>E), 1: Diff (E1-E2), 2: Diff (E)', $
  smooth:0,  smooth_info:'0: none, 1: vertically, 2: horizontally, 3: both', $
  init:0,      init_info:'0: default, 1: last state previous run', $
  fill:0,      fill_info:'0: S/C -> loss cone, 1: Full S/C field line', $
  ch:'',         ch_info:'Comma delinited energy channels, MeV'}
  
;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to lanl_gps_control
salammbo_control = CREATE_STRUCT(salammbo_control, $
                                 papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))

;finally name the control structure. This is required for load/save operations!
salammbo_control = CREATE_STRUCT(name = 'salammbo_control', salammbo_control)

END
