;+
; NAME: ct_poly_area
;
; PURPOSE: calculate area of polygon.
;
; CATEGORY: ct_triangulation
;
; CALLING SEQUENCE: area= ct_poly_area( x, y )
; 
; INPUTS: 
;   x, y  1-d arrays
;
; KEYWORDS: 
;
; OUTPUTS:
;   returns area
;
; RESTRICTIONS:
;
; PROCEDURE:
;    calculate the signed area of all triangles formed between one
;    point and successive pairs on the polygon.  Total this.
;
; EXAMPLE:
;   x= [0,1,3,1,0]
;   y= [3,1,1,4,3]
;   print, ct_poly_area( x, y )
;
; MODIFICATION HISTORY:
;   written, jbf, Feb/8/2001
;-

pro testit
  a= reverse( findgen(360)/360 * 2 * !pi )
  x= [ cos(a)*2, cos(reverse(a))*1, cos(a[0])*2  ]
  y= [ sin(a)*2, sin(reverse(a))*1, sin(a[0])*2 ]
  plot, x, y
  print, ct_poly_area( x,y )

  x= [ cos(a)*2, cos(a[0])*2 ]
  y= [ sin(a)*2, sin(a[0])*2 ]
  print, ct_poly_area( x,y )

  x= [ cos(a)*1, cos(a[0])*1 ]
  y= [ sin(a)*1, sin(a[0])*1 ]
  print, ct_poly_area( x,y )

end
  
function ct_poly_area, x, y
  n= n_elements(x)-1
  return, $
    abs( total( ( x[0:n-1]-x[0] ) * ( y[1:n]-y[0] ) - $
                ( y[0:n-1]-y[0] ) * ( x[1:n]-x[0] ), /double ) /2 )
end

