;+
; NAME: ct_time_string
; PURPOSE: convert ct_time number which is decimal days 
;     since midnight 1/17/1972, to a formatted string.
;     The integer part is printed as a date, and the decimal
;     part is printed as time.  If the argument is an integer,
;     then no time is printed.
;
; CALLING SEQUENCE: print, ct_time_string( 150.5 )
; INPUTS: time, in ct_time format.
; OUTPUTS: a string.
; OPTIONAL OUTPUTS: month=month, day=day, year=year, julian=julian
;                   hours=hours, minutes=minutes, seconds=seconds
;-

function ct_time_string, time, julian=julian, $
                         just_time=just_time

  if n_elements( time ) gt 1 then begin
      message, 'Input must be a scalar.  Use ct_time_to( /string )'
  endif
  ict_time= floor( time )
  if keyword_set( julian ) then begin
      julian= ict_time 
  endif else begin
      julian= ict_time + 2441334
  endelse
  caldat, julian, month, day, year
  date_str= string(year,format='(i4.4)') + $
    string( month, format='(i2.2)' ) + $
    string( day, format='(i2.2)' )
  
   time_part= ( time - ict_time )
   hours= fix( time_part * 24 )
   minutes= fix( time_part * 1440 ) - 60 * hours
   seconds= long( time_part * 86400 - 3600L * hours - 60 * minutes + 0.5 )
   if ( seconds eq 60 ) then begin
       seconds= 0
       minutes= minutes+1
   endif
   if ( minutes eq 60 ) then begin
       minutes= 0
       hours= hours+1
   endif
   if ( hours eq 24 ) then begin 
       hours=0
       julian=julian+1
       caldat, julian, month, day, year
       date_str= string(year,format='(i4.4)') + $
         string( month, format='(i2.2)' ) + $
         string( day, format='(i2.2)' )
   endif

   time_str= string( hours, format='(i2.2)' ) + ':' + $
     string( minutes, format='(i2.2)' ) + ':' + $
     string( seconds, format='(i2.2)' )

   
   if keyword_set(just_time) then datestr='' else datestr= date_str
   s= size( time ) 
   if s(1) eq 4 or s(1) eq 5 then $
     return= datestr+ ' ' + time_str
   return= strtrim( return, 2 )

   return, return
end
       
   
