function ct_tri_area, x, y, T
;+
; NAME: ct_tri_area
; PURPOSE: return area of each triangle in a set of triangles.
; CATEGORY: plotting
; CALLING SEQUENCE: area= ct_tri_area( x, y, T )
; INPUTS: 
;    x, y  Triangle vertex locations
;    T     Triangles (eg from triangulate)
;
; OUTPUTS: area of each triangle (in data units)
;
; PROCEDURE: calculate cross product magnitude
;
; EXAMPLE:
;  x= randomn(s,1000)
;  y= randomn(s,1000)   ; sample data
;  triangulate, x, y, T
;  area= ct_tri_area( x, y, T )
;  r= where( area lt 0.01 )
;  T= T(*,r)
;  plot_triangles, x, y, T
;
; MODIFICATION HISTORY:
;
;-
  mag_cross=  abs( ( x(T(1,*))-x(T(0,*)) ) * ( y(T(2,*))-y(T(0,*)) )  -  $
                   ( y(T(1,*))-y(T(0,*)) ) * ( x(T(2,*))-x(T(0,*)) ) )
  return, mag_cross/2.
end
