pro ct_get_ticks, ct_start, ct_end, ct_tickv, minor, tickformat= tickformat

; Given the start and end times in ct_time, return
; tickv and number of minor ticks that are easy to read.
;

   xut1= ct_start * 86400
   xut2= ct_end * 86400   
   dsec= xut2-xut1

;                   1 2mn   3   5  15   30  1hr   2     4    6     1day  10day
   Amajtick= $
     [1L,2,5,15,30,60,120,180,300,900,1800,3600,7200,14400,43200,86400,345600L]
   Amintick= $
     [5, 2,5, 3, 2, 4,  4,  3,  5,  3,   3,   4,   4,    4,    6,    4,   10 ]
   itickform= $
     [0, 0,0, 0, 0, 1,  1,  1,  1,  1,   1,   2,   2,    2,    2,    3,    3 ]
   Atickformat= ( [ 'tick_ct_hms', $
                    'tick_ct_hour_minute', $
                    'tick_ct_date_hour', $
                    'tick_ct_date' ] ) [ itickform ]
   Nticks= dsec / Amajtick
   r= where( Nticks ge 4 and Nticks le 6, count )
   if count eq 0 then begin
       r= where( Nticks le 7 and Nticks gt 0, count )
       if r(0) ne -1 then use= r(0) else use=1
   endif else begin
       use= r(count-1)
   endelse

   majtick= Amajtick(use)
   minor= Amintick(use)
   tickformat= Atickformat(use)
   nummajticks= dsec/majtick + 1
   
   firsttickv= $
     (majtick)*long(ceil(xut1/float(majtick)))
   tickv= lindgen(nummajticks)*majtick + firsttickv
   
   r= where(tickv ge xut1 and tickv le xut2)
   if r(0) ne -1 then tickv= tickv(where(tickv ge xut1 and tickv le xut2))

   ct_tickv= tickv / 86400.

   return
end
