;+
; NAME: ct_web_read_table
;
; PURPOSE: parse html table.
;
; CATEGORY: 
;
; CALLING SEQUENCE: table= ct_web_read_table( unit )
; 
; INPUTS:
;   unit   logical unit for the web input data stream.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;   initial_line=''   pass in the first line, in case a read is needed to
;                       detect the table.
;   last_line=''      returns remainder of the last line read.
;
; OUTPUTS:
;   returns  strarr(ncol,nrow+1)  0th row is the table headings.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;   assumes that the table is syntactically correct, and I bet some correct
;     tables would still break it.
;   case matters!!! assumes that html tags are lower case--sorry!
;
; PROCEDURE:
;   
; EXAMPLE:
;
; MODIFICATION HISTORY:
;   written, jbf, cottagesystems, Feb 13, 2001.
;-

function ct_web_read_table, unit, initial_line=line, last_line=last_line

  if n_elements( line ) eq 0 then line=''
  
  irow=0

  not_done=1
  
  while not_done do begin

      buffer= line

      while strpos( line,'</table>') eq -1 and strpos( line, '</tr>' ) eq -1 do begin
          readf, unit, line
          buffer= buffer + line    
      endwhile
      
;  we now have '<front_part><tr><table row></tr><last part>'

      if strpos( line, '</table>' ) ne -1 then begin
          i= strpos( buffer, '</table>' )
          last_line= strmid( buffer, i+8, strlen(buffer)-i-8 )
          buffer= strmid( buffer, 0, i )
          not_done= 0
      endif
      
      if strtrim( buffer,2 ) ne '' then begin
          i= strpos( buffer, '<tr>' )
          s= strmid( buffer, i+4, strlen(buffer)-i-4 )
          i= strpos( s, '</tr>' )
          line= strmid( s, i+5, strlen(s)-i-5 )
          
          row1= strmid( s, 0, i )
          nrow= 50              ; guess 50 rows, we'll need to resize.
          
          if irow eq 0 then begin
              if strpos( row1, '<th>' ) ne -1 then begin ; read headings      
                  s= str_sep( strcompress(row1),'<th>' )
                  s= s[1:*]
                  ncol= n_elements(s)
                  result= strarr( ncol, nrow )
                  for icol= 0,ncol-1 do $
                    result[icol,0]= strmid( strtrim(s[icol],2),0,strlen(s[icol])-5 )
              endif else begin
                  s= str_sep( strcompress(row1),'<td>' )
                  s= s[1:*]
                  ncol= n_elements(s-1)
                  result= strarr( ncol, nrow ) ; leave headings empty
                  for icol= 0,ncol-1 do $
                    result[icol,1]= strmid( strtrim(s[icol],2),0,strlen(s[icol])-5 )
              endelse
          endif else begin
              s= str_sep( strcompress(row1),'<td>' )
              s= s[1:*]
              for icol= 0,ncol-1 do $
                result[icol,irow]= strmid( strtrim(s[icol],2),0,strlen(s[icol])-5 )
          endelse
          
          irow= irow+1
          if irow ge nrow then begin
              nrow= nrow+50
              result_new= strarr( ncol, nrow )
              for icol=0,ncol-1 do $
                result_new(icol,0:(irow-1))= result(icol,0:(irow-1))
              result= temporary( result_new )
          endif

      endif                     ; buffer ne ''

  endwhile

  result= result[ *, 0:(irow-1) ]

  return, result
end


