function sparc_data_availability, datacenter, name, $
                                  restrict_time= ct_time_range, $
                                  status=status
;+
; NAME: sparc_data_availability
;
; PURPOSE: return the range of records in time
;
; CATEGORY: sparc
;
; CALLING SEQUENCE:
;    ct_time_str= sparc_get_availability( datacenter, name )
; 
; INPUTS:
;    datacenter  name of data center.  eg 'sparc-dc2.si.umich.edu'
;    name        name of data set      eg 'MillstoneHill.ISRadar'
;
; KEYWORD PARAMETERS:
;    restrict_time=[ct_time1,ct_time2]    restrict query to time range
;
; OUTPUTS:
;    array of {ct_ttag_str}
;   	
; RESTRICTIONS:
;    time is sensed by checking if all of the first 17 characters of
;       each line are digits.
;
; PROCEDURE:
;    form URL for query, open channel, then parse output.
;
; EXAMPLE:
;    x= sparc_data_availability( 'sparc-dc2.si.umich.edu/sparc/DataCenter', $
;                                'MillstoneHill.ISRadar' )
;
; MODIFICATION HISTORY:
;    written, jbf, cottagesystems, Mar 1 2001 
;-
  
  status= sparc_get_status_struct()

  if n_elements( restrict_time ) eq 2 then begin
      restrict_time_str= $
        '&time='+ct_time_to_sparc(restrict_time[0])+$
        '-'+ct_time_to_sparc(restrict_time[1])
  endif else begin
      restrict_time_str=''
  endelse

  url=  'http://'+dataCenter+$
    '?name='+name+$
    '&view=time'+$
    restrict_time_str
  
  ct_web_open, unit, url, /get_lun

  if eof(unit) then begin
      status.code= -2
      status.message= 'Unexpected eof on web read...  Check URL: '+url
      free_lun, unit
      return, -1
  endif

  line=''
  ct_time_start= dblarr( 100 )
  ct_time_end= dblarr( 100 )
  time_bracket= bytarr( 100 ) ; stored as ascii character
  
  idx=0
  while not eof(unit) do begin
      readf, unit, line
      ascii_range= [ min(byte( strmid( line, 0, 17 )), max=max ), max ]
      is_time= ascii_range[0] ge 48 and ascii_range[1] le 57 
      if is_time then begin
          ct_time_start[idx]= sparc_to_ct_time(strmid( line, 0, 17 ))
          if strlen(line) gt 17 then begin
              ct_time_end[idx]= sparc_to_ct_time(strmid( line, 18, 17 ))
              time_bracket[idx]= byte(strmid( line,17,1 ))          
          endif else begin
              ct_time_end[idx]= ct_time_start[idx]
              time_bracket[idx]= byte('-')
          endelse
          idx= idx+1
          if idx gt n_elements( ct_time_start ) then begin
              ct_time_start= [ct_time_start,dblarr( 100 )]
              ct_time_end= [ct_time_end,dblarr( 100 )]
              ct_time_bracket= [ct_time_bracket,bytarr( 100 )]
          endif
      endif
  endwhile

  if idx gt 0 then begin
      ct_time_start= ct_time_start[0:(idx-1)]
      ct_time_end= ct_time_end[0:(idx-1)]
      time_bracket= time_bracket[0:(idx-1)]
      status.code=0
      status.message=''
  endif else begin
      message, 'no times returned.', /cont
      status.code= -2
      status.message= 'no times returned by datacenter'
  endelse

  free_lun, unit

  result= replicate( { ct_timetag_str }, n_elements( ct_time_start ) )
  
  result(*).time_start= ct_time_start
  result(*).time_width= ct_time_end - ct_time_start
  
  return, result

end


