function sparc_get_datacenters, status=status
;+
; NAME: sparc_get_datacenters 
;
; PURPOSE: get a list of the Sparc datacenters
;
; CATEGORY: sparc
;
; CALLING SEQUENCE: list= sparc_get_datacenters()
;
; INPUTS: none
;
; KEYWORD PARAMETERS:
;    status=status   returns a status structure
;
; OUTPUTS:
;    returns a strarr  containing the names of the datacenters
;
; COMMON BLOCKS:
;
; RESTRICTIONS:
;    uses ct_web_open, which may need additional resources.
;
; PROCEDURE:
;    
; EXAMPLE:
;   datacenters= sparc_get_datacenters(status=status)
;   
; MODIFICATION HISTORY:
;   written, Feb 25 2001, jbf, cottagesystems
;-

  status= sparc_get_status_struct()

  url= getenv('SPARC_REGISTRY')

  ct_web_open, unit, /get_lun, url
  if eof(unit) then begin
      status.code=-2
      status.message= 'Unexpected EOF on web read...  Check URL: '+url
      free_lun, unit
      return, -1
  endif
  
  datacenters= strarr(20)
  ni= n_elements( datacenters )
  aline=''
  i=0
  while not eof(unit) do begin
      readf, unit, aline
      datacenters[i]= aline
      i=i+1
      if i eq ni then begin
          datacenters= [ datacenters, strarr(10) ]
          ni= n_elements( datacenters )
      endif
  endwhile
  
  datacenters= datacenters[0:(i-1)]

  free_lun, unit

  status.code=0
  status.message=''

  return, datacenters

end
