function sparc_get_default_view, datacenter, name, status=status
;+
; NAME: sparc_get_default_view
;
; PURPOSE: get the default view for a sparc quantity
;
; CATEGORY: 
;
; CALLING SEQUENCE: view= sparc_get_default_view( datacenter, name )
; 
; INPUTS:
;    datacenter  name of data center.  
;                   eg 'sparc-dc2.si.umich.edu/sparc/DataCener'
;    name        name of data set      eg 'MillstoneHill.ISRadar'
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;    status=   outputs a status structure 
;
; OUTPUTS:
;    returns  string containing the view.
;
; COMMON BLOCKS:
;
; RESTRICTIONS/ASSUMPTIONS:
;    assumes ct_web_open is working properly
;
; PROCEDURE:
;    get meta, if meta.default_view is not defined, then ...???
;
; EXAMPLE:
;    view= sparc_get_default_view( 'sparc-dc2.si.umich.edu/sparc/DataCenter', $
;                                  'MillstoneHill.ISRadar', $
;                                  status=status )
;    if status.code ne 0 then message, status.message
;
; MODIFICATION HISTORY: 
;    written, jbf, cottagesystems, Apr 5 2001
;
;-

  meta= sparc_get_meta( datacenter, name, status=status )
  
  if status.code ne 0 then return, 'error'
      
  if strtrim(meta.default_view,2) ne '' then begin
      default_view= meta.default_view 
  endif else begin
      default_view= 'timeview'
  endelse

  return, default_view  

end


