function sparc_get_meta, datacenter, name, status=status

;+
; NAME: sparc_get_meta
;
; PURPOSE: queries the datacenter for the types of views available for
;    dataset "name" from sparc datacenter "datacenter."
;
; CATEGORY: sparc
;
; CALLING SEQUENCE: views= sparc_get_meta( datacenter, name )
; 
; INPUTS:
;    datacenter  name of data center.  
;                   eg 'sparc-dc2.si.umich.edu/sparc/DataCener'
;    name        name of data set      eg 'MillstoneHill.ISRadar'
;
; KEYWORD PARAMETERS:
;    status=   outputs a status structure.
;
; OUTPUTS:
;    returns  array of view structures.
;
; RESTRICTIONS/ASSUMPTIONS:
;    uses ct_web_open.
;
; PROCEDURE:
;    form URL for query, open channel, then parse output.
;
; EXAMPLE:
;    views= sparc_get_meta( 'sparc-dc2.si.umich.edu/sparc/DataCenter', $
;                            'MillstoneHill.ISRadar' )
;
; MODIFICATION HISTORY:
;    written, jbf, cottagesystems, Feb 25 2001
;-

  status= sparc_get_status_struct()

  url= "http://"+datacenter+"?name="+name+"&view=meta"

  ct_web_open, unit, /get_lun, url
  
  meta_info= { default_view:'', $
               info_url:'', $
               update:'' }
           
  line=''
  
  idx=0
  while not eof(unit) do begin
      readf, unit, line
      s= str_sep( line, '=' )
      case s[0] of
          'default': meta_info.default_view=s[1]
          'www': meta_info.info_url=s[1]
          'update': meta_info.update=s[1]
          else:
      endcase
      idx=1
  endwhile

  free_lun, unit

  if idx eq 0 then begin
      status.code= -2
      status.message='no meta information returned by datacenter'
      return, -1
  endif
  
  status.code=0
  status.message=''

  return, meta_info

end


