function sparc_get_options, datacenter, name, view, status=status

;+
; NAME: sparc_get_options
;
; PURPOSE: queries the datacenter for the types of views available for
;    dataset "name" from sparc datacenter "datacenter."
;
; CATEGORY: sparc
;
; CALLING SEQUENCE: options= sparc_get_options( datacenter, name, view )
; 
; INPUTS:
;    datacenter  name of data center.  
;                   eg 'sparc-dc2.si.umich.edu/sparc/DataCener'
;    name        name of data set      eg 'MillstoneHill.ISRadar'
;    view        name of view for data set.
;
; KEYWORD PARAMETERS:
;    status=   outputs a status structure.
;
; OUTPUTS:
;    returns   string that encodes the available options
;
; RESTRICTIONS/ASSUMPTIONS:
;    uses ct_web_open.
;
; PROCEDURE:
;    get views, and return option for correct view
;
; EXAMPLE:
;    options_code= $
;           sparc_get_options( 'sparc-dc2.si.umich.edu/sparc/DataCenter', $
;                              'MillstoneHill.ISRadar', $
;                              'timelinegif' )
;
; MODIFICATION HISTORY:
;    written, jbf, cottagesystems, Apr 5 2001
;-

  views= sparc_get_views( datacenter, name, status=status )
  
  if status.code ne 0 then return, 'error'

  idx= ( where( views.view eq view ) )[0]

  if idx eq -1 then begin
      status.code= -12
      status.message= 'Requested view '+view+' not found.'
      status.action= 'Views available: ' + views[0].view
      for i=1,n_elements(views)-1 do $
        status.action= status.action + ',' + views[i].view
      return, 'error'
  endif else begin
      options_code= views[idx].options
  endelse

  return, options_code

end


