;+
; NAME: sparc_get_timelinegif
;
; PURPOSE: get image of timelinegif for particular name
;
; CATEGORY: sparc
;
; CALLING SEQUENCE: 
;   image= sparc_get_timelinegif( datacenter, name, ctstart, ctend )
;
; INPUTS:
;   parameter     example   definition
;   datacenter    'http://sparc-dc9.si.umich.edu/sparc/DataCenter'
;                           datacenter serving the data
;   name          'pixie'   name of the data set
;   ctstart       10608.0   start time of interval in ct_time.
;   ctend         10610.0   end time of interval in ct_time.
;
; OPTIONAL INPUTS:
;
; KEYWORD PARAMETERS:
;   size        [ 380,100]  request size of the image, in pixels
;   /include_timeaxis       put the timeaxis as part of the image.
;
; OUTPUTS:
;   returns                 structure containing image and auxillary data.
;
; RESTRICTIONS:
;
; EXAMPLE:
;   image= sparc_get_timelinegif( $
;      'sparc-dc9.si.umich.edu/sparc/DataCenter', $
;      'pixie', $
;      10608.0, 10610.0 )
;
; MODIFICATION HISTORY:
;   written, feb 23, 2001, jbf, cottagesystems
;-

pro testit
  COMPILE_OPT idl2, HIDDEN
  image= sparc_get_timelinegif( $
                                'sparc-dc9.si.umich.edu/sparc/DataCenter', $
                                'pixie', $
                                10608.0, 10610.0, $
                                size=[640,200], $
                                /include_timeaxis $
                              )
  tv, image, /true
end

function sparc_get_timelinegif, dataCenter, name, ctstart, ctend, $
                                size=size, status=status, $
                                include_timeaxis=include_timeaxis

  COMPILE_OPT idl2

  status= sparc_get_status_struct()

  if n_elements(size) eq 0 then ssize='' else $
    ssize='&size='+strtrim(size[0],2)+','+strtrim(size[1],2)

  if keyword_set(include_timeaxis) then spart= '' else spart= '&part=g'
      
  view= 'timelinegif'
  url= 'http://'+dataCenter+$
    '?name='+name+$
    '&view='+view+$
    ssize+$
    spart+$
    '&time='+ct_time_to_sparc(ctstart)+$
    '-'+ct_time_to_sparc(ctend)

  ct_web_open, unit, url, /get_lun

  if eof(unit) then begin
      status.code= -2
      status.message= 'Unexpected eof on web read...  Check URL: '+url
      free_lun, unit
      return, -1
  endif

  ct_read_gif, unit, image, red, green, blue
  free_lun, unit

  image_str= { image: image, $
               red:red, $
               green:green, $
               blue:blue }

  s= size( image )
  image3= bytarr( 3, s[1], s[2] )
  image3[0,*,*]= red[image]
  image3[1,*,*]= green[image]
  image3[2,*,*]= blue[image]

  status.code=0
  status.message=''

  return, image3

end

