function sparc_get_views, datacenter, name, status=status

;+
; NAME: sparc_get_views
;
; PURPOSE: queries the datacenter for the types of views available for
;    dataset "name" from sparc datacenter "datacenter."
;
; CATEGORY: sparc
;
; CALLING SEQUENCE: views= sparc_get_views( datacenter, name )
; 
; INPUTS:
;    datacenter  name of data center.  
;                   eg 'sparc-dc2.si.umich.edu/sparc/DataCener'
;    name        name of data set      eg 'MillstoneHill.ISRadar'
;
; KEYWORD PARAMETERS:
;    status=   outputs a status structure.
;
; OUTPUTS:
;    returns  array of view structures.
;
; RESTRICTIONS/ASSUMPTIONS:
;    uses ct_web_open.
;
; PROCEDURE:
;    form URL for query, open channel, then parse output.
;
; EXAMPLE:
;    views= sparc_get_views( 'sparc-dc2.si.umich.edu/sparc/DataCenter', $
;                            'MillstoneHill.ISRadar' )
;
; MODIFICATION HISTORY:
;    written, jbf, cottagesystems, Feb 25 2001
;-

  status= sparc_get_status_struct()

  url= "http://"+datacenter+"?name="+name+"&view=view&option=list"

  ct_web_open, unit, /get_lun, url
  
  aview= { view:'', $
           descriptor:'', $
           type:'', $
           options:'' }
           
  line=''
  
  views= replicate( aview, 15 )
  
  idx=0
  while not eof(unit) do begin
      readf, unit, line
      ii= strpos( line, '|~' )
      s2= str_sep( strmid(line,0,ii), '|' )
      views[idx].view= s2[0]
      views[idx].descriptor= s2[1]
      s2= strmid(line,ii+2,strlen(line)-ii-2)
      ii= strpos( s2,'~')
      views[idx].type= strmid( s2,0,ii )
      views[idx].options= strmid( s2,ii+1, strlen(s2)-ii-1 )
      idx= idx+1
      if idx ge n_elements( views ) then begin
          views= [ views, replicate( aview, 5 ) ]
      endif
  endwhile

  free_lun, unit

  if idx gt 0 then begin
      views= views[0:(idx-1)]
  endif else begin
      status.code= -2
      status.message='no views returned by datacenter'
      return, -1
  endelse

  status.code=0
  status.message=''

  return, views

end


