pro ct_draw_time_axis, panel, $
                       NTICKS=N, XTICKVALS=VALS, MINOR=mn, $
                       color=color_, $
                       _extra=extra_par

message,'not done.'
; aborted while I can't think anymore.

  common mjdt, mjdt_start, mjdt_end
  common shift_label, down      ;common for x-axis label shifting
  common plot_composer, widgetData
  
  color=1 ; color is always black
  
  starttime= double(mjdt_start.t)
  endtime  = (mjdt_end.mjd - mjdt_start.mjd)*86400.0d + double(mjdt_end.t) 
  
  ct_start= ct_time( mjdt_start, /mjdt )
  ct_end= ct_time( mjdt_end, /mjdt )
  ct_get_ticks, ct_start, ct_end, $
    xtickvals, xminorticks, tickformat=xtickformatstring
  nticks=n_elements(xtickvals) 

  xtickvals= xtickvals * 86400 - ct_start
  case xtickformat of
      'tick_ct_hms': xtickformat=
      'tick_ct_hour_minute': xtickformat=
      'tick_ct_date_hour': xtickformat=
      'tick_ct_date': xtickformat=

  ;check for panel being bottom panel, which needs time axis.
  if panel(0) gt 0 then begin 
      xtickformat='noticks'
  endif

  ;keep old time range for setting plot for old time coords
  old_range=extra_par.xrange
  extra_par.xrange=[starttime, endtime]
  
  mjdt_now=mjdt_start 
  for i=0,nticks-1 do begin
    t=xtickvals(i)
    add_days = t / 86400l
    add_sec  = t mod 86400l
    mjdt_now.mjd = mjdt_start.mjd + add_days
    mjdt_now.t   = add_sec
    if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
    endif
    convert_t90_to_date,mjdt_now, $
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt
    date_str1=string(dom,cmonth,format="(i2.2,a3)")
    date_str2=string(hour,minutes,format="(i2.2,':',i2.2)")
    ;message, date_str1+ '  '+date_str2, /cont
  endfor  
  
  extra_par=create_struct({xticks:nticks-1,xtickno:nticks-1,$
                           xtickv:xtickvals,xminor:xminorticks}, $
                           extra_par)
  
  plot, [starttime, endtime], [0,1], _extra=extra_par, /NODATA
    
  ;not set plot with old range
  extra_par.xrange=old_range
  plot, old_range, [0,1], XSTYLE=5,YSTYLE=5, $
    xrange=old_range,yrange=extra_par.yrange, /NODATA
  
  down=2
  
  ;draw the xsidelabel
  if panel(0) eq 0 then begin
    if widgetData.default_XLINES eq 1 then begin
      if xtickformatstring eq 'mjdt_ddmmmyyyy' then $
        x_side_label,panel,'Date' else $
        x_side_label,panel,'Time' 
      down=1
    endif else begin  
      x_side_label,panel,'Time!CDate'
      down=2
    endelse
  endif  
  
  n=nticks
  vals=xtickvals
  mn=xminorticks
  
end


