pro draw_sparc_image, panelVector, aPlotInfo, orbitNo, $
                      get_data_call, slice_type, IsRead, $
                      OUTPUT=OUTPUT

  COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure
  common mjdt, mjdt_start, mjdt_end     ;common time limit in mjdt
  common coordinateSystems, plotted_x, plotted_y
    
  get_data_call=""   ; data read call used by slices

  canslice=0

; set up which mouse functions to allow
  slice_type=1+canslice*2+16

  subtable= extra_PlotInfo.subtable
  panelset, panelVector         ; set the position vector
  papco_set_subtable, subtable
  
  dataCenter= aPlotInfo.soptions[0]
  name= aPlotInfo.soptions[1]
  view= aPlotInfo.soptions[2]
  descriptor= aPlotInfo.soptions[3]
  options= aPlotInfo.soptions[4]

  if dataCenter eq '' or name eq '' then begin
      status= sparc_get_status_struct()
      status.message= 'Data set has not been selected.'
      status.location= 'operator needs to select data set in panel editor'
      sparc_abend, status
      return
  endif

  if view eq 'default' then begin
      view= sparc_get_default_view( dataCenter, name, status=status )      
      if status.code ne 0 then begin
          sparc_abend, status
          return
      endif
  endif
  
  check_view_type=0
  if check_view_type then begin
      r= where( views.view eq meta.default_view )
      if views[r>0].type ne 'image/gif' or r[0] eq -1 then begin        
          status= sparc_get_status_struct()
          if meta.default_view eq '' then begin
              status.message= 'default view not defined for '+ name 
          endif else begin
              status.message=  'Data set is not visible with this panel.' + $
                'name= '+name+ $
                'default view= '+meta.default_view
          endelse
          sparc_abend, status
          return
      endif
  endif
  
  ct_start= ct_time( mjdt_start, /mjdt )
  ct_end= ct_time( mjdt_end, /mjdt )
  
  p_sparc_image, dataCenter, name, view, $
    ct_start, ct_end, draw_timeaxis= panelVector[0] eq 0, $
    options=options
  
  plotted_x = !x  &  plotted_y = !y 
  
END

