pro sparc_abend, status, text_only=text_only

  common papco_color_names

  plot= not keyword_set( text_only )

  if status.code ne 0 then begin

      print, '-------------------------------------------
      print, 'Error encountered while plotting sparc:

      nlines= max( where( status.message ne '' ) )
      for i=0,nlines do $
        print, status.message[i]

      if plot then begin
          ch=1.2 ; character size
          
          plot, [0,1,1,0,0], [0,0,1,1,0], xstyle=5, ystyle=5, /noclip, $
            linestyle=1, color= dark_grey
          
          dd= convert_coord( [ 0.05, 0.90 ], /data, /to_device )
          irow= dd[1]

          xyouts, charsize=ch*1.2, dd[0], irow, /device, $
            'Error encountered while plotting sparc:', color=1
          irow= irow-!d.y_ch_size*ch*1.2

          for i=0,nlines do begin
              xyouts, charsize=ch, dd[0], irow, /device, status.message[i], $
                color=1
              irow= irow-!d.y_ch_size*ch
          endfor
      endif
      
      nlines= max( where( status.action ne '' ))
      for i=0,nlines do begin
          print, status.action[i]
          if plot then begin
              xyouts, charsize=ch, dd[0], irow, /device, status.action, color=1
              irow= irow-!d.y_ch_size*ch
          endif
      endfor
      
      irow= irow-!d.y_ch_size/2*ch

      print, 'status.code: '+ strtrim(status.code,2)
      print, 'from: '+status.location

      if plot then begin
          xyouts, dd[0], irow, /device, $
            'status.code: '+strtrim(status.code,2) + '!c' + $
            'from: '+status.location, $
            charsize= ch*0.8, color=1
      endif
      
      print, '-------------------------------------------

      if plot then begin
          common coordinateSystems, plotted_x, plotted_y
          plotted_x = !x  &  plotted_y = !y 
      endif      

  endif
end
