;+
; NAME: sparc_image_panel
;
; PURPOSE: modifies the papco panel state
;
; CATEGORY: papco/sparc
;
; CALLING SEQUENCE: 
;
; INPUTS:
;      aPlotInfo       a structure of the papco_plotinfo-type
;                      this structure is edited in the panel editor window.
;
; OPTIONAL INPUTS:
;
; KEYWORD PARAMETERS:
;      GROUP           a WIDGET_BASE
;                      when specified, this is used as GROUP_LEADER
;      ACTION          a string
;                      when specified, the 'Done'-Button is labeled with it
;                      if not specified, the 'Done'-Button is labeled 'Done'
;
; OUTPUTS:
;      returns modified PlotInfo structure.
;
; EXAMPLE:
;      a= papco_getPlotInfoStruct()
;      a= sparc_image_panel( a )
;
; MODIFICATION HISTORY:
;     jbf, cottagesystems, Feb 24, 2001:
;       Original template from papco 10.0 
;       template modified to use IDL doc_header.
;       common block removed and uvalue will be used to store widget state.
;     
;-

PRO sparc_image_panel_event, event

  COMPILE_OPT idl2, hidden
  
;  the state of the widget is stored as the uvalue of the first
;  child widget, a commonly used convention in IDL.  This allows 
;  for multiple instances of the panel.  Though PaPCo 10 does not
;  need this functionality, future versions may.

  id_child= widget_info(event.top,/child)
  widget_control, id_child, get_uvalue=p_widgetData
  widgetData= *p_widgetData

;  get the uvalue of the event, which identifies the action to
;  perform.  The developer may wish to manufacture an event by
;  sending a structure with the tags "top," the panel widget base
;  id, and "uvalue."  E.g.: { top:id_base, uvalue:'reset' }

  if ( where( tag_names(event) eq 'UVALUE' ))[0] ne -1 then begin
      uval= event.uvalue
  endif else begin
      widget_control, get_uvalue=uval, event.id
  endelse

  common sparc_registry_common_1, registry_id, registry

  s= str_sep( uval, ':' )
  uval=s[0]
  if n_elements(s) gt 1 then arg=s[1]

  case uval of 
      'display_by': begin
          widgetData.ioptions[2]= long(arg)
          case widgetData.ioptions[2] of
              0: names= registry[*].name
              1: names= registry[*].descriptor
          end
          widget_control, widgetData.id_select, set_value=names

          idx= (where( widgetData.soptions[1] eq registry.name ))[0]
          if idx ne -1 then $
            widget_control, widgetData.id_select, set_list_select= idx
          
      end
      'sort': begin
          case widgetData.ioptions[2] of
              0: names= registry[*].name
              1: names= registry[*].descriptor
          end
          s= sort( strlowcase( names ) )
          registry= registry[s]
          names=names[s]
          widget_control, widgetData.id_select, set_value=names

          idx= (where( widgetData.soptions[1] eq registry.name ))[0]
          if idx ne -1 then $
            widget_control, widgetData.id_select, set_list_select= idx
      end
      'reset': begin
          registry= sparc_get_registry(status=status,$
                                       id_message=widgetData.id_select )
          if status.code ne 0 then begin
              message, status.message, /cont
              r= widget_message( [ 'Sparc Registry is not available.  ', $
                                   'Try again later.' ] )
              return
          endif

          case widgetData.ioptions[2] of
              0: names= registry[*].name
              1: names= registry[*].descriptor
          end
          widget_control, widgetData.id_select, set_value=names      

          idx= (where( widgetData.soptions[1] eq registry.name ))[0]
          if idx ne -1 then $
            widget_control, widgetData.id_select, set_list_select= idx
      end
      'views_list_insensitive': begin
          if event.index eq 1 then begin
              sparc_image_panel_event, { top:event.top, uvalue:'views' }
          endif
      end
      'select': begin
          registry_idx= event.index
          registry1= registry[registry_idx]

          new_selection= ( widgetData.soptions[0] ne registry1.dataCenter or $
                           widgetData.soptions[1] ne registry1.name ) 
          
          widgetData.soptions[0]= registry1.dataCenter
          widgetData.soptions[1]= registry1.name

          widgetData.soptions[3]= registry1.descriptor
          widgetData.ioptions[0]= registry_id
          widgetData.ioptions[1]= registry_idx

          widget_control, widgetData.id_views, sensitive=1
          if new_selection then begin
              widgetData.soptions[2]= 'default'          
              widget_control, widgetData.id_views_list, $
                set_value= [ 'default_view       ', 'download list' ]
              widget_control, widgetData.id_views_list, $
                set_uvalue= 'views_list_insensitive'
          endif
          
          widget_control, widgetData.id_options, sensitive=1
          
          if new_selection then begin
              widgetData.soptions[4]=''
              widgetData.soptions[5]=''
          endif


          widget_control, widgetData.id_availability, sensitive=1
          widget_control, widgetData.id_availability_list, $
            set_value=['Check data availability']          
      end
      'views': begin
          if widgetData.soptions[2] eq 'default' then begin
              widgetData.soptions[2]= $
                sparc_get_default_view(  widgetData.soptions[0], $
                                         widgetData.soptions[1], $
                                         status=status )
              if status.code ne 0 then begin
                  sparc_abend, status, /text_only
                  return
              endif
          endif
          widget_control, widgetData.id_views_list, $
            set_value=['downloading...']
          wait, 0.2 ; let the operator see whats happening
          views= sparc_get_views( widgetData.soptions[0], $
                                  widgetData.soptions[1] ) 
          
          r= where( views.type eq 'image/gif' and $
                    views.view ne 'animatedgif' )
          if r[0] ne -1 then begin
              views= views[r]
          endif else begin
              x= widget_message( [ 'There are no viewable Graph types!', $
                                   'Select a different quantity.' ], $
                                 dialog_parent=event.top )
              return
          endelse
          if n_elements(views) ge 10 then views= views[0:9]

          n=n_elements(views)
          widgetData.views_list[0:(n-1)]= views[*].view
          widgetData.views_descriptor_list[0:(n-1)]= views[*].descriptor
          views_str= views[*].descriptor
          widget_control, widgetData.id_views_list, set_value=views_str
          idx= ( where( widgetData.soptions[2] eq views.view ) )[0]
          if idx ne -1 then begin
              widget_control, widgetData.id_views_list, $
                set_droplist_select= idx
              widgetData.soptions[6]= views[idx].descriptor
          endif
          widget_control, widgetData.id_views_list, set_uvalue='views_list'
      end
      'views_list': begin
          widgetData.soptions[2]= widgetData.views_list[event.index]
          widgetData.soptions[6]= widgetData.views_descriptor_list[event.index]
      end
      'options': begin
          if widgetData.soptions[2] eq 'default' then begin
              widgetData.soptions[2]= $
                sparc_get_default_view( widgetData.soptions[0], $
                                        widgetData.soptions[1], $
                                        status=status )
              if status.code ne 0 then begin
                  sparc_abend, status, /text_only
                  return
              endif
          endif
          if widgetData.soptions[2] ne '' then begin  
              if  widgetData.soptions[5] eq '' then begin
                  widgetData.soptions[5]= $
                    sparc_get_options( widgetData.soptions[0], $
                                       widgetData.soptions[1], $
                                       widgetData.soptions[2], $
                                       status=status )
                  if status.code ne 0 then begin
                      widgetData.soptions[5]=''
                      sparc_abend, status
                      return
                  endif
              endif
              options= sparc_parse_options( widgetData.soptions[5] )
              options= sparc_options_widget( options, $
                                             group=event.top ) ; modal
              r= where( options.name ne 'time' and $
                        options.name ne 'size' ) 
              widgetData.soptions[4]= sparc_options_url( options[r] )
              widgetData.soptions[5]= sparc_options_string( options )
          endif else begin
              x= widget_message( [ 'No default view.', $
                                   'options unavailable.' ], $
                                 dialog_parent=event.top )
          endelse
      end
      'availability': begin
          x= sparc_data_availability(widgetData.soptions[0], $
                                     widgetData.soptions[1], $
                                     status=status ) 
          if status.code eq 0 then begin
              widget_control, widgetData.id_availability_list, $
                set_value= [ ct_time_string(x[0].time_start) + '-', $
                             ct_time_string(x[1].time_start + $
                                            x[1].time_width) ]
          endif
      end
      else: $        ; this event is from a papco widget, send it on...
        widgetData=papco_panel_Event(event, widgetData)
  endcase
  
  *p_widgetData= widgetData
    
END


FUNCTION  sparc_image_panel, aPlotInfo, GROUP=group, ACTION=ACTION

  COMPILE_OPT idl2, hidden

;--- if GROUP is not specified, the group-leader will be the desktop
  IF NOT KEYWORD_SET(GROUP) THEN GROUP=0

;--- set the label for the action-button
  IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'

; additionalwData are the panel-specific data that are added by the 
; developer.  This gets added with PaPCo's data to form widgetData.
  additionalwData={canceled:1}

  panel_base=papco_WIDGET_BASE(title=aPlotInfo.panelKind, column=1, $
                               GROUP_LEADER=group, /MODAL)

  child= widget_base( panel_base )  ; store widget info here as uvalue

  widgets=papco_panel_AddHeightWidgets(panel_base, aPlotInfo)
  additionalwData=create_struct(widgets, additionalwData)
   
;  Sparc-specific widgets begin here
  local_base= widget_base( panel_base, column=1 )
  local_data= { id_message:0L, $
                id_select:0L, $
                id_views:0L, $
                id_views_list:0L, $
                id_field:0L, $
                id_options:0L, $
                id_availability:0L, $
                id_availability_list:0L, $
                id_base_options:0L, $
                views_list:strarr(10), $ 
                views_descriptor_list:strarr(10) }

  button_base= widget_base( local_base, row=1 )
  id_registry= widget_button( button_base, value='Reset',uvalue='reset')

  base_display_by_super= widget_base( local_base, /row )
  base_display_by= widget_base( base_display_by_super, /row, /exclusive )
  b= lonarr(2)
  b[0]= widget_button( base_display_by, value='name', uvalue='display_by:0' )
  b[1]= widget_button( base_display_by, value='description', $
                       uvalue='display_by:1' )
  widget_control, b[aplotInfo.ioptions[2]], set_button=1

  x= widget_button( base_display_by_super, value='Sort', uvalue='sort' )

  names= strarr(10)
  names[3]= '  Initializing...                          '+$
    '                           '
  local_data.id_select= $
    widget_list( local_base, xsize=70, ysize=7, value=names, uvalue='select')
  local_data.id_message= local_data.id_select

  name_actions_base= widget_base( local_base, /column )

  views_base= widget_base( name_actions_base )
  local_data.id_views= widget_button( views_base, $
                                      value='Views', uvalue='views', $
                                      xsize=100, xoffset=0, ysize=40 )
  widget_control, local_data.id_views, sensitive=0
  
  local_data.id_views_list= $
    widget_droplist( views_base, xsize=30, $
                     xoffset=103, $                     
                     value=['-------------------------'] )

  widget_control, local_data.id_views_list, $
    set_value= [ aplotInfo.soptions[6], 'download list' ]
  widget_control, local_data.id_views_list, $
    set_uvalue= 'views_list_insensitive'
  
  availability_base= widget_base( name_actions_base )
  local_data.id_availability= $
    widget_button( availability_base, $
                   value='Availability', uvalue='availability', $
                   xsize=100, xoffset=0, ysize=40 )
  widget_control, local_data.id_availability, sensitive=0
  local_data.id_availability_list= $
    widget_text( availability_base, ysize=2, xsize=30, $
                 xoffset=103, $
                 value=['Check data availability', $
                        '' ] )
  
  options_base= widget_base( name_actions_base )
  local_data.id_options= $
    widget_button( options_base, $
                   value='Options', uvalue='options', $
                   xsize=100, xoffset=0, ysize=40 )
  widget_control, local_data.id_options, sensitive=0
;  local_data.id_base_options= widget_base( options_base, map=0, $
;                                           xoffset=103 )

  additionalwdata= create_struct( additionalwdata, local_data )

; end, Sparc-specific widgets

   
;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window. This is needed for all panel editors. If you want to 
;    make use of the configure feature, then add the keyword CONFIG
  widgets=papco_panel_AddActionButtons(panel_base, Action, aPlotInfo, /CONFIG)
  additionalWData=create_struct(widgets, additionalWData)

;--- now, create the structure that keeps the panel-window data. You always
;    need to specify the help-file, and your structure must contain the
;    'additionalWData'. You should create the helpfile in the papco_interface
;    directory of your module (a template is in the sparc example module)
;    Also add the ID's of your widgets so that you can perform widget_control
;    actions in the events routine or in a refresh routine if needed.
  thisWidgetsData={helpfile:'sparc_image_panel.help', $
                   typevector:aPlotInfo.typevector, $
                   ioptions:aPlotInfo.ioptions, $
                   options:aPlotInfo.options, $
                   soptions:aPlotInfo.soptions }

  widgetData=papco_panel_CreateWidgetData(thisWidgetsData, additionalWData)

;--- realize the window -------------------------------------------------------
  papco_Panel_Realize, panel_base, widgetData  

  p_widgetData= ptr_new( widgetData )
  widget_control, child, set_uvalue=p_widgetData

  common sparc_registry_common_1, registry_id, registry
  if n_elements( registry_id ) eq 0 then begin
      registry= sparc_get_registry(status=status,$
                                   id_message=widgetData.id_message )
      if status.code ne 0 then begin
          message, status.message, /cont
          message= [ 'Sparc Registry is not available.  ', $
                     'Try again later.', $
                     'SPARC_REGISTRY= '+getenv('SPARC_REGISTRY') ]
          r= widget_message( message )
          widget_control, widgetData.id_select, set_value=['',message]
          registry= replicate( { registry_struct }, 1 )
      endif else begin
          registry_id= long( systime(1) ) 
      endelse
  end

  if n_elements( registry_id ) ne 0 then begin
      case aplotInfo.ioptions[2] of
          0: names= registry[*].name
          1: names= registry[*].descriptor
      end
      
      widget_control, widgetData.id_select, set_value=names
      
      idx= (where( widgetData.soptions[1] eq registry[*].name ))[0]
      if idx ne -1 then begin
          widget_control, widgetData.id_select, set_list_select= idx
          sparc_image_panel_event, $
            { top:panel_base, index:idx, uvalue:'select' }
      endif
  endif

  papco_xmanager, 'sparc_image_panel', panel_base

  widgetData= *p_widgetData
  ptr_free, p_widgetData

;--- the returned data consists of the standard-data inherited from
;    papco_panel.pro and your new data.  You must use the tags
;    provided by PaPCo, otherwise your data will not be saved
;    in the .papco files!

  returnData={typevector:widgetData.typevector, $
              ioptions:widgetData.ioptions, $
              options:widgetData.options, $
              soptions:widgetData.soptions $
             }
  additionalRData=papco_panel_ReturnData(widgetData)

  return, create_struct(ReturnData, additionalRData)
   
END




